/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.instances;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.baseclasses.Point3i;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.rendering.instances.RenderDecor;
import minecrafttransportsimulator.sound.IRadioProvider;
import minecrafttransportsimulator.sound.Radio;
import minecrafttransportsimulator.sound.SoundInstance;

public class TileEntityDecor
extends ATileEntityBase<JSONDecor>
implements IRadioProvider {
    public final BoundingBox[] boundingBoxes = new BoundingBox[4];
    private final Radio radio;
    private final FloatBuffer soundPosition;
    private final Point3d soundVelocity = new Point3d(0.0, 0.0, 0.0);

    public TileEntityDecor(IWrapperWorld world, Point3i position, IWrapperNBT data) {
        super(world, position, data);
        this.boundingBoxes[0] = new BoundingBox(new Point3d(0.0, 0.0, 0.0), (double)((JSONDecor.DecorGeneral)((JSONDecor)this.definition).general).width / 2.0, (double)((JSONDecor.DecorGeneral)((JSONDecor)this.definition).general).height / 2.0, (double)((JSONDecor.DecorGeneral)((JSONDecor)this.definition).general).depth / 2.0);
        this.boundingBoxes[1] = new BoundingBox(new Point3d(0.0, 0.0, 0.0), (double)((JSONDecor.DecorGeneral)((JSONDecor)this.definition).general).depth / 2.0, (double)((JSONDecor.DecorGeneral)((JSONDecor)this.definition).general).height / 2.0, (double)((JSONDecor.DecorGeneral)((JSONDecor)this.definition).general).width / 2.0);
        this.boundingBoxes[2] = this.boundingBoxes[0];
        this.boundingBoxes[3] = this.boundingBoxes[1];
        if (((JSONDecor.DecorGeneral)((JSONDecor)this.definition).general).type != null && ((JSONDecor.DecorGeneral)((JSONDecor)this.definition).general).type.equals("radio")) {
            this.soundPosition = ByteBuffer.allocateDirect(12).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.soundPosition.put(position.x);
            this.soundPosition.put(position.y);
            this.soundPosition.put(position.z);
            this.soundPosition.flip();
            this.radio = new Radio(this, data);
        } else {
            this.soundPosition = null;
            this.radio = null;
        }
    }

    @Override
    public void remove() {
        super.remove();
        if (this.radio != null) {
            this.radio.stop();
        }
    }

    public RenderDecor getRenderer() {
        return new RenderDecor();
    }

    @Override
    public void save(IWrapperNBT data) {
        super.save(data);
        if (this.radio != null) {
            this.radio.save(data);
        }
    }

    @Override
    public void startSounds() {
    }

    @Override
    public void updateProviderSound(SoundInstance sound) {
    }

    @Override
    public FloatBuffer getProviderPosition() {
        return this.soundPosition;
    }

    @Override
    public Point3d getProviderVelocity() {
        return this.soundVelocity;
    }

    @Override
    public IWrapperWorld getProviderWorld() {
        return this.world;
    }

    @Override
    public Radio getRadio() {
        return this.radio;
    }
}

