/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.instances;

import minecrafttransportsimulator.baseclasses.FluidTank;
import minecrafttransportsimulator.baseclasses.IFluidTankProvider;
import minecrafttransportsimulator.baseclasses.Point3i;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityTickable;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.instances.PacketTileEntityFluidLoaderConnection;
import minecrafttransportsimulator.rendering.instances.RenderDecor;
import minecrafttransportsimulator.vehicles.main.AEntityBase;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartInteractable;

public class TileEntityFluidLoader
extends ATileEntityBase<JSONDecor>
implements ITileEntityTickable,
IFluidTankProvider {
    public PartInteractable connectedPart;
    public boolean unloadMode;
    public boolean loading;
    public boolean unloading;
    private FluidTank tank;

    public TileEntityFluidLoader(IWrapperWorld world, Point3i position, IWrapperNBT data) {
        super(world, position, data);
        this.tank = new FluidTank(data, 15000, world.isClient());
        this.unloadMode = data.getBoolean("unloadMode");
    }

    @Override
    public void update() {
        if (!this.world.isClient()) {
            if (this.connectedPart == null) {
                if (this.world.getTime() % 20L == 0L) {
                    this.updateNearestPart();
                }
            } else {
                if (!this.connectedPart.vehicle.isValid || !this.connectedPart.isValid || this.connectedPart.worldPos.distanceTo(this.position) > 10.0) {
                    this.updateNearestPart();
                }
                if (this.unloadMode) {
                    String fluidToUnload = this.connectedPart.tank.getFluid();
                    double amountToUnload = this.connectedPart.tank.drain(fluidToUnload, 100.0, false);
                    if (amountToUnload > 0.0) {
                        amountToUnload = this.tank.fill(fluidToUnload, amountToUnload, true);
                        this.connectedPart.tank.drain(fluidToUnload, amountToUnload, true);
                    } else {
                        this.updateNearestPart();
                    }
                } else {
                    String fluidToLoad = this.tank.getFluid();
                    double amountToLoad = this.connectedPart.tank.fill(fluidToLoad, 100.0, false);
                    if (amountToLoad > 0.0) {
                        amountToLoad = this.tank.drain(fluidToLoad, amountToLoad, true);
                        this.connectedPart.tank.fill(fluidToLoad, amountToLoad, true);
                    } else {
                        this.updateNearestPart();
                    }
                }
            }
        }
    }

    private void updateNearestPart() {
        PartInteractable nearestPart = null;
        double nearestDistance = 999.0;
        if (this.tank.getFluidLevel() > 0.0 && !this.unloadMode || this.tank.getFluidLevel() < (double)this.tank.getMaxLevel() && this.unloadMode) {
            for (AEntityBase entity : AEntityBase.createdServerEntities) {
                if (!(entity instanceof EntityVehicleF_Physics) || !(entity.position.distanceTo(this.position) < 100.0)) continue;
                for (APart part : ((EntityVehicleF_Physics)entity).parts) {
                    FluidTank partTank;
                    if (!(part.worldPos.distanceTo(this.position) < 10.0) || !(part instanceof PartInteractable) || (partTank = ((PartInteractable)part).tank) == null) continue;
                    if (this.unloadMode) {
                        if (!(partTank.drain(this.tank.getFluid(), 1.0, false) > 0.0) || !(part.worldPos.distanceTo(this.position) < nearestDistance)) continue;
                        nearestPart = (PartInteractable)part;
                        continue;
                    }
                    if (!(partTank.fill(this.tank.getFluid(), 1.0, false) > 0.0) || !(part.worldPos.distanceTo(this.position) < nearestDistance)) continue;
                    nearestPart = (PartInteractable)part;
                }
            }
        }
        if (nearestPart != null) {
            this.connectedPart = nearestPart;
            MasterLoader.networkInterface.sendToAllClients(new PacketTileEntityFluidLoaderConnection(this, true));
        } else if (this.connectedPart != null) {
            MasterLoader.networkInterface.sendToAllClients(new PacketTileEntityFluidLoaderConnection(this, false));
            this.connectedPart = null;
        }
    }

    @Override
    public FluidTank getTank() {
        return this.tank;
    }

    public RenderDecor getRenderer() {
        return new RenderDecor();
    }

    @Override
    public void save(IWrapperNBT data) {
        super.save(data);
        this.tank.save(data);
        data.setBoolean("unloadMode", this.unloadMode);
    }
}

