/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.instances;

import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.FluidTank;
import minecrafttransportsimulator.baseclasses.IFluidTankProvider;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.baseclasses.Point3i;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityTickable;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.packets.instances.PacketTileEntityFuelPumpConnection;
import minecrafttransportsimulator.rendering.instances.RenderDecor;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;

public class TileEntityFuelPump
extends ATileEntityBase<JSONDecor>
implements ITileEntityTickable,
IFluidTankProvider {
    public EntityVehicleF_Physics connectedVehicle;
    private FluidTank tank;

    public TileEntityFuelPump(IWrapperWorld world, Point3i position, IWrapperNBT data) {
        super(world, position, data);
        this.tank = new FluidTank(data, 15000, world.isClient());
    }

    @Override
    public void update() {
        block9: {
            if (this.connectedVehicle == null || this.world.isClient()) break block9;
            if (!this.connectedVehicle.isValid) {
                this.connectedVehicle.beingFueled = false;
                this.connectedVehicle = null;
                return;
            }
            if (this.connectedVehicle.position.distanceTo(this.position) > 20.0) {
                MasterLoader.networkInterface.sendToAllClients(new PacketTileEntityFuelPumpConnection(this, false));
                for (IWrapperEntity entity : this.world.getEntitiesWithin(new BoundingBox(new Point3d(this.position), 25.0, 25.0, 25.0))) {
                    if (!(entity instanceof IWrapperPlayer)) continue;
                    ((IWrapperPlayer)entity).sendPacket(new PacketPlayerChatMessage("interact.fuelpump.toofar"));
                }
                this.connectedVehicle.beingFueled = false;
                this.connectedVehicle = null;
                return;
            }
            if (this.tank.getFluidLevel() > 0.0) {
                double amountToFill = this.connectedVehicle.fuelTank.fill(this.tank.getFluid(), 10.0, false);
                if (amountToFill > 0.0) {
                    double amountToDrain = this.tank.drain(this.tank.getFluid(), amountToFill, false);
                    this.connectedVehicle.fuelTank.fill(this.tank.getFluid(), amountToDrain, true);
                    this.tank.drain(this.tank.getFluid(), amountToDrain, true);
                } else {
                    MasterLoader.networkInterface.sendToAllClients(new PacketTileEntityFuelPumpConnection(this, false));
                    this.connectedVehicle.beingFueled = false;
                    this.connectedVehicle = null;
                    for (IWrapperEntity entity : this.world.getEntitiesWithin(new BoundingBox(new Point3d(this.position), 16.0, 16.0, 16.0))) {
                        if (!(entity instanceof IWrapperPlayer)) continue;
                        ((IWrapperPlayer)entity).sendPacket(new PacketPlayerChatMessage("interact.fuelpump.complete"));
                    }
                }
            } else {
                MasterLoader.networkInterface.sendToAllClients(new PacketTileEntityFuelPumpConnection(this, false));
                this.connectedVehicle.beingFueled = false;
                this.connectedVehicle = null;
                for (IWrapperEntity entity : this.world.getEntitiesWithin(new BoundingBox(new Point3d(this.position), 16.0, 16.0, 16.0))) {
                    if (!(entity instanceof IWrapperPlayer)) continue;
                    ((IWrapperPlayer)entity).sendPacket(new PacketPlayerChatMessage("interact.fuelpump.empty"));
                }
            }
        }
    }

    @Override
    public FluidTank getTank() {
        return this.tank;
    }

    public RenderDecor getRenderer() {
        return new RenderDecor();
    }

    @Override
    public void save(IWrapperNBT data) {
        super.save(data);
        this.tank.save(data);
    }
}

