/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.instances;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.Point3i;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityPole_Component;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole_Core;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole_Sign;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole_StreetLight;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole_TrafficSignal;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.instances.ItemPoleComponent;
import minecrafttransportsimulator.jsondefs.JSONPoleComponent;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.rendering.instances.RenderPole;
import minecrafttransportsimulator.systems.PackParserSystem;

public class TileEntityPole
extends ATileEntityBase<JSONPoleComponent> {
    public final Map<ABlockBase.Axis, ATileEntityPole_Component> components = new HashMap<ABlockBase.Axis, ATileEntityPole_Component>();

    public TileEntityPole(IWrapperWorld world, Point3i position, IWrapperNBT data) {
        super(world, position, data);
        for (ABlockBase.Axis axis : ABlockBase.Axis.values()) {
            String packID = data.getString("packID" + axis.ordinal());
            if (packID.isEmpty()) continue;
            String systemName = data.getString("systemName" + axis.ordinal());
            ATileEntityPole_Component newComponent = TileEntityPole.createComponent((ItemPoleComponent)PackParserSystem.getItem(packID, systemName));
            this.components.put(axis, newComponent);
            if (newComponent.getTextLines() == null) continue;
            newComponent.setTextLines(data.getStrings("textLines", newComponent.getTextLines().size()));
        }
    }

    public void updateLightState() {
        float calculatedLevel = 0.0f;
        for (ATileEntityPole_Component component : this.components.values()) {
            calculatedLevel = Math.max(calculatedLevel, component.lightLevel());
        }
        if (this.lightLevel != calculatedLevel) {
            this.lightLevel = calculatedLevel;
            this.world.updateLightBrightness(this.position);
        }
    }

    @Override
    public List<AItemPack<JSONPoleComponent>> getDrops() {
        ArrayList<AItemPack<JSONPoleComponent>> drops = new ArrayList<AItemPack<JSONPoleComponent>>();
        for (ABlockBase.Axis axis : ABlockBase.Axis.values()) {
            if (!this.components.containsKey((Object)axis)) continue;
            drops.add(this.components.get((Object)((Object)axis)).item);
        }
        return drops;
    }

    public RenderPole getRenderer() {
        return new RenderPole();
    }

    @Override
    public void save(IWrapperNBT data) {
        super.save(data);
        for (Map.Entry<ABlockBase.Axis, ATileEntityPole_Component> connectedObjectEntry : this.components.entrySet()) {
            data.setString("packID" + connectedObjectEntry.getKey().ordinal(), connectedObjectEntry.getValue().definition.packID);
            data.setString("systemName" + connectedObjectEntry.getKey().ordinal(), connectedObjectEntry.getValue().definition.systemName);
            if (connectedObjectEntry.getValue().getTextLines() == null) continue;
            data.setStrings("textLines", connectedObjectEntry.getValue().getTextLines());
        }
    }

    public static ATileEntityPole_Component createComponent(ItemPoleComponent item) {
        switch (((JSONPoleComponent.PoleGeneral)((JSONPoleComponent)item.definition).general).type) {
            case "core": {
                return new TileEntityPole_Core(item);
            }
            case "traffic_signal": {
                return new TileEntityPole_TrafficSignal(item);
            }
            case "street_light": {
                return new TileEntityPole_StreetLight(item);
            }
            case "sign": {
                return new TileEntityPole_Sign(item);
            }
        }
        throw new IllegalArgumentException("ERROR: Wanted type: " + (((JSONPoleComponent.PoleGeneral)((JSONPoleComponent)item.definition).general).type != null ? ((JSONPoleComponent.PoleGeneral)((JSONPoleComponent)item.definition).general).type : null) + " for pole:" + ((JSONPoleComponent)item.definition).packID + ":" + ((JSONPoleComponent)item.definition).systemName + ", but such a type is not a valid pole component.  Contact the pack author.");
    }
}

