/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.instances;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import minecrafttransportsimulator.baseclasses.Point3i;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityPole_Component;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityTickable;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole_StreetLight;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole_TrafficSignal;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.rendering.instances.RenderDecor;
import minecrafttransportsimulator.vehicles.main.AEntityBase;

public class TileEntitySignalController
extends ATileEntityBase<JSONDecor>
implements ITileEntityTickable {
    public OpMode currentOpMode = OpMode.TIMED_CYCLE;
    public boolean lightsOn = true;
    public boolean mainDirectionXAxis;
    public OpState currentOpState = OpState.GREEN_MAIN_RED_CROSS;
    public int timeOperationStarted;
    public int greenMainTime = 20;
    public int greenCrossTime = 10;
    public int yellowMainTime = 2;
    public int yellowCrossTime = 2;
    public int allRedTime = 1;
    public final List<Point3i> componentLocations = new ArrayList<Point3i>();

    public TileEntitySignalController(IWrapperWorld world, Point3i position, IWrapperNBT data) {
        super(world, position, data);
        this.currentOpMode = OpMode.values()[data.getInteger("currentOpMode")];
        this.currentOpState = OpState.values()[data.getInteger("currentOpState")];
        this.timeOperationStarted = data.getInteger("timeOperationStarted");
        this.mainDirectionXAxis = data.getBoolean("mainDirectionXAxis");
        if (data.getBoolean("hasCustomTimes")) {
            this.greenMainTime = data.getInteger("greenMainTime");
            this.greenCrossTime = data.getInteger("greenCrossTime");
            this.yellowMainTime = data.getInteger("yellowMainTime");
            this.yellowCrossTime = data.getInteger("yellowCrossTime");
            this.allRedTime = data.getInteger("allRedTime");
        }
        this.componentLocations.clear();
        this.componentLocations.addAll(data.getPoints("componentLocations"));
    }

    @Override
    public void update() {
        if (this.world.getTime() % 20L == 0L) {
            this.updateState(this.currentOpState, false);
        }
        int currentTime = (int)(this.world.getTime() / 20L % Integer.MAX_VALUE);
        int redstoneSignal = this.world.getRedstonePower(this.position.copy().add(0, -1, 0));
        if (!this.currentOpMode.equals((Object)OpMode.REMOTE_CONTROL)) {
            if (!this.currentOpMode.equals((Object)OpMode.REDSTONE_TRIGGER) && this.lightsOn ^ redstoneSignal == 0) {
                this.lightsOn = !this.lightsOn;
                this.updateState(this.currentOpState, false);
            }
            if (this.currentOpState.equals((Object)OpState.GREEN_MAIN_RED_CROSS)) {
                if (this.currentOpMode.equals((Object)OpMode.VEHICLE_TRIGGER)) {
                    if (currentTime % 2 == 0) {
                        int minX = Integer.MAX_VALUE;
                        int maxX = Integer.MIN_VALUE;
                        int minZ = Integer.MAX_VALUE;
                        int maxZ = Integer.MIN_VALUE;
                        for (Point3i controllerSignalPos : this.componentLocations) {
                            minX = Math.min(minX, controllerSignalPos.x);
                            maxX = Math.max(maxX, controllerSignalPos.x);
                            minZ = Math.min(minZ, controllerSignalPos.z);
                            maxZ = Math.max(maxZ, controllerSignalPos.z);
                        }
                        if (this.mainDirectionXAxis) {
                            minZ -= 16;
                            maxZ += 16;
                        } else {
                            minX -= 16;
                            maxX += 16;
                        }
                        for (AEntityBase entity : this.world.isClient() ? AEntityBase.createdClientEntities : AEntityBase.createdServerEntities) {
                            if (!(entity.position.x > (double)minX) || !(entity.position.x < (double)maxX) || !(entity.position.z > (double)minZ) || !(entity.position.z < (double)maxZ)) continue;
                            this.updateState(OpState.YELLOW_MAIN_RED_CROSS, true);
                            break;
                        }
                    }
                } else if (this.currentOpMode.equals((Object)OpMode.REDSTONE_TRIGGER)) {
                    if (redstoneSignal > 0) {
                        this.updateState(OpState.YELLOW_MAIN_RED_CROSS, true);
                    }
                } else if (this.timeOperationStarted + this.greenMainTime <= currentTime) {
                    this.updateState(OpState.YELLOW_MAIN_RED_CROSS, true);
                }
            } else {
                switch (this.currentOpState) {
                    case GREEN_MAIN_RED_CROSS: {
                        break;
                    }
                    case YELLOW_MAIN_RED_CROSS: {
                        if (this.timeOperationStarted + this.yellowMainTime > currentTime) break;
                        this.updateState(OpState.RED_MAIN_RED_CROSS, true);
                        break;
                    }
                    case RED_MAIN_RED_CROSS: {
                        if (this.timeOperationStarted + this.allRedTime > currentTime) break;
                        this.updateState(OpState.RED_MAIN_GREEN_CROSS, true);
                        break;
                    }
                    case RED_MAIN_GREEN_CROSS: {
                        if (this.timeOperationStarted + this.greenCrossTime > currentTime) break;
                        this.updateState(OpState.RED_MAIN_YELLOW_CROSS, true);
                        break;
                    }
                    case RED_MAIN_YELLOW_CROSS: {
                        if (this.timeOperationStarted + this.yellowCrossTime > currentTime) break;
                        this.updateState(OpState.RED_MAIN2_RED_CROSS2, true);
                        break;
                    }
                    case RED_MAIN2_RED_CROSS2: {
                        if (this.timeOperationStarted + this.allRedTime > currentTime) break;
                        this.updateState(OpState.GREEN_MAIN_RED_CROSS, true);
                    }
                }
            }
        } else {
            boolean lightOnSignal;
            int stateOpCode = redstoneSignal & 7;
            boolean bl = lightOnSignal = redstoneSignal >> 3 > 0;
            if (this.lightsOn ^ lightOnSignal) {
                this.lightsOn = !this.lightsOn;
                this.updateState(this.currentOpState, false);
            }
            if (this.currentOpState.ordinal() != stateOpCode && stateOpCode < OpState.values().length) {
                this.updateState(OpState.values()[stateOpCode], false);
            }
        }
    }

    public void updateState(OpState state, boolean cycleUpdate) {
        this.currentOpState = state;
        if (cycleUpdate) {
            this.timeOperationStarted = (int)(this.world.getTime() / 20L % Integer.MAX_VALUE);
        }
        Iterator<Point3i> iterator = this.componentLocations.iterator();
        while (iterator.hasNext()) {
            TileEntityPole signal = (TileEntityPole)this.world.getTileEntity(iterator.next());
            if (signal == null) continue;
            for (ABlockBase.Axis axis : signal.components.keySet()) {
                ATileEntityPole_Component component = signal.components.get((Object)axis);
                if (component instanceof TileEntityPole_TrafficSignal) {
                    ((TileEntityPole_TrafficSignal)component).state = (axis.equals((Object)ABlockBase.Axis.NORTH) || axis.equals((Object)ABlockBase.Axis.SOUTH)) ^ this.mainDirectionXAxis ? state.mainSignalState : state.crossSignalState;
                    continue;
                }
                if (!(component instanceof TileEntityPole_StreetLight) || !(((TileEntityPole_StreetLight)component).state.equals((Object)TileEntityPole_StreetLight.LightState.ON) ^ this.lightsOn)) continue;
                ((TileEntityPole_StreetLight)component).state = this.lightsOn ? TileEntityPole_StreetLight.LightState.ON : TileEntityPole_StreetLight.LightState.OFF;
                signal.updateLightState();
            }
        }
    }

    public RenderDecor getRenderer() {
        return new RenderDecor();
    }

    @Override
    public void save(IWrapperNBT data) {
        super.save(data);
        data.setInteger("currentOpMode", this.currentOpMode.ordinal());
        data.setInteger("currentOpState", this.currentOpState.ordinal());
        data.setInteger("timeOperationStarted", this.timeOperationStarted);
        data.setBoolean("mainDirectionXAxis", this.mainDirectionXAxis);
        data.setBoolean("hasCustomTimes", true);
        data.setInteger("greenMainTime", this.greenMainTime);
        data.setInteger("greenCrossTime", this.greenCrossTime);
        data.setInteger("yellowMainTime", this.yellowMainTime);
        data.setInteger("yellowCrossTime", this.yellowCrossTime);
        data.setInteger("allRedTime", this.allRedTime);
        data.setPoints("componentLocations", this.componentLocations);
    }

    public static enum OpState {
        GREEN_MAIN_RED_CROSS(TileEntityPole_TrafficSignal.SignalState.GREEN, TileEntityPole_TrafficSignal.SignalState.RED),
        YELLOW_MAIN_RED_CROSS(TileEntityPole_TrafficSignal.SignalState.YELLOW, TileEntityPole_TrafficSignal.SignalState.RED),
        RED_MAIN_RED_CROSS(TileEntityPole_TrafficSignal.SignalState.RED, TileEntityPole_TrafficSignal.SignalState.RED),
        RED_MAIN_GREEN_CROSS(TileEntityPole_TrafficSignal.SignalState.RED, TileEntityPole_TrafficSignal.SignalState.GREEN),
        RED_MAIN_YELLOW_CROSS(TileEntityPole_TrafficSignal.SignalState.RED, TileEntityPole_TrafficSignal.SignalState.YELLOW),
        RED_MAIN2_RED_CROSS2(TileEntityPole_TrafficSignal.SignalState.RED, TileEntityPole_TrafficSignal.SignalState.RED);

        public final TileEntityPole_TrafficSignal.SignalState mainSignalState;
        public final TileEntityPole_TrafficSignal.SignalState crossSignalState;

        private OpState(TileEntityPole_TrafficSignal.SignalState mainSignalState, TileEntityPole_TrafficSignal.SignalState crossSignalState) {
            this.mainSignalState = mainSignalState;
            this.crossSignalState = crossSignalState;
        }
    }

    public static enum OpMode {
        TIMED_CYCLE,
        VEHICLE_TRIGGER,
        REDSTONE_TRIGGER,
        REMOTE_CONTROL;

    }
}

