/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.components;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentInstrument;
import minecrafttransportsimulator.guis.components.GUIComponentItem;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.guis.components.GUIComponentOBJModel;
import minecrafttransportsimulator.guis.components.GUIComponentSelector;
import minecrafttransportsimulator.guis.components.GUIComponentTextBox;

public abstract class AGUIBase {
    private static final int STANDARD_GUI_WIDTH = 256;
    private static final int STANDARD_GUI_HEIGHT = 192;
    private static final String STANDARD_TEXTURE_NAME = "mts:textures/guis/standard.png";
    public final List<GUIComponentLabel> labels = new ArrayList<GUIComponentLabel>();
    public final List<GUIComponentButton> buttons = new ArrayList<GUIComponentButton>();
    public final List<GUIComponentSelector> selectors = new ArrayList<GUIComponentSelector>();
    public final List<GUIComponentTextBox> textBoxes = new ArrayList<GUIComponentTextBox>();
    public final List<GUIComponentItem> items = new ArrayList<GUIComponentItem>();
    public final List<GUIComponentInstrument> instruments = new ArrayList<GUIComponentInstrument>();
    public final List<GUIComponentOBJModel> objModels = new ArrayList<GUIComponentOBJModel>();

    public abstract void setupComponents(int var1, int var2);

    public abstract void setStates();

    public boolean renderBackground() {
        return true;
    }

    public boolean renderDarkBackground() {
        return false;
    }

    public GUILightingMode getGUILightMode() {
        return GUILightingMode.NONE;
    }

    public boolean pauseOnOpen() {
        return false;
    }

    public int getWidth() {
        return 256;
    }

    public int getHeight() {
        return 192;
    }

    public boolean renderFlushBottom() {
        return false;
    }

    public final int getTextureWidth() {
        return this.getWidth() <= 256 ? 256 : (this.getWidth() <= 512 ? 512 : (this.getWidth() <= 1024 ? 1024 : 2048));
    }

    public final int getTextureHeight() {
        return this.getHeight() <= 256 ? 256 : (this.getHeight() <= 512 ? 512 : (this.getHeight() <= 1024 ? 1024 : 2048));
    }

    public String getTexture() {
        return STANDARD_TEXTURE_NAME;
    }

    public void addLabel(GUIComponentLabel label) {
        this.labels.add(label);
    }

    public void addButton(GUIComponentButton button) {
        this.buttons.add(button);
    }

    public void addSelector(GUIComponentSelector selector) {
        this.selectors.add(selector);
    }

    public void addTextBox(GUIComponentTextBox textBox) {
        this.textBoxes.add(textBox);
    }

    public void addItem(GUIComponentItem item) {
        this.items.add(item);
    }

    public void addInstrument(GUIComponentInstrument instrument) {
        this.instruments.add(instrument);
    }

    public void addOBJModel(GUIComponentOBJModel objModel) {
        this.objModels.add(objModel);
    }

    public void clearComponents() {
        this.labels.clear();
        this.buttons.clear();
        this.selectors.clear();
        this.textBoxes.clear();
        this.items.clear();
        this.instruments.clear();
        this.objModels.clear();
    }

    public static boolean inClockPeriod(int totalPeriod, int onPeriod) {
        return (double)System.currentTimeMillis() * 0.02 % (double)totalPeriod <= (double)onPeriod;
    }

    public static enum GUILightingMode {
        NONE,
        DARK,
        LIT;

    }

    public static enum TextPosition {
        CENTERED,
        LEFT_ALIGNED,
        RIGHT_ALIGNED;

    }
}

