/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.components;

import java.awt.Color;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.mcinterface.MasterLoader;

public abstract class GUIComponentButton {
    private static final int DEFAULT_TEXTURE_WIDTH = 256;
    private static final int DEFAULT_TEXTURE_HEIGHT = 256;
    private static final int DEFAULT_BUTTON_SECTION_WIDTH = 200;
    private static final int DEFAULT_BUTTON_SECTION_HEIGHT = 20;
    private static final int DEFAULT_BUTTON_SECTION_WIDTH_OFFSET = 0;
    private static final int DEFAULT_BUTTON_SECTION_HEIGHT_OFFSET = 196;
    public final int x;
    public final int y;
    public final int width;
    public final int height;
    public final boolean centeredText;
    public final int buttonSectionWidth;
    public final int buttonSectionHeight;
    public final int buttonSectionWidthOffset;
    public final int buttonSectionHeightOffset;
    public final int textureWidth;
    public final int textureHeight;
    public boolean visible = true;
    public boolean enabled = true;
    public String text;

    public GUIComponentButton(int x, int y, int width, String text) {
        this(x, y, width, text, 20, true);
    }

    public GUIComponentButton(int x, int y, int width, String text, int height, boolean centeredText) {
        this(x, y, width, text, height, centeredText, 200, 20, 0, 196, 256, 256);
    }

    public GUIComponentButton(int x, int y, int width, String text, int height, boolean centeredText, int buttonSectionWidth, int buttonSectionHeight, int buttonSectionWidthOffset, int buttonSectionHeightOffset, int textureWidth, int textureHeight) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.text = text;
        this.centeredText = centeredText;
        this.buttonSectionWidth = buttonSectionWidth;
        this.buttonSectionHeight = buttonSectionHeight;
        this.buttonSectionWidthOffset = buttonSectionWidthOffset;
        this.buttonSectionHeightOffset = buttonSectionHeightOffset;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
    }

    public boolean canClick(int xPos, int yPos) {
        return this.visible && this.enabled && this.x < xPos && xPos < this.x + this.width && this.y < yPos && yPos < this.y + this.height;
    }

    public abstract void onClicked();

    public void renderButton(int mouseX, int mouseY) {
        if (this.visible) {
            int textureUStart = this.enabled ? (mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height ? this.buttonSectionHeightOffset + 2 * this.buttonSectionHeight : this.buttonSectionHeightOffset + 1 * this.buttonSectionHeight) : this.buttonSectionHeightOffset;
            MasterLoader.guiInterface.renderSheetTexture(this.x, this.y, this.width / 2, this.height, this.buttonSectionWidthOffset, textureUStart, this.buttonSectionWidthOffset + this.width / 2, textureUStart + this.buttonSectionHeight, this.textureWidth, this.textureHeight);
            MasterLoader.guiInterface.renderSheetTexture(this.x + this.width / 2, this.y, this.width / 2, this.height, this.buttonSectionWidthOffset + this.buttonSectionWidth - this.width / 2, textureUStart, this.buttonSectionWidthOffset + this.buttonSectionWidth, textureUStart + this.buttonSectionHeight, this.textureWidth, this.textureHeight);
        }
    }

    public void renderText() {
        if (this.visible) {
            MasterLoader.guiInterface.drawBasicText(this.text, this.centeredText ? this.x + this.width / 2 : this.x, this.y + (this.height - 8) / 2, Color.DARK_GRAY, this.centeredText ? AGUIBase.TextPosition.CENTERED : AGUIBase.TextPosition.LEFT_ALIGNED, 0);
        }
    }

    public void renderTooltip(AGUIBase gui, int mouseX, int mouseY) {
    }
}

