/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.components;

import java.util.HashMap;
import java.util.Map;
import minecrafttransportsimulator.rendering.components.OBJParser;
import org.lwjgl.opengl.GL11;

public class GUIComponentOBJModel {
    private static final Map<String, Integer> modelDisplayLists = new HashMap<String, Integer>();
    private static final Map<String, Float> modelScalingFactors = new HashMap<String, Float>();
    public final float scaleFactor;
    public final boolean isometric;
    public final boolean staticScaling;
    public int x;
    public int y;
    public boolean spin;
    public float scale;
    public String modelLocation;
    public String textureLocation;
    public boolean visible = true;

    public GUIComponentOBJModel(int x, int y, float scaleFactor, boolean isometric, boolean spin, boolean staticScaling) {
        this.x = x;
        this.y = y;
        this.scaleFactor = scaleFactor;
        this.isometric = isometric;
        this.spin = spin;
        this.staticScaling = staticScaling;
    }

    public void renderModel() {
        if (this.visible && this.modelLocation != null) {
            if (!modelDisplayLists.containsKey(this.modelLocation)) {
                GUIComponentOBJModel.parseModel(this.modelLocation);
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.x, (float)this.y, (float)100.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            if (this.isometric) {
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)35.264f, (float)1.0f, (float)0.0f, (float)1.0f);
            }
            if (this.spin) {
                GL11.glRotatef((float)(36L * System.currentTimeMillis() / 1000L % 360L), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (!this.staticScaling) {
                this.scale = modelScalingFactors.get(this.modelLocation).floatValue();
            }
            GL11.glScalef((float)(this.scale * this.scaleFactor), (float)(this.scale * this.scaleFactor), (float)(this.scale * this.scaleFactor));
            GL11.glCallList((int)modelDisplayLists.get(this.modelLocation));
            GL11.glPopMatrix();
        }
    }

    private static void parseModel(String modelLocation) {
        float minX = 999.0f;
        float maxX = -999.0f;
        float minY = 999.0f;
        float maxY = -999.0f;
        float minZ = 999.0f;
        float maxZ = -999.0f;
        Map<String, Float[][]> parsedModel = OBJParser.parseOBJModel(modelLocation);
        int displayListIndex = GL11.glGenLists((int)1);
        GL11.glNewList((int)displayListIndex, (int)4864);
        GL11.glBegin((int)4);
        for (Map.Entry<String, Float[][]> entry : parsedModel.entrySet()) {
            if (entry.getKey().toLowerCase().contains("window")) continue;
            for (Float[] vertex : entry.getValue()) {
                GL11.glTexCoord2f((float)vertex[3].floatValue(), (float)vertex[4].floatValue());
                GL11.glNormal3f((float)vertex[5].floatValue(), (float)vertex[6].floatValue(), (float)vertex[7].floatValue());
                GL11.glVertex3f((float)(-vertex[0].floatValue()), (float)vertex[1].floatValue(), (float)vertex[2].floatValue());
                minX = Math.min(minX, vertex[0].floatValue());
                maxX = Math.max(maxX, vertex[0].floatValue());
                minY = Math.min(minY, vertex[1].floatValue());
                maxY = Math.max(maxY, vertex[1].floatValue());
                minZ = Math.min(minZ, vertex[2].floatValue());
                maxZ = Math.max(maxZ, vertex[2].floatValue());
            }
        }
        float globalMax = Math.max(Math.max(maxX - minX, maxY - minY), maxZ - minZ);
        modelScalingFactors.put(modelLocation, Float.valueOf((double)globalMax > 1.5 ? 1.5f / globalMax : 1.0f));
        GL11.glEnd();
        GL11.glEndList();
        modelDisplayLists.put(modelLocation, displayListIndex);
    }

    public static void clearDisplayListCaches() {
        for (int displayListID : modelDisplayLists.values()) {
            GL11.glDeleteLists((int)displayListID, (int)1);
        }
        modelDisplayLists.clear();
    }
}

