/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.components;

import java.awt.Color;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.mcinterface.MasterLoader;

public abstract class GUIComponentSelector {
    public final int x;
    public final int y;
    public final int width;
    public final int height;
    public final String text;
    public final Color regularColor;
    public final Color litColor;
    public final int selectorSectionWidth;
    public final int selectorSectionHeight;
    public final int selectorSectionWidthOffset;
    public final int selectorSectionHeightOffset;
    public final int textureWidth;
    public final int textureHeight;
    public boolean visible = true;
    public int selectorState = 0;

    public GUIComponentSelector(int x, int y, int width, int height, String text, String regularColor, String litColor, int selectorSectionWidth, int selectorSectionHeight, int selectorSectionWidthOffset, int selectorSectionHeightOffset, int textureWidth, int textureHeight) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.text = text;
        this.regularColor = regularColor != null ? Color.decode(regularColor) : Color.WHITE;
        this.litColor = regularColor != null ? Color.decode(litColor) : Color.WHITE;
        this.selectorSectionWidth = selectorSectionWidth;
        this.selectorSectionHeight = selectorSectionHeight;
        this.selectorSectionWidthOffset = selectorSectionWidthOffset;
        this.selectorSectionHeightOffset = selectorSectionHeightOffset;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
    }

    public boolean canClick(int xPos, int yPos) {
        return this.visible && this.x < xPos && xPos < this.x + this.width && this.y < yPos && yPos < this.y + this.height;
    }

    public abstract void onClicked(boolean var1);

    public abstract void onReleased();

    public void renderSelector(int mouseX, int mouseY) {
        if (this.visible) {
            int textureUStart = this.selectorSectionHeightOffset + this.selectorState * this.selectorSectionHeight;
            MasterLoader.guiInterface.renderSheetTexture(this.x, this.y, this.width, this.height, this.selectorSectionWidthOffset, textureUStart, this.selectorSectionWidthOffset + this.selectorSectionWidth, textureUStart + this.selectorSectionHeight, this.textureWidth, this.textureHeight);
        }
    }

    public void renderText(boolean lightsOn) {
        if (this.visible) {
            MasterLoader.guiInterface.drawScaledText(this.text, this.x + this.width / 2, this.y + this.height + 1, lightsOn ? this.litColor : this.regularColor, AGUIBase.TextPosition.CENTERED, 0, 0.75f, false);
        }
    }
}

