/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.components;

import java.awt.Color;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.mcinterface.MasterLoader;

public class GUIComponentTextBox {
    private static final String VALID_SPECIAL_CHARS = "/*!@#$%^&*()\"{}_[]|\\?/<>,.- ";
    public final int x;
    public final int y;
    public final int width;
    public final int height;
    public final Color fontColor;
    public final Color backgroundColor;
    public boolean visible = true;
    public boolean enabled = true;
    public boolean focused = false;
    private int position;
    private int maxTextLength;
    private String text;
    private String flashText;

    public GUIComponentTextBox(int x, int y, int width, String text) {
        this(x, y, width, text, 20, Color.WHITE, Color.BLACK, 32);
    }

    public GUIComponentTextBox(int x, int y, int width, String text, int height, Color fontColor, Color backgroundColor, int maxTextLength) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.fontColor = fontColor;
        this.backgroundColor = backgroundColor;
        this.maxTextLength = maxTextLength;
        this.setText(text);
    }

    public void updateFocus(int xPos, int yPos) {
        this.focused = this.visible && this.enabled && this.x < xPos && xPos < this.x + this.width && this.y < yPos && yPos < this.y + this.height;
    }

    public void handleKeyTyped(char typedChar, int typedCode, TextBoxControlKey control) {
        if (control != null) {
            if (control.equals((Object)TextBoxControlKey.BACKSPACE)) {
                if (this.position != 0) {
                    this.text = this.text.substring(0, this.position - 1) + this.text.substring(this.position, this.text.length());
                    --this.position;
                }
            } else if (control.equals((Object)TextBoxControlKey.DELETE)) {
                if (this.position != this.text.length()) {
                    this.text = this.text.substring(0, this.position) + this.text.substring(this.position + 1, this.text.length());
                }
            } else if (control.equals((Object)TextBoxControlKey.LEFT)) {
                if (this.position > 0) {
                    --this.position;
                }
            } else if (control.equals((Object)TextBoxControlKey.RIGHT) && this.position < this.text.length()) {
                ++this.position;
            }
        } else if ((Character.isLetterOrDigit(typedChar) || VALID_SPECIAL_CHARS.contains(Character.toString(typedChar))) && this.text.length() < this.maxTextLength) {
            this.text = this.text.substring(0, this.position) + typedChar + this.text.substring(this.position, this.text.length());
            ++this.position;
        }
        this.flashText = this.text.isEmpty() ? "_" : (this.position == this.text.length() ? this.text + "_" : this.text.substring(0, this.position) + "_" + this.text.substring(this.position + 1, this.text.length()));
    }

    public String getText() {
        return this.text;
    }

    public void setText(String newText) {
        this.text = newText.length() > this.maxTextLength ? newText.substring(0, this.maxTextLength) : newText;
        this.position = this.text.length();
        this.flashText = this.text.isEmpty() ? "_" : (this.position == 0 ? "_" + this.text.substring(1) : (this.position == this.text.length() ? this.text + "_" : this.text.substring(0, this.position) + this.text.substring(this.position + 1)));
    }

    public void renderBox() {
        if (this.visible) {
            if (this.backgroundColor != null) {
                MasterLoader.guiInterface.renderRectangle(this.x, this.y, this.width, this.height, this.backgroundColor);
            }
            if (this.enabled) {
                if (this.focused && AGUIBase.inClockPeriod(20, 10)) {
                    MasterLoader.guiInterface.drawBasicText(this.flashText, this.x + 4, this.y + (this.height >= 20 ? 5 : 1 + this.height / 10), this.fontColor, AGUIBase.TextPosition.LEFT_ALIGNED, this.width);
                } else {
                    MasterLoader.guiInterface.drawBasicText(this.text, this.x + 4, this.y + (this.height >= 20 ? 5 : 1 + this.height / 10), this.fontColor, AGUIBase.TextPosition.LEFT_ALIGNED, this.width);
                }
            } else {
                MasterLoader.guiInterface.drawBasicText(this.text, this.x + 4, this.y + (this.height >= 20 ? 5 : 1 + this.height / 10), Color.GRAY, AGUIBase.TextPosition.LEFT_ALIGNED, this.width);
            }
        }
    }

    public static enum TextBoxControlKey {
        BACKSPACE,
        DELETE,
        LEFT,
        RIGHT;

    }
}

