/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentInstrument;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartEngine;
import minecrafttransportsimulator.vehicles.parts.PartPropeller;

public abstract class AGUIPanel
extends AGUIBase {
    public static final int PANEL_WIDTH = 400;
    public static final int PANEL_HEIGHT = 140;
    protected static final int GAP_BETWEEN_SELECTORS = 12;
    protected static final int SELECTOR_SIZE = 20;
    protected static final int SELECTOR_TEXTURE_SIZE = 20;
    protected final EntityVehicleF_Physics vehicle;
    protected final boolean haveReverseThrustOption;
    protected int xOffset;

    public AGUIPanel(EntityVehicleF_Physics vehicle) {
        this.vehicle = vehicle;
        if (((JSONVehicle.VehicleGeneral)vehicle.definition.general).isBlimp) {
            this.haveReverseThrustOption = true;
        } else {
            for (APart part : vehicle.parts) {
                if (part instanceof PartPropeller) {
                    if (!part.definition.propeller.isDynamicPitch) continue;
                    this.haveReverseThrustOption = true;
                    return;
                }
                if (!(part instanceof PartEngine) || !(part.definition.engine.jetPowerFactor > 0.0f)) continue;
                this.haveReverseThrustOption = true;
                return;
            }
            this.haveReverseThrustOption = false;
        }
    }

    @Override
    public final void setupComponents(int guiLeft, int guiTop) {
        int xOffset = 12;
        xOffset = this.setupLightComponents(guiLeft, guiTop, xOffset);
        xOffset = this.setupEngineComponents(guiLeft, guiTop, xOffset);
        for (Byte instrumentNumber : this.vehicle.instruments.keySet()) {
            if (this.vehicle.definition.motorized.instruments.get((int)instrumentNumber.byteValue()).optionalPartNumber == 0) continue;
            this.addInstrument(new GUIComponentInstrument(guiLeft, guiTop, instrumentNumber, this.vehicle));
        }
    }

    protected abstract int setupLightComponents(int var1, int var2, int var3);

    protected abstract int setupEngineComponents(int var1, int var2, int var3);

    @Override
    public AGUIBase.GUILightingMode getGUILightMode() {
        return this.vehicle.areInteriorLightsOn() ? AGUIBase.GUILightingMode.LIT : AGUIBase.GUILightingMode.DARK;
    }

    @Override
    public int getWidth() {
        return 400;
    }

    @Override
    public int getHeight() {
        return 140;
    }

    @Override
    public boolean renderFlushBottom() {
        return true;
    }

    @Override
    public String getTexture() {
        return this.vehicle.definition.rendering.panelTexture != null ? this.vehicle.definition.rendering.panelTexture : "mts:textures/guis/panel.png";
    }
}

