/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.items.instances.ItemBooklet;
import minecrafttransportsimulator.jsondefs.JSONBooklet;
import minecrafttransportsimulator.jsondefs.JSONText;
import minecrafttransportsimulator.mcinterface.MasterLoader;

public class GUIBooklet
extends AGUIBase {
    private GUIComponentButton leftButton;
    private GUIComponentButton rightButton;
    private GUIComponentButton contentsButton;
    private List<List<GUIComponentLabel>> pageTextLabels = new ArrayList<List<GUIComponentLabel>>();
    private List<ContentsButton> contentsButtons = new ArrayList<ContentsButton>();
    private final ItemBooklet booklet;
    private final int totalPages;

    public GUIBooklet(ItemBooklet booklet) {
        this.booklet = booklet;
        this.totalPages = ((JSONBooklet.BookletGeneral)((JSONBooklet)booklet.definition).general).disableTOC ? 1 + ((JSONBooklet.BookletGeneral)((JSONBooklet)booklet.definition).general).pages.length : 2 + ((JSONBooklet.BookletGeneral)((JSONBooklet)booklet.definition).general).pages.length;
    }

    @Override
    public void setupComponents(int guiLeft, int guiTop) {
        this.pageTextLabels.clear();
        this.leftButton = new GUIComponentButton(guiLeft + 10, guiTop + 150, 20, "<", 20, true, 20, 20, 0, 196, this.getTextureWidth(), this.getTextureHeight()){

            @Override
            public void onClicked() {
                --((GUIBooklet)GUIBooklet.this).booklet.pageNumber;
            }
        };
        this.addButton(this.leftButton);
        this.rightButton = new GUIComponentButton(guiLeft + 250, guiTop + 150, 20, ">", 20, true, 20, 20, 0, 196, this.getTextureWidth(), this.getTextureHeight()){

            @Override
            public void onClicked() {
                ++((GUIBooklet)GUIBooklet.this).booklet.pageNumber;
            }
        };
        this.addButton(this.rightButton);
        ArrayList<GUIComponentLabel> titleLabels = new ArrayList<GUIComponentLabel>();
        for (JSONText text : ((JSONBooklet.BookletGeneral)((JSONBooklet)this.booklet.definition).general).titleText) {
            GUIComponentLabel titleLabel = new GUIComponentLabel(guiLeft + (int)text.pos.x, guiTop + (int)text.pos.y, Color.decode(text.color), text.defaultText, AGUIBase.TextPosition.values()[text.renderPosition], text.wrapWidth, text.scale, false);
            titleLabels.add(titleLabel);
            this.addLabel(titleLabel);
        }
        this.pageTextLabels.add(titleLabels);
        if (!((JSONBooklet.BookletGeneral)((JSONBooklet)this.booklet.definition).general).disableTOC) {
            GUIComponentLabel contentsLabel = new GUIComponentLabel(guiLeft + 50, guiTop + 25, Color.BLACK, "CONTENTS");
            this.addLabel(contentsLabel);
            ArrayList<GUIComponentLabel> contentsLabels = new ArrayList<GUIComponentLabel>();
            contentsLabels.add(contentsLabel);
            this.pageTextLabels.add(contentsLabels);
            this.contentsButtons.clear();
            int leftSideOffset = guiLeft + 20;
            int rightSideOffset = guiLeft + 155;
            for (int i = 0; i < ((JSONBooklet.BookletGeneral)((JSONBooklet)this.booklet.definition).general).pages.length; ++i) {
                ContentsButton contentsButton = new ContentsButton(i < 10 ? leftSideOffset : rightSideOffset, guiTop + 45 + 10 * (i % 10), i){

                    @Override
                    public void onClicked() {
                        ((GUIBooklet)GUIBooklet.this).booklet.pageNumber = this.contentsIndex + 2;
                    }
                };
                this.contentsButtons.add(contentsButton);
                this.addButton(contentsButton);
            }
            this.contentsButton = new GUIComponentButton(this.leftButton.x + this.leftButton.width, guiTop + 150, 30, "TOC", 20, true, 20, 20, 0, 196, this.getTextureWidth(), this.getTextureHeight()){

                @Override
                public void onClicked() {
                    ((GUIBooklet)GUIBooklet.this).booklet.pageNumber = 1;
                }
            };
            this.addButton(this.contentsButton);
        }
        for (JSONBooklet.BookletPage page : ((JSONBooklet.BookletGeneral)((JSONBooklet)this.booklet.definition).general).pages) {
            ArrayList<GUIComponentLabel> pageLabels = new ArrayList<GUIComponentLabel>();
            for (JSONText text : page.pageText) {
                try {
                    GUIComponentLabel pageLabel = new GUIComponentLabel(guiLeft + (int)text.pos.x, guiTop + (int)text.pos.y, Color.decode(text.color), text.defaultText, AGUIBase.TextPosition.values()[text.renderPosition], text.wrapWidth, text.scale, false);
                    pageLabels.add(pageLabel);
                    this.addLabel(pageLabel);
                }
                catch (Exception e) {
                    int pageNumber = -1;
                    for (int i = 0; i < ((JSONBooklet.BookletGeneral)((JSONBooklet)this.booklet.definition).general).pages.length; i = (int)((byte)(i + 1))) {
                        if (!((JSONBooklet.BookletGeneral)((JSONBooklet)this.booklet.definition).general).pages[i].equals(page)) continue;
                        pageNumber = i + 1;
                    }
                    MasterLoader.coreInterface.logError("AN ERROR WAS ENCOUNTERED WHEN CREATING BOOKLET PAGE: " + pageNumber);
                    MasterLoader.coreInterface.logError(e.getMessage());
                }
            }
            this.pageTextLabels.add(pageLabels);
        }
    }

    @Override
    public void setStates() {
        this.leftButton.visible = this.booklet.pageNumber > 0;
        this.rightButton.visible = this.booklet.pageNumber + 1 < this.totalPages;
        int wheelMovement = MasterLoader.inputInterface.getTrackedMouseWheel();
        if (wheelMovement > 0 && this.rightButton.visible) {
            ++this.booklet.pageNumber;
        } else if (wheelMovement < 0 && this.leftButton.visible) {
            --this.booklet.pageNumber;
        }
        for (int i = 0; i < this.pageTextLabels.size(); ++i) {
            for (GUIComponentLabel label : this.pageTextLabels.get(i)) {
                label.visible = this.booklet.pageNumber == i;
            }
        }
        for (GUIComponentButton gUIComponentButton : this.contentsButtons) {
            gUIComponentButton.visible = this.booklet.pageNumber == 1 && !((JSONBooklet.BookletGeneral)((JSONBooklet)this.booklet.definition).general).disableTOC;
        }
        if (this.contentsButton != null) {
            this.contentsButton.visible = this.booklet.pageNumber > 1;
        }
    }

    @Override
    public int getWidth() {
        return ((JSONBooklet.BookletGeneral)((JSONBooklet)this.booklet.definition).general).textureWidth;
    }

    @Override
    public int getHeight() {
        return ((JSONBooklet.BookletGeneral)((JSONBooklet)this.booklet.definition).general).textureHeight;
    }

    @Override
    public String getTexture() {
        if (this.booklet.pageNumber == 0) {
            return ((JSONBooklet.BookletGeneral)((JSONBooklet)this.booklet.definition).general).coverTexture;
        }
        if (!((JSONBooklet.BookletGeneral)((JSONBooklet)this.booklet.definition).general).disableTOC) {
            if (this.booklet.pageNumber == 1) {
                return ((JSONBooklet.BookletGeneral)((JSONBooklet)this.booklet.definition).general).pages[0].pageTexture;
            }
            return ((JSONBooklet.BookletGeneral)((JSONBooklet)this.booklet.definition).general).pages[this.booklet.pageNumber - 2].pageTexture;
        }
        return ((JSONBooklet.BookletGeneral)((JSONBooklet)this.booklet.definition).general).pages[this.booklet.pageNumber - 1].pageTexture;
    }

    private abstract class ContentsButton
    extends GUIComponentButton {
        protected final int contentsIndex;

        public ContentsButton(int x, int y, int contentsIndex) {
            super(x, y, 110, contentsIndex + 1 + ": " + ((JSONBooklet.BookletGeneral)((JSONBooklet)((GUIBooklet)GUIBooklet.this).booklet.definition).general).pages[contentsIndex].title, 10, false);
            this.contentsIndex = contentsIndex;
        }

        @Override
        public void renderButton(int mouseX, int mouseY) {
        }

        @Override
        public void renderText() {
            if (this.visible) {
                MasterLoader.guiInterface.drawBasicText(this.text, this.centeredText ? this.x + this.width / 2 : this.x, this.y + (this.height - 8) / 2, Color.decode(((JSONBooklet.BookletGeneral)((JSONBooklet)((GUIBooklet)GUIBooklet.this).booklet.definition).general).pages[this.contentsIndex].pageText[0].color), this.centeredText ? AGUIBase.TextPosition.CENTERED : AGUIBase.TextPosition.LEFT_ALIGNED, 0);
            }
        }
    }
}

