/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.guis.components.GUIComponentTextBox;
import minecrafttransportsimulator.jsondefs.JSONConfig;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.ControlSystem;

public class GUIConfig
extends AGUIBase {
    private GUIComponentButton configScreenButton;
    private GUIComponentButton controlScreenButton;
    private boolean configuringControls = true;
    private Map<GUIComponentButton, JSONConfig.ConfigBoolean> configButtons = new HashMap<GUIComponentButton, JSONConfig.ConfigBoolean>();
    private String vehicleConfiguring = "";
    private String[] vehicleTypes = new String[]{"car", "aircraft"};
    private Map<GUIComponentButton, String> vehicleSelectionButtons = new HashMap<GUIComponentButton, String>();
    private GUIComponentLabel vehicleSelectionFaultLabel;
    private GUIComponentButton finishKeyboardBindingsButton;
    private boolean configuringKeyboard;
    private Map<String, Map<GUIComponentTextBox, ControlSystem.ControlsKeyboard>> keyboardBoxes = new HashMap<String, Map<GUIComponentTextBox, ControlSystem.ControlsKeyboard>>();
    private Map<String, Map<GUIComponentLabel, ControlSystem.ControlsKeyboardDynamic>> keyboardLabels = new HashMap<String, Map<GUIComponentLabel, ControlSystem.ControlsKeyboardDynamic>>();
    private Map<GUIComponentButton, String> joystickSelectionButtons = new HashMap<GUIComponentButton, String>();
    private int scrollSpot = 0;
    private String selectedJoystick;
    private GUIComponentButton componentListUpButton;
    private GUIComponentButton componentListDownButton;
    private GUIComponentButton deadzone_moreButton;
    private GUIComponentButton deadzone_lessButton;
    private GUIComponentTextBox deadzone_text;
    private List<JoystickControlButton> joystickComponentSelectionButtons = new ArrayList<JoystickControlButton>();
    private boolean assigningDigital;
    private int joystickComponentId = -1;
    private GUIComponentButton cancelAssignmentButton;
    private GUIComponentButton clearAssignmentButton;
    private Map<String, Map<GUIComponentButton, ControlSystem.ControlsJoystick>> digitalAssignButtons = new HashMap<String, Map<GUIComponentButton, ControlSystem.ControlsJoystick>>();
    private Map<String, Map<GUIComponentButton, ControlSystem.ControlsJoystick>> analogAssignButtons = new HashMap<String, Map<GUIComponentButton, ControlSystem.ControlsJoystick>>();
    private boolean calibrating = false;
    private ControlSystem.ControlsJoystick controlCalibrating;
    private GUIComponentButton confirmBoundsButton;
    private GUIComponentButton invertAxisButton;
    private GUIComponentTextBox axisMinBoundsTextBox;
    private GUIComponentTextBox axisMaxBoundsTextBox;

    @Override
    public void setupComponents(int guiLeft, int guiTop) {
        this.configScreenButton = new GUIComponentButton(guiLeft + 0, guiTop - 20, 128, MasterLoader.coreInterface.translate("gui.config.header.config")){

            @Override
            public void onClicked() {
                GUIConfig.this.configuringControls = false;
                GUIConfig.this.vehicleConfiguring = "";
                GUIConfig.this.selectedJoystick = null;
                GUIConfig.this.scrollSpot = 0;
                GUIConfig.this.joystickComponentId = -1;
                GUIConfig.this.calibrating = false;
            }
        };
        this.addButton(this.configScreenButton);
        this.controlScreenButton = new GUIComponentButton(guiLeft + 128, guiTop - 20, 128, MasterLoader.coreInterface.translate("gui.config.header.controls")){

            @Override
            public void onClicked() {
                GUIConfig.this.configuringControls = true;
            }
        };
        this.addButton(this.controlScreenButton);
        this.configButtons.clear();
        for (Field field : ConfigSystem.configObject.client.getClass().getFields()) {
            if (!field.getType().equals(JSONConfig.ConfigBoolean.class)) continue;
            try {
                final JSONConfig.ConfigBoolean config = (JSONConfig.ConfigBoolean)field.get(ConfigSystem.configObject.client);
                GUIComponentButton button = new GUIComponentButton(guiLeft + 85 + 120 * (this.configButtons.size() % 2), guiTop + 20 + 16 * (this.configButtons.size() / 2), 40, String.valueOf(config.value), 16, true){

                    @Override
                    public void onClicked() {
                        ((JSONConfig.ConfigBoolean)((GUIConfig)GUIConfig.this).configButtons.get((Object)this)).value = Boolean.valueOf(this.text) == false;
                        ConfigSystem.saveToDisk();
                        this.text = String.valueOf(((JSONConfig.ConfigBoolean)((GUIConfig)GUIConfig.this).configButtons.get((Object)this)).value);
                    }

                    @Override
                    public void renderTooltip(AGUIBase gui, int mouseX, int mouseY) {
                        if (this.visible && mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height) {
                            MasterLoader.guiInterface.drawGenericTooltip(gui, mouseX, mouseY, config.comment);
                        }
                    }
                };
                this.addButton(button);
                this.configButtons.put(button, config);
                this.addLabel(new GUIComponentLabel(button.x - 75, button.y + 5, Color.BLACK, field.getName()).setButton(button));
            }
            catch (Exception config) {
                // empty catch block
            }
        }
        this.vehicleSelectionButtons.clear();
        this.vehicleSelectionFaultLabel = new GUIComponentLabel(guiLeft + 10, guiTop + 110, Color.BLACK, MasterLoader.coreInterface.translate("gui.config.joystick.error"), AGUIBase.TextPosition.LEFT_ALIGNED, 240, 1.0f, false);
        this.addLabel(this.vehicleSelectionFaultLabel);
        for (String string : this.vehicleTypes) {
            GUIComponentButton buttonKeyboard = new GUIComponentButton(guiLeft + 68, guiTop + 30 + 20 * (this.vehicleSelectionButtons.size() / (MasterLoader.inputInterface.isJoystickSupportEnabled() ? 2 : 1)), 120, MasterLoader.coreInterface.translate("gui.config.controls." + (String)string + ".keyboard")){

                @Override
                public void onClicked() {
                    String lookupString = (String)GUIConfig.this.vehicleSelectionButtons.get(this);
                    GUIConfig.this.vehicleConfiguring = lookupString.substring(0, lookupString.indexOf(46));
                    GUIConfig.this.configuringKeyboard = true;
                }
            };
            this.vehicleSelectionButtons.put(buttonKeyboard, (String)string + ".keyboard");
            this.addButton(buttonKeyboard);
            if (this.vehicleSelectionButtons.size() == 1) {
                this.addLabel(new GUIComponentLabel(guiLeft + 20, guiTop + 10, Color.BLACK, MasterLoader.coreInterface.translate("gui.config.controls.title")).setButton(buttonKeyboard));
            }
            if (!MasterLoader.inputInterface.isJoystickSupportEnabled()) continue;
            GUIComponentButton buttonJoystick = new GUIComponentButton(guiLeft + 68, guiTop + 90 + 20 * (this.vehicleSelectionButtons.size() / 2), 120, MasterLoader.coreInterface.translate("gui.config.controls." + (String)string + ".joystick")){

                @Override
                public void onClicked() {
                    String lookupString = (String)GUIConfig.this.vehicleSelectionButtons.get(this);
                    GUIConfig.this.vehicleConfiguring = lookupString.substring(0, lookupString.indexOf(46));
                    GUIConfig.this.configuringKeyboard = false;
                }
            };
            this.vehicleSelectionButtons.put(buttonJoystick, (String)string + ".joystick");
            this.addButton(buttonJoystick);
        }
        this.keyboardBoxes.clear();
        this.keyboardLabels.clear();
        for (String string : this.vehicleTypes) {
            int verticalOffset = 20;
            int horizontalOffset = 80;
            HashMap<6, ControlSystem.ControlsKeyboard> boxesForVehicle = new HashMap<6, ControlSystem.ControlsKeyboard>();
            for (ControlSystem.ControlsKeyboard keyboardControl : ControlSystem.ControlsKeyboard.values()) {
                if (!keyboardControl.systemName.contains(string)) continue;
                GUIComponentTextBox box = new GUIComponentTextBox(guiLeft + horizontalOffset, guiTop + verticalOffset, 40, "", 10, Color.WHITE, Color.BLACK, 5){

                    @Override
                    public void handleKeyTyped(char typedChar, int typedCode, GUIComponentTextBox.TextBoxControlKey control) {
                        this.setText(MasterLoader.inputInterface.getNameForKeyCode(typedCode));
                        ((ControlSystem.ControlsKeyboard)((Object)((Map)((GUIConfig)GUIConfig.this).keyboardBoxes.get((Object)((GUIConfig)GUIConfig.this).vehicleConfiguring)).get((Object)this))).config.keyCode = typedCode;
                        ConfigSystem.saveToDisk();
                        this.focused = false;
                    }
                };
                boxesForVehicle.put(box, keyboardControl);
                this.addTextBox(box);
                this.addLabel(new GUIComponentLabel(box.x - 70, box.y + 2, Color.BLACK, keyboardControl.translatedName + ":").setBox(box));
                if ((verticalOffset += 11) <= 119) continue;
                verticalOffset = 20;
                horizontalOffset += 120;
            }
            this.keyboardBoxes.put(string, boxesForVehicle);
            int offset = 0;
            HashMap<GUIComponentLabel, ControlSystem.ControlsKeyboardDynamic> dynamicLabels = new HashMap<GUIComponentLabel, ControlSystem.ControlsKeyboardDynamic>();
            for (ControlSystem.ControlsKeyboardDynamic controlsKeyboardDynamic : ControlSystem.ControlsKeyboardDynamic.values()) {
                if (!controlsKeyboardDynamic.name().toLowerCase().contains(string)) continue;
                GUIComponentLabel label = new GUIComponentLabel(guiLeft + 10, guiTop + 135 + offset, Color.BLACK, "");
                dynamicLabels.put(label, controlsKeyboardDynamic);
                this.addLabel(label);
                offset = (byte)(offset + 11);
            }
            this.keyboardLabels.put(string, dynamicLabels);
        }
        this.finishKeyboardBindingsButton = new GUIComponentButton(guiLeft + 180, guiTop + 150, 50, MasterLoader.coreInterface.translate("gui.config.controls.confirm")){

            @Override
            public void onClicked() {
                GUIConfig.this.vehicleConfiguring = "";
            }
        };
        this.addButton(this.finishKeyboardBindingsButton);
        this.joystickSelectionButtons.clear();
        for (String joystick : MasterLoader.inputInterface.getAllJoysticks()) {
            GUIComponentButton button = new GUIComponentButton(guiLeft + 10, guiTop + 40 + 20 * this.joystickSelectionButtons.size(), 235, String.format(" %-30.28s", joystick), 20, false){

                @Override
                public void onClicked() {
                    GUIConfig.this.selectedJoystick = (String)GUIConfig.this.joystickSelectionButtons.get(this);
                }
            };
            this.joystickSelectionButtons.put(button, joystick);
            this.addButton(button);
            if (this.joystickSelectionButtons.size() != 1) continue;
            this.addLabel(new GUIComponentLabel(guiLeft + 20, guiTop + 10, Color.BLACK, MasterLoader.coreInterface.translate("gui.config.joystick.select")).setButton(button));
            this.addLabel(new GUIComponentLabel(guiLeft + 15, guiTop + 25, Color.BLACK, MasterLoader.coreInterface.translate("gui.config.joystick.name")).setButton(button));
        }
        this.joystickComponentSelectionButtons.clear();
        for (int i = 0; i < 9; ++i) {
            JoystickControlButton button = new JoystickControlButton(guiLeft + 10, guiTop + 45 + 15 * i);
            this.joystickComponentSelectionButtons.add(button);
            this.addButton(button);
        }
        this.componentListUpButton = new GUIComponentButton(guiLeft + 225, guiTop + 45, 20, "/\\"){

            @Override
            public void onClicked() {
                GUIConfig.this.scrollSpot = GUIConfig.this.scrollSpot - 9;
            }
        };
        this.addButton(this.componentListUpButton);
        this.componentListDownButton = new GUIComponentButton(guiLeft + 225, guiTop + 155, 20, "\\/"){

            @Override
            public void onClicked() {
                GUIConfig.this.scrollSpot = GUIConfig.this.scrollSpot + 9;
            }
        };
        this.addButton(this.componentListDownButton);
        this.deadzone_lessButton = new GUIComponentButton(guiLeft + 100, guiTop + 10, 20, "<"){

            @Override
            public void onClicked() {
                ConfigSystem.configObject.client.joystickDeadZone.value = ((Double)ConfigSystem.configObject.client.joystickDeadZone.value * 100.0 - 1.0) / 100.0;
            }
        };
        this.addButton(this.deadzone_lessButton);
        this.deadzone_moreButton = new GUIComponentButton(guiLeft + 220, guiTop + 10, 20, ">"){

            @Override
            public void onClicked() {
                ConfigSystem.configObject.client.joystickDeadZone.value = ((Double)ConfigSystem.configObject.client.joystickDeadZone.value * 100.0 + 1.0) / 100.0;
            }
        };
        this.addButton(this.deadzone_moreButton);
        this.deadzone_text = new GUIComponentTextBox(guiLeft + 120, guiTop + 10, 100, "");
        this.addTextBox(this.deadzone_text);
        this.addLabel(new GUIComponentLabel(guiLeft + 15, guiTop + 20, Color.BLACK, MasterLoader.coreInterface.translate("gui.config.joystick.mapping")).setButton(this.componentListUpButton));
        this.addLabel(new GUIComponentLabel(guiLeft + 15, guiTop + 35, Color.BLACK, "#").setButton(this.componentListUpButton));
        this.addLabel(new GUIComponentLabel(guiLeft + 30, guiTop + 35, Color.BLACK, MasterLoader.coreInterface.translate("gui.config.joystick.name")).setButton(this.componentListUpButton));
        this.addLabel(new GUIComponentLabel(guiLeft + 100, guiTop + 35, Color.BLACK, MasterLoader.coreInterface.translate("gui.config.joystick.state")).setButton(this.componentListUpButton));
        this.addLabel(new GUIComponentLabel(guiLeft + 140, guiTop + 35, Color.BLACK, MasterLoader.coreInterface.translate("gui.config.joystick.assignment")).setButton(this.componentListUpButton));
        this.cancelAssignmentButton = new GUIComponentButton(guiLeft + 125, guiTop + 160, 100, MasterLoader.coreInterface.translate("gui.config.joystick.cancel")){

            @Override
            public void onClicked() {
                GUIConfig.this.joystickComponentId = -1;
                GUIConfig.this.calibrating = false;
            }
        };
        this.addButton(this.cancelAssignmentButton);
        this.clearAssignmentButton = new GUIComponentButton(guiLeft + 25, guiTop + 160, 100, MasterLoader.coreInterface.translate("gui.config.joystick.clear")){

            @Override
            public void onClicked() {
                for (ControlSystem.ControlsJoystick joystickControl : ControlSystem.ControlsJoystick.values()) {
                    if (!GUIConfig.this.selectedJoystick.equals(joystickControl.config.joystickName) || joystickControl.config.buttonIndex != GUIConfig.this.joystickComponentId || !joystickControl.systemName.startsWith(GUIConfig.this.vehicleConfiguring)) continue;
                    joystickControl.clearControl();
                }
                GUIConfig.this.joystickComponentId = -1;
            }
        };
        this.addButton(this.clearAssignmentButton);
        this.addLabel(new GUIComponentLabel(guiLeft + 20, guiTop + 10, Color.BLACK, MasterLoader.coreInterface.translate("gui.config.joystick.choosemap")).setButton(this.clearAssignmentButton));
        this.digitalAssignButtons.clear();
        this.analogAssignButtons.clear();
        for (String string : this.vehicleTypes) {
            int leftOffsetDigital = 0;
            int topOffsetDigital = 0;
            int topOffsetAnalog = 0;
            HashMap<16, Enum> digitalControlButtons = new HashMap<16, Enum>();
            HashMap<16, Enum> analogControlButtons = new HashMap<16, Enum>();
            for (Enum enum_ : ControlSystem.ControlsJoystick.values()) {
                if (((ControlSystem.ControlsJoystick)enum_).systemName.startsWith(string)) {
                    GUIComponentButton button;
                    if (!((ControlSystem.ControlsJoystick)enum_).isAxis) {
                        button = new GUIComponentButton(guiLeft + 8 + leftOffsetDigital, guiTop + 20 + topOffsetDigital, 80, ((ControlSystem.ControlsJoystick)enum_).translatedName, 15, true){

                            @Override
                            public void onClicked() {
                                ((ControlSystem.ControlsJoystick)((Object)((Map)GUIConfig.this.digitalAssignButtons.get(GUIConfig.this.vehicleConfiguring)).get(this))).setControl(GUIConfig.this.selectedJoystick, GUIConfig.this.joystickComponentId);
                                GUIConfig.this.joystickComponentId = -1;
                            }
                        };
                        digitalControlButtons.put(button, enum_);
                        this.addButton(button);
                        topOffsetDigital = (short)(topOffsetDigital + button.height);
                    } else {
                        button = new GUIComponentButton(guiLeft + 85, guiTop + 40 + topOffsetAnalog, 80, ((ControlSystem.ControlsJoystick)enum_).translatedName, 20, true){

                            @Override
                            public void onClicked() {
                                GUIConfig.this.controlCalibrating = (ControlSystem.ControlsJoystick)((Object)((Map)GUIConfig.this.analogAssignButtons.get(GUIConfig.this.vehicleConfiguring)).get(this));
                                GUIConfig.this.axisMinBoundsTextBox.setText("0.0");
                                GUIConfig.this.axisMaxBoundsTextBox.setText("0.0");
                                GUIConfig.this.calibrating = true;
                            }
                        };
                        analogControlButtons.put(button, enum_);
                        this.addButton(button);
                        topOffsetAnalog = (short)(topOffsetAnalog + button.height);
                    }
                }
                if (topOffsetDigital < 135) continue;
                topOffsetDigital = 0;
                leftOffsetDigital = (short)(leftOffsetDigital + 80);
            }
            this.digitalAssignButtons.put(string, digitalControlButtons);
            this.analogAssignButtons.put(string, analogControlButtons);
        }
        this.confirmBoundsButton = new GUIComponentButton(guiLeft + 25, guiTop + 160, 100, MasterLoader.coreInterface.translate("gui.config.joystick.confirm")){

            @Override
            public void onClicked() {
                boolean isInverted = ((GUIConfig)GUIConfig.this).invertAxisButton.text.contains(MasterLoader.coreInterface.translate("gui.config.joystick.invert"));
                GUIConfig.this.controlCalibrating.setAxisControl(GUIConfig.this.selectedJoystick, GUIConfig.this.joystickComponentId, Double.valueOf(GUIConfig.this.axisMinBoundsTextBox.getText()), Double.valueOf(GUIConfig.this.axisMaxBoundsTextBox.getText()), isInverted);
                GUIConfig.this.joystickComponentId = -1;
                GUIConfig.this.calibrating = false;
            }
        };
        this.addButton(this.confirmBoundsButton);
        this.invertAxisButton = new GUIComponentButton(guiLeft + 50, guiTop + 120, 150, MasterLoader.coreInterface.translate("gui.config.joystick.axismode") + MasterLoader.coreInterface.translate("gui.config.joystick.normal")){

            @Override
            public void onClicked() {
                this.text = this.text.contains(MasterLoader.coreInterface.translate("gui.config.joystick.invert")) ? MasterLoader.coreInterface.translate("gui.config.joystick.axismode") + MasterLoader.coreInterface.translate("gui.config.joystick.normal") : MasterLoader.coreInterface.translate("gui.config.joystick.axismode") + MasterLoader.coreInterface.translate("gui.config.joystick.invert");
            }
        };
        this.addButton(this.invertAxisButton);
        this.axisMinBoundsTextBox = new GUIComponentTextBox(guiLeft + 50, guiTop + 90, 150, "0.0");
        this.addTextBox(this.axisMinBoundsTextBox);
        this.axisMinBoundsTextBox.enabled = false;
        this.axisMaxBoundsTextBox = new GUIComponentTextBox(guiLeft + 50, guiTop + 60, 150, "0.0");
        this.addTextBox(this.axisMaxBoundsTextBox);
        this.axisMaxBoundsTextBox.enabled = false;
        this.addLabel(new GUIComponentLabel(guiLeft + 20, guiTop + 10, Color.BLACK, MasterLoader.coreInterface.translate("gui.config.joystick.calibrate1")).setButton(this.confirmBoundsButton));
        this.addLabel(new GUIComponentLabel(guiLeft + 20, guiTop + 20, Color.BLACK, MasterLoader.coreInterface.translate("gui.config.joystick.calibrate2")).setButton(this.confirmBoundsButton));
    }

    @Override
    public void setStates() {
        this.configScreenButton.enabled = this.configuringControls;
        this.controlScreenButton.enabled = !this.configScreenButton.enabled;
        for (GUIComponentButton button : this.configButtons.keySet()) {
            button.visible = !this.configuringControls;
        }
        this.vehicleSelectionFaultLabel.visible = !MasterLoader.inputInterface.isJoystickSupportEnabled() && this.configuringControls;
        for (GUIComponentButton button : this.vehicleSelectionButtons.keySet()) {
            button.visible = this.configuringControls && this.vehicleConfiguring.isEmpty();
        }
        this.finishKeyboardBindingsButton.visible = this.configuringControls && !this.vehicleConfiguring.isEmpty() && this.configuringKeyboard;
        for (String vehicleType : this.keyboardBoxes.keySet()) {
            for (GUIComponentTextBox textBox : this.keyboardBoxes.get(vehicleType).keySet()) {
                boolean bl = textBox.visible = this.finishKeyboardBindingsButton.visible && vehicleType.equals(this.vehicleConfiguring);
                if (textBox.focused) {
                    textBox.setText("");
                    continue;
                }
                textBox.setText(MasterLoader.inputInterface.getNameForKeyCode(this.keyboardBoxes.get((Object)vehicleType).get((Object)textBox).config.keyCode));
            }
            for (GUIComponentLabel label : this.keyboardLabels.get(vehicleType).keySet()) {
                label.visible = this.finishKeyboardBindingsButton.visible && vehicleType.equals(this.vehicleConfiguring);
                ControlSystem.ControlsKeyboardDynamic dynamicControl = this.keyboardLabels.get(vehicleType).get(label);
                label.text = dynamicControl.translatedName + ": " + MasterLoader.inputInterface.getNameForKeyCode(dynamicControl.modControl.config.keyCode) + " + " + MasterLoader.inputInterface.getNameForKeyCode(dynamicControl.mainControl.config.keyCode);
            }
        }
        for (GUIComponentButton button : this.joystickSelectionButtons.keySet()) {
            button.visible = this.configuringControls && !this.configuringKeyboard && !this.vehicleConfiguring.isEmpty() && this.selectedJoystick == null;
        }
        boolean onComponentSelectScreen = this.selectedJoystick != null && this.joystickComponentId == -1;
        for (int i = 0; i < 9; i = (int)((byte)(i + 1))) {
            GUIComponentButton button = this.joystickComponentSelectionButtons.get(i);
            boolean bl = button.visible = onComponentSelectScreen && i + this.scrollSpot < MasterLoader.inputInterface.getJoystickInputCount(this.selectedJoystick);
            if (!button.visible) continue;
            button.text = String.format(" %02d  %-15.15s", i + this.scrollSpot + 1, MasterLoader.inputInterface.getJoystickInputName(this.selectedJoystick, i + this.scrollSpot));
            for (ControlSystem.ControlsJoystick joystickControl : ControlSystem.ControlsJoystick.values()) {
                if (!this.selectedJoystick.equals(joystickControl.config.joystickName) || joystickControl.config.buttonIndex != i + this.scrollSpot || !joystickControl.systemName.startsWith(this.vehicleConfiguring)) continue;
                button.text = button.text + String.format("          %s", joystickControl.translatedName);
            }
        }
        this.componentListUpButton.visible = onComponentSelectScreen;
        this.componentListDownButton.visible = onComponentSelectScreen;
        this.deadzone_lessButton.visible = onComponentSelectScreen;
        this.deadzone_moreButton.visible = onComponentSelectScreen;
        this.deadzone_text.visible = onComponentSelectScreen;
        if (onComponentSelectScreen) {
            this.componentListUpButton.enabled = this.scrollSpot - 9 >= 0;
            this.componentListDownButton.enabled = this.scrollSpot + 9 < MasterLoader.inputInterface.getJoystickInputCount(this.selectedJoystick);
            this.deadzone_lessButton.enabled = (Double)ConfigSystem.configObject.client.joystickDeadZone.value > 0.0;
            this.deadzone_moreButton.enabled = (Double)ConfigSystem.configObject.client.joystickDeadZone.value < 1.0;
            this.deadzone_text.enabled = false;
            this.deadzone_text.setText(MasterLoader.coreInterface.translate("gui.config.joystick.deadzone") + " " + String.valueOf(ConfigSystem.configObject.client.joystickDeadZone.value));
        }
        this.cancelAssignmentButton.enabled = this.cancelAssignmentButton.visible = this.joystickComponentId != -1;
        this.clearAssignmentButton.visible = this.cancelAssignmentButton.visible && !this.calibrating;
        this.clearAssignmentButton.enabled = this.cancelAssignmentButton.visible && !this.calibrating;
        for (String vehicleType : this.digitalAssignButtons.keySet()) {
            for (GUIComponentButton button : this.digitalAssignButtons.get(vehicleType).keySet()) {
                button.visible = this.joystickComponentId != -1 && this.vehicleConfiguring.equals(vehicleType) && this.assigningDigital;
            }
        }
        for (String vehicleType : this.analogAssignButtons.keySet()) {
            for (GUIComponentButton button : this.analogAssignButtons.get(vehicleType).keySet()) {
                button.visible = this.joystickComponentId != -1 && this.vehicleConfiguring.equals(vehicleType) && !this.assigningDigital && !this.calibrating;
            }
        }
        this.confirmBoundsButton.visible = this.calibrating;
        this.cancelAssignmentButton.visible = this.calibrating;
        this.invertAxisButton.visible = this.calibrating;
        this.axisMinBoundsTextBox.visible = this.calibrating;
        this.axisMaxBoundsTextBox.visible = this.calibrating;
        if (this.calibrating) {
            float pollData = MasterLoader.inputInterface.getJoystickInputValue(this.selectedJoystick, this.joystickComponentId);
            if (pollData < 0.0f) {
                this.axisMinBoundsTextBox.setText(String.valueOf(Math.min(Double.valueOf(this.axisMinBoundsTextBox.getText()), (double)pollData)));
            } else {
                this.axisMaxBoundsTextBox.setText(String.valueOf(Math.max(Double.valueOf(this.axisMaxBoundsTextBox.getText()), (double)pollData)));
            }
        }
    }

    private class JoystickControlButton
    extends GUIComponentButton {
        public JoystickControlButton(int x, int y) {
            super(x, y, 215, "", 15, false);
        }

        @Override
        public void onClicked() {
            GUIConfig.this.joystickComponentId = GUIConfig.this.joystickComponentSelectionButtons.indexOf(this) + GUIConfig.this.scrollSpot;
            GUIConfig.this.assigningDigital = !MasterLoader.inputInterface.isJoystickInputAnalog(GUIConfig.this.selectedJoystick, GUIConfig.this.joystickComponentId);
        }

        @Override
        public void renderText() {
            super.renderText();
            if (this.visible) {
                int buttonIndex = GUIConfig.this.joystickComponentSelectionButtons.indexOf(this);
                float pollData = MasterLoader.inputInterface.getJoystickInputValue(GUIConfig.this.selectedJoystick, buttonIndex + GUIConfig.this.scrollSpot);
                if (MasterLoader.inputInterface.isJoystickInputAnalog(GUIConfig.this.selectedJoystick, buttonIndex + GUIConfig.this.scrollSpot)) {
                    MasterLoader.guiInterface.renderRectangle(this.x + 85, this.y + 2, 40, this.height - 4, Color.BLACK);
                    if ((double)Math.abs(pollData) > (Double)ConfigSystem.configObject.client.joystickDeadZone.value) {
                        MasterLoader.guiInterface.renderRectangle(this.x + 85 + 20, this.y + 2, (int)(pollData * 20.0f), this.height - 4, Color.RED);
                    }
                } else if (pollData == 0.0f) {
                    MasterLoader.guiInterface.renderRectangle(this.x + 85 + 20 - (this.height - 4) / 2, this.y + 2, this.height - 4, this.height - 4, Color.BLACK);
                } else if (pollData == 1.0f) {
                    MasterLoader.guiInterface.renderRectangle(this.x + 85 + 20 - (this.height - 4) / 2, this.y + 2, this.height - 4, this.height - 4, Color.RED);
                } else {
                    MasterLoader.guiInterface.renderRectangle(this.x + 85 + 20 - (this.height - 4) / 2, this.y + 2, this.height - 4, this.height - 4, Color.YELLOW);
                }
            }
        }
    }
}

