/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.guis.components.GUIComponentOBJModel;
import minecrafttransportsimulator.guis.components.GUIComponentTextBox;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.JSONInstrument;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPoleComponent;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.rendering.instances.RenderVehicle;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;

public class GUIDevEditor
extends AGUIBase {
    private GUIComponentButton modelRenderButton;
    private GUIComponentButton packExportButton;
    private GUIComponentButton packImportButton;
    private GUIComponentTextBox debug;
    private final EntityVehicleF_Physics vehicleClicked;
    private List<GUIComponentTextBox> dataEntryBoxes = new ArrayList<GUIComponentTextBox>();
    private List<GUIComponentLabel> dataEntryLabels = new ArrayList<GUIComponentLabel>();
    private GUIComponentButton backButton;
    private GUIComponentButton confirmButton;
    private GUIComponentOBJModel componentItemModel;

    public GUIDevEditor(EntityVehicleF_Physics vehicleClicked) {
        this.vehicleClicked = vehicleClicked;
    }

    @Override
    public void setupComponents(int guiLeft, int guiTop) {
        int buttonWidth = this.getWidth() / 3;
        this.packExportButton = new GUIComponentButton(guiLeft, guiTop + 0, buttonWidth, "EXPORT PACKS", 20, true){

            @Override
            public void onClicked() {
                File jsonDir = new File(MasterLoader.gameDirectory, "mts_dev");
                if (!jsonDir.exists() && !jsonDir.mkdir()) {
                    GUIDevEditor.this.debug.setText("ERROR: Could not create dev folder: " + jsonDir.getAbsolutePath() + "\nIs this location write-protected?");
                    return;
                }
                long lastTimeModified = 0L;
                GUIDevEditor.this.debug.setText("Export dir is: " + jsonDir.getAbsolutePath());
                for (String packID : PackParserSystem.getAllPackIDs()) {
                    File packDir = new File(jsonDir, packID);
                    if (!packDir.exists() && !packDir.mkdir()) {
                        GUIDevEditor.this.debug.setText("ERROR: Could not create pack folder: " + packDir.getAbsolutePath() + "\nIs this location write-protected?");
                        return;
                    }
                    for (AItemPack<?> packItem : PackParserSystem.getAllItemsForPack(packID)) {
                        try {
                            File jsonFile;
                            if (packItem.definition instanceof JSONVehicle) {
                                jsonFile = new File(packDir, "vehicle_" + ((AJSONItem)packItem.definition).systemName + ".json");
                            } else if (packItem.definition instanceof JSONPart) {
                                jsonFile = new File(packDir, "part_" + ((AJSONItem)packItem.definition).systemName + ".json");
                            } else if (packItem.definition instanceof JSONInstrument) {
                                jsonFile = new File(packDir, "instrument_" + ((AJSONItem)packItem.definition).systemName + ".json");
                            } else {
                                if (!(packItem.definition instanceof JSONPoleComponent)) continue;
                                jsonFile = new File(packDir, "polesign_" + ((AJSONItem)packItem.definition).systemName + ".json");
                            }
                            FileWriter writer = new FileWriter(jsonFile);
                            PackParserSystem.packParser.toJson(packItem.definition, packItem.definition.getClass(), (Appendable)writer);
                            lastTimeModified = jsonFile.lastModified();
                            writer.flush();
                            writer.close();
                        }
                        catch (IOException e) {
                            GUIDevEditor.this.debug.setText("ERROR: Could not save pack definition to disk.  Error is:\n" + e.getMessage());
                            return;
                        }
                    }
                    GUIDevEditor.this.debug.setText(GUIDevEditor.this.debug.getText() + "\nExported pack: " + packID);
                }
                try {
                    File lastModifiedFile = new File(jsonDir, "lastexported.txt");
                    FileWriter writer = new FileWriter(lastModifiedFile);
                    writer.write(String.valueOf(lastTimeModified));
                    writer.flush();
                    writer.close();
                    GUIDevEditor.this.debug.setText(GUIDevEditor.this.debug.getText() + "\nExporting finished.");
                }
                catch (IOException e) {
                    GUIDevEditor.this.debug.setText("\nERROR: Could not save last modified timestamp to disk.  Error is:\n" + e.getMessage());
                    return;
                }
            }
        };
        this.addButton(this.packExportButton);
        this.packImportButton = new GUIComponentButton(guiLeft + buttonWidth, guiTop + 0, buttonWidth, "IMPORT PACKS", 20, true){

            @Override
            public void onClicked() {
                File jsonDir = new File(MasterLoader.gameDirectory, "mts_dev");
                if (jsonDir.exists()) {
                    GUIDevEditor.this.debug.setText("Import dir is: " + jsonDir.getAbsolutePath());
                    File lastModifiedFile = new File(jsonDir, "lastexported.txt");
                    if (lastModifiedFile.exists()) {
                        long lastTimeModified;
                        try {
                            FileReader reader = new FileReader(lastModifiedFile);
                            BufferedReader buffer = new BufferedReader(reader);
                            lastTimeModified = Long.valueOf(buffer.readLine());
                            buffer.close();
                        }
                        catch (Exception e) {
                            GUIDevEditor.this.debug.setText("\nERROR: Could not read last modified timestamp from disk.  Error is:\n" + e.getMessage());
                            return;
                        }
                        for (String packID : PackParserSystem.getAllPackIDs()) {
                            File packDir = new File(jsonDir, packID);
                            if (!packDir.exists()) continue;
                            GUIDevEditor.this.debug.setText(GUIDevEditor.this.debug.getText() + "\nChecking pack: " + packID);
                            for (AItemPack<?> packItem : PackParserSystem.getAllItemsForPack(packID)) {
                                File jsonFile;
                                if (packItem.definition instanceof JSONVehicle) {
                                    jsonFile = new File(packDir, "vehicle_" + ((AJSONItem)packItem.definition).systemName + ".json");
                                } else if (packItem.definition instanceof JSONPart) {
                                    jsonFile = new File(packDir, "part_" + ((AJSONItem)packItem.definition).systemName + ".json");
                                } else if (packItem.definition instanceof JSONInstrument) {
                                    jsonFile = new File(packDir, "instrument_" + ((AJSONItem)packItem.definition).systemName + ".json");
                                } else {
                                    if (!(packItem.definition instanceof JSONPoleComponent)) continue;
                                    jsonFile = new File(packDir, "polesign_" + ((AJSONItem)packItem.definition).systemName + ".json");
                                }
                                if (jsonFile.lastModified() <= lastTimeModified) continue;
                                GUIDevEditor.this.debug.setText(GUIDevEditor.this.debug.getText() + "\nImporting file: " + jsonFile.getName());
                                try {
                                    AJSONItem loadedDefinition;
                                    AJSONItem definition;
                                    if (packItem.definition instanceof JSONVehicle) {
                                        definition = (JSONVehicle)packItem.definition;
                                        loadedDefinition = (JSONVehicle)PackParserSystem.packParser.fromJson((Reader)new FileReader(jsonFile), JSONVehicle.class);
                                        definition.general = loadedDefinition.general;
                                        definition.definitions = loadedDefinition.definitions;
                                        definition.motorized = loadedDefinition.motorized;
                                        definition.parts = loadedDefinition.parts;
                                        definition.collision = loadedDefinition.collision;
                                        definition.doors = loadedDefinition.doors;
                                        definition.rendering = loadedDefinition.rendering;
                                        RenderVehicle.clearVehicleCaches(definition);
                                        continue;
                                    }
                                    if (packItem.definition instanceof JSONPart) {
                                        definition = (JSONPart)packItem.definition;
                                        loadedDefinition = (JSONPart)PackParserSystem.packParser.fromJson((Reader)new FileReader(jsonFile), JSONPart.class);
                                        ((JSONPart)definition).general = ((JSONPart)loadedDefinition).general;
                                        ((JSONPart)definition).engine = ((JSONPart)loadedDefinition).engine;
                                        ((JSONPart)definition).ground = ((JSONPart)loadedDefinition).ground;
                                        ((JSONPart)definition).propeller = ((JSONPart)loadedDefinition).propeller;
                                        ((JSONPart)definition).gun = ((JSONPart)loadedDefinition).gun;
                                        ((JSONPart)definition).bullet = ((JSONPart)loadedDefinition).bullet;
                                        ((JSONPart)definition).interactable = ((JSONPart)loadedDefinition).interactable;
                                        ((JSONPart)definition).effector = ((JSONPart)loadedDefinition).effector;
                                        ((JSONPart)definition).custom = ((JSONPart)loadedDefinition).custom;
                                        ((JSONPart)definition).subParts = ((JSONPart)loadedDefinition).subParts;
                                        ((JSONPart)definition).collision = ((JSONPart)loadedDefinition).collision;
                                        ((JSONPart)definition).rendering = ((JSONPart)loadedDefinition).rendering;
                                        RenderVehicle.clearPartCaches((JSONPart)definition);
                                        continue;
                                    }
                                    if (packItem.definition instanceof JSONInstrument) {
                                        definition = (JSONInstrument)packItem.definition;
                                        loadedDefinition = (JSONInstrument)PackParserSystem.packParser.fromJson((Reader)new FileReader(jsonFile), JSONInstrument.class);
                                        ((JSONInstrument)definition).general = ((JSONInstrument)loadedDefinition).general;
                                        ((JSONInstrument)definition).components = ((JSONInstrument)loadedDefinition).components;
                                        continue;
                                    }
                                    if (!(packItem.definition instanceof JSONPoleComponent)) continue;
                                    definition = (JSONPoleComponent)packItem.definition;
                                    loadedDefinition = (JSONPoleComponent)PackParserSystem.packParser.fromJson((Reader)new FileReader(jsonFile), JSONPoleComponent.class);
                                    ((JSONPoleComponent)definition).general = ((JSONPoleComponent)loadedDefinition).general;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    GUIDevEditor.this.debug.setText(GUIDevEditor.this.debug.getText() + "\nERROR: could not parse file.  Error is: " + e.getMessage());
                                }
                            }
                        }
                        GUIDevEditor.this.debug.setText(GUIDevEditor.this.debug.getText() + "\nImporting finished.");
                    } else {
                        GUIDevEditor.this.debug.setText("ERROR: No last modified timestamp file found at location: " + lastModifiedFile.getAbsolutePath() + "\nPlease re-export your pack data.");
                    }
                } else {
                    GUIDevEditor.this.debug.setText("ERROR: Could not find dev folder: " + jsonDir.getAbsolutePath());
                }
            }
        };
        this.addButton(this.packImportButton);
        this.modelRenderButton = new GUIComponentButton(guiLeft + 2 * buttonWidth, guiTop + 0, buttonWidth, "MODEL RENDER", 20, true){

            @Override
            public void onClicked() {
                ((GUIDevEditor)GUIDevEditor.this).modelRenderButton.visible = false;
                ((GUIDevEditor)GUIDevEditor.this).packExportButton.visible = false;
                ((GUIDevEditor)GUIDevEditor.this).packImportButton.visible = false;
                ((GUIDevEditor)GUIDevEditor.this).debug.visible = false;
                ((GUIDevEditor)GUIDevEditor.this).componentItemModel.visible = true;
                ((GUIDevEditor)GUIDevEditor.this).backButton.visible = true;
                ((GUIDevEditor)GUIDevEditor.this).confirmButton.visible = true;
                for (int i = 0; i < GUIDevEditor.this.dataEntryBoxes.size(); i = (int)((byte)(i + 1))) {
                    ((GUIComponentTextBox)((GUIDevEditor)GUIDevEditor.this).dataEntryBoxes.get((int)i)).visible = true;
                }
            }
        };
        this.addButton(this.modelRenderButton);
        this.backButton = new GUIComponentButton(guiLeft + 20, guiTop + 140, 60, "BACK", 20, true){

            @Override
            public void onClicked() {
                ((GUIDevEditor)GUIDevEditor.this).modelRenderButton.visible = true;
                ((GUIDevEditor)GUIDevEditor.this).packExportButton.visible = true;
                ((GUIDevEditor)GUIDevEditor.this).packImportButton.visible = true;
                ((GUIDevEditor)GUIDevEditor.this).debug.visible = true;
                ((GUIDevEditor)GUIDevEditor.this).componentItemModel.visible = false;
                ((GUIDevEditor)GUIDevEditor.this).backButton.visible = false;
                ((GUIDevEditor)GUIDevEditor.this).confirmButton.visible = false;
                for (int i = 0; i < GUIDevEditor.this.dataEntryBoxes.size(); i = (int)((byte)(i + 1))) {
                    ((GUIComponentTextBox)((GUIDevEditor)GUIDevEditor.this).dataEntryBoxes.get((int)i)).visible = false;
                }
            }
        };
        this.addButton(this.backButton);
        this.confirmButton = new GUIComponentButton(guiLeft + 100, guiTop + 140, 60, "CONFIRM", 20, true){

            @Override
            public void onClicked() {
                try {
                    int dataEntryBoxIndex = 0;
                    ((GUIDevEditor)GUIDevEditor.this).componentItemModel.modelLocation = String.valueOf(((GUIComponentTextBox)GUIDevEditor.this.dataEntryBoxes.get(dataEntryBoxIndex++)).getText());
                    ((GUIDevEditor)GUIDevEditor.this).componentItemModel.textureLocation = String.valueOf(((GUIComponentTextBox)GUIDevEditor.this.dataEntryBoxes.get(dataEntryBoxIndex++)).getText());
                    ((GUIDevEditor)GUIDevEditor.this).componentItemModel.x = Integer.valueOf(((GUIComponentTextBox)GUIDevEditor.this.dataEntryBoxes.get(dataEntryBoxIndex++)).getText());
                    ((GUIDevEditor)GUIDevEditor.this).componentItemModel.y = Integer.valueOf(((GUIComponentTextBox)GUIDevEditor.this.dataEntryBoxes.get(dataEntryBoxIndex++)).getText());
                    ((GUIDevEditor)GUIDevEditor.this).componentItemModel.scale = Float.valueOf(((GUIComponentTextBox)GUIDevEditor.this.dataEntryBoxes.get(dataEntryBoxIndex++)).getText()).floatValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.addButton(this.confirmButton);
        this.debug = new GUIComponentTextBox(guiLeft, guiTop + 20, this.getWidth(), "", this.getHeight() - 20, Color.WHITE, Color.BLACK, 1200);
        this.addTextBox(this.debug);
        this.dataEntryBoxes.clear();
        this.dataEntryLabels.clear();
        int currentRow = 15;
        for (int i = 0; i < 5; i = (int)((byte)(i + 1))) {
            int height = i < 2 ? 40 : 10;
            GUIComponentTextBox dataEntryBox = new GUIComponentTextBox(guiLeft + 100, guiTop + currentRow, 140, "", height, Color.WHITE, Color.BLACK, 100);
            GUIComponentLabel dataEntryLabel = new GUIComponentLabel(guiLeft + 15, dataEntryBox.y, Color.WHITE, "").setBox(dataEntryBox);
            this.dataEntryBoxes.add(dataEntryBox);
            this.dataEntryLabels.add(dataEntryLabel);
            this.addTextBox(dataEntryBox);
            this.addLabel(dataEntryLabel);
            currentRow += height + 1;
        }
        this.componentItemModel = new GUIComponentOBJModel(guiLeft + 208, guiTop + 205, 1.0f, true, false, true);
        this.componentItemModel.scale = 6.0f;
        this.addOBJModel(this.componentItemModel);
        int labelBoxIndex = 0;
        this.dataEntryLabels.get((int)labelBoxIndex).text = "Model:";
        this.dataEntryBoxes.get(labelBoxIndex++).setText(this.vehicleClicked.definition.getModelLocation());
        this.dataEntryLabels.get((int)labelBoxIndex).text = "Texture:";
        this.dataEntryBoxes.get(labelBoxIndex++).setText(this.vehicleClicked.definition.getTextureLocation(this.vehicleClicked.currentSubName));
        this.dataEntryLabels.get((int)labelBoxIndex).text = "X-Pos (px):";
        this.dataEntryBoxes.get(labelBoxIndex++).setText(String.valueOf(this.componentItemModel.x));
        this.dataEntryLabels.get((int)labelBoxIndex).text = "Y-Pos (px):";
        this.dataEntryBoxes.get(labelBoxIndex++).setText(String.valueOf(this.componentItemModel.y));
        this.dataEntryLabels.get((int)labelBoxIndex).text = "Scale (1blk=1px):";
        this.dataEntryBoxes.get(labelBoxIndex++).setText(String.valueOf(this.componentItemModel.scale));
        this.backButton.onClicked();
    }

    @Override
    public void setStates() {
        try {
            this.componentItemModel.x = Integer.valueOf(this.dataEntryBoxes.get(2).getText());
            this.componentItemModel.y = Integer.valueOf(this.dataEntryBoxes.get(3).getText());
            this.componentItemModel.scale = Float.valueOf(this.dataEntryBoxes.get(4).getText()).floatValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean renderBackground() {
        return this.componentItemModel != null && this.componentItemModel.visible;
    }

    @Override
    public int getWidth() {
        return this.componentItemModel != null && this.componentItemModel.visible ? super.getWidth() : 350;
    }
}

