/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentInstrument;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;

public class GUIHUD
extends AGUIBase {
    private static final int HUD_WIDTH = 400;
    private static final int HUD_HEIGHT = 140;
    private final EntityVehicleF_Physics vehicle;

    public GUIHUD(EntityVehicleF_Physics vehicle) {
        this.vehicle = vehicle;
    }

    @Override
    public final void setupComponents(int guiLeft, int guiTop) {
        for (Byte instrumentNumber : this.vehicle.instruments.keySet()) {
            if (this.vehicle.definition.motorized.instruments.get((int)instrumentNumber.byteValue()).optionalPartNumber != 0) continue;
            this.addInstrument(new GUIComponentInstrument(guiLeft, guiTop, instrumentNumber, this.vehicle));
        }
    }

    @Override
    public void setStates() {
    }

    @Override
    public boolean renderBackground() {
        return MasterLoader.gameInterface.inFirstPerson() ? !((Boolean)ConfigSystem.configObject.client.transpHUD_1P.value).booleanValue() : (Boolean)ConfigSystem.configObject.client.transpHUD_3P.value == false;
    }

    @Override
    public AGUIBase.GUILightingMode getGUILightMode() {
        return this.vehicle.areInteriorLightsOn() ? AGUIBase.GUILightingMode.LIT : AGUIBase.GUILightingMode.DARK;
    }

    @Override
    public int getWidth() {
        return 400;
    }

    @Override
    public int getHeight() {
        return 140;
    }

    @Override
    public boolean renderFlushBottom() {
        return true;
    }

    @Override
    public String getTexture() {
        return this.vehicle.definition.rendering.hudTexture != null ? this.vehicle.definition.rendering.hudTexture : "mts:textures/guis/hud.png";
    }
}

