/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentInstrument;
import minecrafttransportsimulator.guis.components.GUIComponentItem;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.guis.instances.AGUIPanel;
import minecrafttransportsimulator.guis.instances.GUIHUD;
import minecrafttransportsimulator.guis.instances.GUIPanelAircraft;
import minecrafttransportsimulator.guis.instances.GUIPanelGround;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.instances.ItemInstrument;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.instances.PacketVehicleInstruments;
import minecrafttransportsimulator.rendering.instances.RenderInstrument;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import org.lwjgl.opengl.GL11;

public class GUIInstruments
extends AGUIBase {
    private final EntityVehicleF_Physics vehicle;
    private final GUIHUD hudGUI;
    private final AGUIPanel panelGUI;
    private final TreeMap<String, List<IWrapperItemStack>> playerInstruments = new TreeMap();
    private TexturelessButton prevPackButton;
    private TexturelessButton nextPackButton;
    private TexturelessButton clearButton;
    private String currentPack;
    private GUIComponentLabel packName;
    private boolean hudSelected = true;
    private TexturelessButton hudButton;
    private TexturelessButton panelButton;
    private GUIComponentLabel infoLabel;
    private JSONVehicle.PackInstrument selectedInstrumentOnVehicle;
    private final List<TexturelessButton> instrumentSlots = new ArrayList<TexturelessButton>();
    private final List<GUIComponentItem> instrumentSlotIcons = new ArrayList<GUIComponentItem>();
    private final List<TexturelessButton> vehicleInstrumentSlots = new ArrayList<TexturelessButton>();
    private final List<GUIComponentInstrument> vehicleInstruments = new ArrayList<GUIComponentInstrument>();

    public GUIInstruments(EntityVehicleF_Physics vehicle, IWrapperPlayer player) {
        this.vehicle = vehicle;
        this.hudGUI = new GUIHUD(vehicle);
        this.panelGUI = ((JSONVehicle.VehicleGeneral)vehicle.definition.general).isAircraft ? new GUIPanelAircraft(vehicle) : new GUIPanelGround(vehicle);
        for (AItemPack<?> packItem : PackParserSystem.getAllPackItems()) {
            if (!(packItem instanceof ItemInstrument) || !player.isCreative() && !player.getInventory().hasItem(packItem)) continue;
            if (!this.playerInstruments.containsKey(((AJSONItem)packItem.definition).packID)) {
                this.playerInstruments.put(((AJSONItem)packItem.definition).packID, new ArrayList());
                if (this.currentPack == null) {
                    this.currentPack = ((AJSONItem)packItem.definition).packID;
                }
            }
            this.playerInstruments.get(((AJSONItem)packItem.definition).packID).add(MasterLoader.coreInterface.getStack(packItem));
        }
    }

    @Override
    public void setupComponents(int guiLeft, int guiTop) {
        this.prevPackButton = new TexturelessButton(guiLeft, guiTop - 74, 20, "<"){

            @Override
            public void onClicked() {
                GUIInstruments.this.currentPack = GUIInstruments.this.playerInstruments.lowerKey(GUIInstruments.this.currentPack);
            }
        };
        this.addButton(this.prevPackButton);
        this.nextPackButton = new TexturelessButton(guiLeft, guiTop - 52, 20, ">"){

            @Override
            public void onClicked() {
                GUIInstruments.this.currentPack = GUIInstruments.this.playerInstruments.higherKey(GUIInstruments.this.currentPack);
            }
        };
        this.addButton(this.nextPackButton);
        this.instrumentSlots.clear();
        this.instrumentSlotIcons.clear();
        int instrumentButtonSize = 22;
        if (this.currentPack != null) {
            for (int i = 0; i < 30; i = (int)((byte)(i + 1))) {
                TexturelessButton instrumentButton = new TexturelessButton(guiLeft + 23 + 22 * (i / 2), guiTop - 75 + 22 * (i % 2), 22, "", 22, false){

                    @Override
                    public void onClicked() {
                        MasterLoader.networkInterface.sendToServer(new PacketVehicleInstruments(GUIInstruments.this.vehicle, (byte)((GUIInstruments)GUIInstruments.this).vehicle.definition.motorized.instruments.indexOf(GUIInstruments.this.selectedInstrumentOnVehicle), (ItemInstrument)((IWrapperItemStack)((List)GUIInstruments.this.playerInstruments.get(GUIInstruments.this.currentPack)).get(GUIInstruments.this.instrumentSlots.indexOf(this))).getItem()));
                        GUIInstruments.this.selectedInstrumentOnVehicle = null;
                    }

                    @Override
                    public void renderButton(int mouseX, int mouseY) {
                        super.renderButton(mouseX, mouseY);
                    }
                };
                this.addButton(instrumentButton);
                this.instrumentSlots.add(instrumentButton);
                GUIComponentItem instrumentItem = new GUIComponentItem(instrumentButton.x, instrumentButton.y, 1.375f, null);
                this.addItem(instrumentItem);
                this.instrumentSlotIcons.add(instrumentItem);
            }
        }
        this.packName = new GUIComponentLabel(guiLeft + 40, guiTop - 85, Color.WHITE, "");
        this.addLabel(this.packName);
        this.clearButton = new TexturelessButton(guiLeft + this.getWidth() - 44, guiTop - 75, 44, MasterLoader.coreInterface.translate("gui.instruments.clear"), 44, true){

            @Override
            public void onClicked() {
                MasterLoader.networkInterface.sendToServer(new PacketVehicleInstruments(GUIInstruments.this.vehicle, (byte)((GUIInstruments)GUIInstruments.this).vehicle.definition.motorized.instruments.indexOf(GUIInstruments.this.selectedInstrumentOnVehicle), null));
                GUIInstruments.this.selectedInstrumentOnVehicle = null;
            }
        };
        this.addButton(this.clearButton);
        this.hudButton = new TexturelessButton(guiLeft, guiTop - 20, 100, MasterLoader.coreInterface.translate("gui.instruments.main")){

            @Override
            public void onClicked() {
                GUIInstruments.this.hudSelected = true;
                GUIInstruments.this.selectedInstrumentOnVehicle = null;
                GUIInstruments.this.clearComponents();
                GUIInstruments.this.setupComponents(this.x, this.y + 20);
            }
        };
        this.addButton(this.hudButton);
        this.panelButton = new TexturelessButton(guiLeft + this.getWidth() - 100, guiTop - 20, 100, MasterLoader.coreInterface.translate("gui.instruments.control")){

            @Override
            public void onClicked() {
                GUIInstruments.this.hudSelected = false;
                GUIInstruments.this.selectedInstrumentOnVehicle = null;
                GUIInstruments.this.clearComponents();
                GUIInstruments.this.setupComponents(this.x - GUIInstruments.this.getWidth() + 100, this.y + 20);
            }
        };
        this.addButton(this.panelButton);
        this.infoLabel = new GUIComponentLabel(guiLeft + this.getWidth() / 2, guiTop - 20, Color.WHITE, "", AGUIBase.TextPosition.CENTERED, 150, 1.0f, false);
        this.addLabel(this.infoLabel);
        this.vehicleInstrumentSlots.clear();
        for (final JSONVehicle.PackInstrument packInstrument : this.vehicle.definition.motorized.instruments) {
            int instrumentRadius = (int)(64.0f * packInstrument.hudScale);
            if (!(this.hudSelected ^ packInstrument.optionalPartNumber != 0)) continue;
            TexturelessButton instrumentSlotButton = new TexturelessButton(guiLeft + packInstrument.hudX - instrumentRadius, guiTop + packInstrument.hudY - instrumentRadius, 2 * instrumentRadius, "", 2 * instrumentRadius, false){

                @Override
                public void onClicked() {
                    GUIInstruments.this.selectedInstrumentOnVehicle = packInstrument;
                }

                @Override
                public void renderButton(int mouseX, int mouseY) {
                    if (!((GUIInstruments)GUIInstruments.this).vehicle.instruments.containsKey((byte)((GUIInstruments)GUIInstruments.this).vehicle.definition.motorized.instruments.indexOf(packInstrument))) {
                        super.renderButton(mouseX, mouseY);
                    }
                    if (packInstrument.equals(GUIInstruments.this.selectedInstrumentOnVehicle)) {
                        int instrumentRadius = (int)(64.0f * packInstrument.hudScale);
                        if (AGUIBase.inClockPeriod(40, 20)) {
                            GL11.glPushMatrix();
                            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)1.0f);
                            MasterLoader.guiInterface.renderRectangle(this.x, this.y, 2 * instrumentRadius, 2 * instrumentRadius, Color.WHITE);
                            GL11.glPopMatrix();
                        }
                    }
                }
            };
            this.addButton(instrumentSlotButton);
            this.vehicleInstrumentSlots.add(instrumentSlotButton);
        }
        this.vehicleInstruments.clear();
        for (byte i = 0; i < this.vehicle.definition.motorized.instruments.size(); i = (byte)((byte)(i + 1))) {
            JSONVehicle.PackInstrument packInstrument;
            packInstrument = this.vehicle.definition.motorized.instruments.get(i);
            if (!(this.hudSelected ^ packInstrument.optionalPartNumber != 0)) continue;
            GUIComponentInstrument vehicleInstrument = new GUIComponentInstrument(guiLeft, guiTop, i, this.vehicle){

                @Override
                public void renderInstrument() {
                    if (this.vehicle.instruments.containsKey(this.instrumentPackIndex)) {
                        GL11.glPushMatrix();
                        GL11.glTranslated((double)this.x, (double)this.y, (double)0.0);
                        GL11.glScalef((float)this.packInstrument.hudScale, (float)this.packInstrument.hudScale, (float)this.packInstrument.hudScale);
                        RenderInstrument.drawInstrument((ItemInstrument)this.vehicle.instruments.get(this.instrumentPackIndex), this.packInstrument.optionalPartNumber, this.vehicle);
                        GL11.glPopMatrix();
                    }
                }
            };
            this.addInstrument(vehicleInstrument);
            this.vehicleInstruments.add(vehicleInstrument);
        }
    }

    @Override
    public void setStates() {
        this.prevPackButton.enabled = this.playerInstruments.lowerKey(this.currentPack) != null;
        boolean bl = this.nextPackButton.enabled = this.playerInstruments.higherKey(this.currentPack) != null;
        if (this.currentPack != null) {
            for (int i = 0; i < this.instrumentSlots.size(); i = (int)((byte)(i + 1))) {
                if (this.playerInstruments.get(this.currentPack).size() > i) {
                    this.instrumentSlots.get((int)i).visible = true;
                    this.instrumentSlots.get((int)i).enabled = this.selectedInstrumentOnVehicle != null;
                    this.instrumentSlotIcons.get((int)i).stack = this.playerInstruments.get(this.currentPack).get(i);
                    continue;
                }
                this.instrumentSlots.get((int)i).visible = false;
                this.instrumentSlotIcons.get((int)i).stack = null;
            }
            this.packName.text = MasterLoader.coreInterface.getModName(this.currentPack);
        }
        this.hudButton.enabled = !this.hudSelected;
        this.panelButton.enabled = this.hudSelected;
        this.infoLabel.text = this.selectedInstrumentOnVehicle == null ? "\\/  " + MasterLoader.coreInterface.translate("gui.instruments.idle") + "  \\/" : "/\\  " + MasterLoader.coreInterface.translate("gui.instruments.decide") + "  /\\";
        this.clearButton.enabled = this.selectedInstrumentOnVehicle != null && this.vehicle.instruments.containsKey((byte)this.vehicle.definition.motorized.instruments.indexOf(this.selectedInstrumentOnVehicle));
    }

    @Override
    public boolean renderDarkBackground() {
        return true;
    }

    @Override
    public int getWidth() {
        return this.hudSelected ? this.hudGUI.getWidth() : this.panelGUI.getWidth();
    }

    @Override
    public int getHeight() {
        return this.hudSelected ? this.hudGUI.getHeight() : this.panelGUI.getHeight();
    }

    @Override
    public boolean renderFlushBottom() {
        return true;
    }

    @Override
    public String getTexture() {
        return this.hudSelected ? this.hudGUI.getTexture() : this.panelGUI.getTexture();
    }

    private abstract class TexturelessButton
    extends GUIComponentButton {
        public TexturelessButton(int x, int y, int width, String text) {
            super(x, y, width, text);
        }

        public TexturelessButton(int x, int y, int width, String text, int height, boolean centeredText) {
            super(x, y, width, text, height, centeredText);
        }

        @Override
        public void renderButton(int mouseX, int mouseY) {
            if (this.visible) {
                if (this.enabled) {
                    if (mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height) {
                        MasterLoader.guiInterface.renderRectangle(this.x, this.y, this.width, this.height, Color.LIGHT_GRAY);
                    } else {
                        MasterLoader.guiInterface.renderRectangle(this.x, this.y, this.width, this.height, Color.GRAY);
                    }
                } else {
                    MasterLoader.guiInterface.renderRectangle(this.x, this.y, this.width, this.height, Color.BLACK);
                }
            }
        }
    }
}

