/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentItem;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.guis.components.GUIComponentOBJModel;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.instances.ItemVehicle;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.instances.PacketVehicleColorChange;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;

public class GUIPaintGun
extends AGUIBase {
    private final EntityVehicleF_Physics vehicle;
    private final IWrapperPlayer player;
    private GUIComponentLabel partName;
    private GUIComponentButton prevColorButton;
    private GUIComponentButton nextColorButton;
    private GUIComponentButton confirmButton;
    private final List<GUIComponentItem> craftingItemIcons = new ArrayList<GUIComponentItem>();
    private GUIComponentOBJModel modelRender;
    private ItemVehicle currentItem;
    private ItemVehicle prevSubItem;
    private ItemVehicle nextSubItem;

    public GUIPaintGun(EntityVehicleF_Physics vehicle, IWrapperPlayer player) {
        this.vehicle = vehicle;
        this.player = player;
        this.currentItem = (ItemVehicle)PackParserSystem.getItem(vehicle.definition.packID, vehicle.definition.systemName, vehicle.currentSubName);
    }

    @Override
    public void setupComponents(int guiLeft, int guiTop) {
        this.prevColorButton = new GUIComponentButton(guiLeft + 38, guiTop + 135, 20, "<", 20, true, 20, 20, 0, 196, this.getTextureWidth(), this.getTextureHeight()){

            @Override
            public void onClicked() {
                GUIPaintGun.this.currentItem = GUIPaintGun.this.prevSubItem;
                GUIPaintGun.this.updateNames();
            }
        };
        this.addButton(this.prevColorButton);
        this.nextColorButton = new GUIComponentButton(guiLeft + 160, guiTop + 135, 20, ">", 20, true, 20, 20, 0, 196, this.getTextureWidth(), this.getTextureHeight()){

            @Override
            public void onClicked() {
                GUIPaintGun.this.currentItem = GUIPaintGun.this.nextSubItem;
                GUIPaintGun.this.updateNames();
            }
        };
        this.addButton(this.nextColorButton);
        this.partName = new GUIComponentLabel(guiLeft + 60, guiTop + 120, Color.WHITE, "", AGUIBase.TextPosition.LEFT_ALIGNED, 98, 1.0f, false);
        this.addLabel(this.partName);
        this.craftingItemIcons.clear();
        int craftingIconSize = 18;
        for (int i = 0; i < 8; i = (int)((byte)(i + 1))) {
            GUIComponentItem craftingItem = new GUIComponentItem(guiLeft + 225 + 18 * (i / 4), guiTop + 26 + 18 * (i % 4), 1.125f, null);
            this.addItem(craftingItem);
            this.craftingItemIcons.add(craftingItem);
        }
        this.modelRender = new GUIComponentOBJModel(guiLeft + 109, guiTop + 57, 32.0f, true, true, false);
        this.addOBJModel(this.modelRender);
        this.confirmButton = new GUIComponentButton(guiLeft + 99, guiTop + 167, 20, "", 20, true, 20, 20, 20, 196, this.getTextureWidth(), this.getTextureHeight()){

            @Override
            public void onClicked() {
                MasterLoader.networkInterface.sendToServer(new PacketVehicleColorChange(GUIPaintGun.this.vehicle, GUIPaintGun.this.currentItem));
            }
        };
        this.addButton(this.confirmButton);
        this.updateNames();
    }

    @Override
    public void setStates() {
        this.prevColorButton.enabled = this.prevSubItem != null;
        this.nextColorButton.enabled = this.nextSubItem != null;
        this.confirmButton.enabled = this.currentItem != null && (this.player.isCreative() || this.player.getInventory().hasMaterials(this.currentItem, false, true));
    }

    @Override
    public int getWidth() {
        return 327;
    }

    @Override
    public int getHeight() {
        return 196;
    }

    @Override
    public String getTexture() {
        return "mts:textures/guis/paintgun.png";
    }

    private void updateNames() {
        int i;
        List<AItemPack<?>> packItems = PackParserSystem.getAllItemsForPack(this.vehicle.definition.packID);
        int currentItemIndex = packItems.indexOf(this.currentItem);
        this.nextSubItem = null;
        if (currentItemIndex < packItems.size()) {
            for (i = currentItemIndex + 1; i < packItems.size() && this.nextSubItem == null; ++i) {
                if (!((AJSONItem)packItems.get((int)i).definition).systemName.equals(((JSONVehicle)this.currentItem.definition).systemName)) continue;
                this.nextSubItem = (ItemVehicle)packItems.get(i);
                break;
            }
        }
        this.prevSubItem = null;
        if (currentItemIndex > 0) {
            for (i = currentItemIndex - 1; i >= 0 && this.prevSubItem == null; --i) {
                if (!((AJSONItem)packItems.get((int)i).definition).systemName.equals(((JSONVehicle)this.currentItem.definition).systemName)) continue;
                this.prevSubItem = (ItemVehicle)packItems.get(i);
                break;
            }
        }
        this.partName.text = this.currentItem.getItemName();
        List<IWrapperItemStack> craftingMaterials = MasterLoader.coreInterface.parseFromJSON(this.currentItem, false, true);
        for (int i2 = 0; i2 < this.craftingItemIcons.size(); i2 = (int)((byte)(i2 + 1))) {
            this.craftingItemIcons.get((int)i2).stack = i2 < craftingMaterials.size() ? craftingMaterials.get(i2) : null;
        }
        this.modelRender.modelLocation = ((JSONVehicle)this.currentItem.definition).getModelLocation();
        this.modelRender.textureLocation = ((JSONVehicle)this.currentItem.definition).getTextureLocation(this.currentItem.subName);
    }
}

