/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.guis.components.GUIComponentSelector;
import minecrafttransportsimulator.guis.instances.AGUIPanel;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.instances.PacketVehicleControlDigital;
import minecrafttransportsimulator.packets.instances.PacketVehicleLightToggle;
import minecrafttransportsimulator.packets.instances.PacketVehiclePartEngine;
import minecrafttransportsimulator.rendering.components.LightType;
import minecrafttransportsimulator.rendering.instances.RenderVehicle;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.PartEngine;

public class GUIPanelAircraft
extends AGUIPanel {
    private static final int NAVIGATION_TEXTURE_WIDTH_OFFSET = 200;
    private static final int NAVIGATION_TEXTURE_HEIGHT_OFFSET = 216;
    private static final int STROBE_TEXTURE_WIDTH_OFFSET = 220;
    private static final int STROBE_TEXTURE_HEIGHT_OFFSET = 216;
    private static final int TAXI_TEXTURE_WIDTH_OFFSET = 240;
    private static final int TAXI_TEXTURE_HEIGHT_OFFSET = 216;
    private static final int LANDING_TEXTURE_WIDTH_OFFSET = 260;
    private static final int LANDING_TEXTURE_HEIGHT_OFFSET = 216;
    private static final int ENGINEMAG_TEXTURE_WIDTH_OFFSET = 280;
    private static final int ENGINEMAG_TEXTURE_HEIGHT_OFFSET = 216;
    private static final int ENGINESTART_TEXTURE_WIDTH_OFFSET = 300;
    private static final int ENGINESTART_TEXTURE_HEIGHT_OFFSET = 196;
    private static final int REVERSE_TEXTURE_WIDTH_OFFSET = 320;
    private static final int REVERSE_TEXTURE_HEIGHT_OFFSET = 216;
    private static final int TRIM_TEXTURE_WIDTH_OFFSET = 340;
    private static final int TRIM_TEXTURE_HEIGHT_OFFSET = 216;
    private static final int AUTOPILOT_TEXTURE_WIDTH_OFFSET = 380;
    private static final int AUTOPILOT_TEXTURE_HEIGHT_OFFSET = 216;
    private static final int GEAR_TEXTURE_WIDTH_OFFSET = 400;
    private static final int GEAR_TEXTURE_HEIGHT_OFFSET = 176;
    private static final int CUSTOM_TEXTURE_WIDTH_OFFSET = 420;
    private static final int CUSTOM_TEXTURE_HEIGHT_OFFSET = 216;
    private final Map<LightType, GUIComponentSelector> lightSelectors = new HashMap<LightType, GUIComponentSelector>();
    private final Map<Byte, GUIComponentSelector> magnetoSelectors = new HashMap<Byte, GUIComponentSelector>();
    private final Map<Byte, GUIComponentSelector> starterSelectors = new HashMap<Byte, GUIComponentSelector>();
    private final List<GUIComponentSelector> customSelectors = new ArrayList<GUIComponentSelector>();
    private GUIComponentSelector aileronTrimSelector;
    private GUIComponentSelector elevatorTrimSelector;
    private GUIComponentSelector rudderTrimSelector;
    private GUIComponentSelector reverseSelector;
    private GUIComponentSelector autopilotSelector;
    private GUIComponentSelector gearSelector;
    private GUIComponentSelector selectedTrimSelector;
    private PacketVehicleControlDigital.Controls selectedTrimType = null;
    private boolean selectedTrimDirection;
    private boolean appliedTrimThisRender;

    public GUIPanelAircraft(EntityVehicleF_Physics aircraft) {
        super(aircraft);
    }

    @Override
    protected int setupLightComponents(int guiLeft, int guiTop, int xOffset) {
        this.lightSelectors.clear();
        for (final LightType lightType : new LightType[]{LightType.NAVIGATIONLIGHT, LightType.STROBELIGHT, LightType.TAXILIGHT, LightType.LANDINGLIGHT}) {
            int LIGHT_TEXTURE_HEIGHT_OFFSET;
            int LIGHT_TEXTURE_WIDTH_OFFSET;
            switch (lightType) {
                case NAVIGATIONLIGHT: {
                    LIGHT_TEXTURE_WIDTH_OFFSET = 200;
                    LIGHT_TEXTURE_HEIGHT_OFFSET = 216;
                    break;
                }
                case STROBELIGHT: {
                    LIGHT_TEXTURE_WIDTH_OFFSET = 220;
                    LIGHT_TEXTURE_HEIGHT_OFFSET = 216;
                    break;
                }
                case TAXILIGHT: {
                    LIGHT_TEXTURE_WIDTH_OFFSET = 240;
                    LIGHT_TEXTURE_HEIGHT_OFFSET = 216;
                    break;
                }
                case LANDINGLIGHT: {
                    LIGHT_TEXTURE_WIDTH_OFFSET = 260;
                    LIGHT_TEXTURE_HEIGHT_OFFSET = 216;
                    break;
                }
                default: {
                    throw new IllegalArgumentException((Object)((Object)lightType) + " has no texture assigned in the panel!");
                }
            }
            if (!RenderVehicle.doesVehicleHaveLight(this.vehicle, lightType)) continue;
            String lightName = MasterLoader.coreInterface.translate("gui.panel." + lightType.name().toLowerCase() + "s");
            GUIComponentSelector lightSwitch = new GUIComponentSelector(guiLeft + xOffset, guiTop + 12 + this.lightSelectors.size() * 32, 20, 20, lightName, this.vehicle.definition.rendering.panelTextColor, this.vehicle.definition.rendering.panelLitTextColor, 20, 20, LIGHT_TEXTURE_WIDTH_OFFSET, LIGHT_TEXTURE_HEIGHT_OFFSET, this.getTextureWidth(), this.getTextureHeight()){

                @Override
                public void onClicked(boolean leftSide) {
                    MasterLoader.networkInterface.sendToServer(new PacketVehicleLightToggle(GUIPanelAircraft.this.vehicle, lightType));
                }

                @Override
                public void onReleased() {
                }
            };
            this.lightSelectors.put(lightType, lightSwitch);
            this.addSelector(lightSwitch);
        }
        return xOffset + 12 + 20;
    }

    @Override
    protected int setupEngineComponents(int guiLeft, int guiTop, int xOffset) {
        this.magnetoSelectors.clear();
        this.starterSelectors.clear();
        for (final Byte engineNumber : this.vehicle.engines.keySet()) {
            if (engineNumber == 4) {
                xOffset += 52;
            }
            GUIComponentSelector magnetoSwitch = new GUIComponentSelector(guiLeft + xOffset, guiTop + 12 + 32 * (engineNumber % 4), 20, 20, MasterLoader.coreInterface.translate("gui.panel.magneto"), this.vehicle.definition.rendering.panelTextColor, this.vehicle.definition.rendering.panelLitTextColor, 20, 20, 280, 216, this.getTextureWidth(), this.getTextureHeight()){

                @Override
                public void onClicked(boolean leftSide) {
                    MasterLoader.networkInterface.sendToServer(new PacketVehiclePartEngine((PartEngine)GUIPanelAircraft.this.vehicle.engines.get(engineNumber), ((PartEngine)GUIPanelAircraft.this.vehicle.engines.get((Object)engineNumber)).state.magnetoOn ? PacketVehiclePartEngine.Signal.MAGNETO_OFF : PacketVehiclePartEngine.Signal.MAGNETO_ON));
                }

                @Override
                public void onReleased() {
                }
            };
            this.magnetoSelectors.put(engineNumber, magnetoSwitch);
            this.addSelector(magnetoSwitch);
            GUIComponentSelector starterSwitch = new GUIComponentSelector(magnetoSwitch.x + 20, magnetoSwitch.y, 20, 20, MasterLoader.coreInterface.translate("gui.panel.start"), this.vehicle.definition.rendering.panelTextColor, this.vehicle.definition.rendering.panelLitTextColor, 20, 20, 300, 196, this.getTextureWidth(), this.getTextureHeight()){

                @Override
                public void onClicked(boolean leftSide) {
                    if (((PartEngine)GUIPanelAircraft.this.vehicle.engines.get((Object)engineNumber)).state.magnetoOn) {
                        MasterLoader.networkInterface.sendToServer(new PacketVehiclePartEngine((PartEngine)GUIPanelAircraft.this.vehicle.engines.get(engineNumber), ((PartEngine)GUIPanelAircraft.this.vehicle.engines.get((Object)engineNumber)).state.esOn ? PacketVehiclePartEngine.Signal.ES_OFF : PacketVehiclePartEngine.Signal.ES_ON));
                    }
                }

                @Override
                public void onReleased() {
                    MasterLoader.networkInterface.sendToServer(new PacketVehiclePartEngine((PartEngine)GUIPanelAircraft.this.vehicle.engines.get(engineNumber), PacketVehiclePartEngine.Signal.ES_OFF));
                }
            };
            this.starterSelectors.put(engineNumber, starterSwitch);
            this.addSelector(starterSwitch);
        }
        this.aileronTrimSelector = new GUIComponentSelector(guiLeft + (xOffset += 52), guiTop + 12 + 0, 40, 20, MasterLoader.coreInterface.translate("gui.panel.trim_roll"), this.vehicle.definition.rendering.panelTextColor, this.vehicle.definition.rendering.panelLitTextColor, 40, 20, 340, 216, this.getTextureWidth(), this.getTextureHeight()){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPanelAircraft.this.selectedTrimSelector = this;
                GUIPanelAircraft.this.selectedTrimType = PacketVehicleControlDigital.Controls.TRIM_ROLL;
                GUIPanelAircraft.this.selectedTrimDirection = !leftSide;
            }

            @Override
            public void onReleased() {
                GUIPanelAircraft.this.selectedTrimSelector = null;
                GUIPanelAircraft.this.selectedTrimType = null;
            }
        };
        this.addSelector(this.aileronTrimSelector);
        this.elevatorTrimSelector = new GUIComponentSelector(guiLeft + xOffset, guiTop + 12 + 32, 40, 20, MasterLoader.coreInterface.translate("gui.panel.trim_pitch"), this.vehicle.definition.rendering.panelTextColor, this.vehicle.definition.rendering.panelLitTextColor, 40, 20, 340, 216, this.getTextureWidth(), this.getTextureHeight()){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPanelAircraft.this.selectedTrimSelector = this;
                GUIPanelAircraft.this.selectedTrimType = PacketVehicleControlDigital.Controls.TRIM_PITCH;
                GUIPanelAircraft.this.selectedTrimDirection = leftSide;
            }

            @Override
            public void onReleased() {
                GUIPanelAircraft.this.selectedTrimSelector = null;
                GUIPanelAircraft.this.selectedTrimType = null;
            }
        };
        this.addSelector(this.elevatorTrimSelector);
        this.rudderTrimSelector = new GUIComponentSelector(guiLeft + xOffset, guiTop + 12 + 64, 40, 20, MasterLoader.coreInterface.translate("gui.panel.trim_yaw"), this.vehicle.definition.rendering.panelTextColor, this.vehicle.definition.rendering.panelLitTextColor, 40, 20, 340, 216, this.getTextureWidth(), this.getTextureHeight()){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPanelAircraft.this.selectedTrimSelector = this;
                GUIPanelAircraft.this.selectedTrimType = PacketVehicleControlDigital.Controls.TRIM_YAW;
                GUIPanelAircraft.this.selectedTrimDirection = !leftSide;
            }

            @Override
            public void onReleased() {
                GUIPanelAircraft.this.selectedTrimSelector = null;
                GUIPanelAircraft.this.selectedTrimType = null;
            }
        };
        this.addSelector(this.rudderTrimSelector);
        if (this.haveReverseThrustOption && this.vehicle.definition.motorized.hasAutopilot) {
            this.reverseSelector = new GUIComponentSelector(guiLeft + xOffset, guiTop + 12 + 96, 20, 20, MasterLoader.coreInterface.translate("gui.panel.reverse"), this.vehicle.definition.rendering.panelTextColor, this.vehicle.definition.rendering.panelLitTextColor, 20, 20, 320, 216, this.getTextureWidth(), this.getTextureHeight()){

                @Override
                public void onClicked(boolean leftSide) {
                    MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(GUIPanelAircraft.this.vehicle, PacketVehicleControlDigital.Controls.REVERSE, this.selectorState == 0));
                }

                @Override
                public void onReleased() {
                }
            };
            this.addSelector(this.reverseSelector);
            this.autopilotSelector = new GUIComponentSelector(guiLeft + xOffset + 20, guiTop + 12 + 96, 20, 20, MasterLoader.coreInterface.translate("gui.panel.autopilot"), this.vehicle.definition.rendering.panelTextColor, this.vehicle.definition.rendering.panelLitTextColor, 20, 20, 380, 216, this.getTextureWidth(), this.getTextureHeight()){

                @Override
                public void onClicked(boolean leftSide) {
                    MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(GUIPanelAircraft.this.vehicle, PacketVehicleControlDigital.Controls.AUTOPILOT, !GUIPanelAircraft.this.vehicle.autopilot));
                }

                @Override
                public void onReleased() {
                }
            };
            this.addSelector(this.autopilotSelector);
        } else {
            if (this.haveReverseThrustOption) {
                this.reverseSelector = new GUIComponentSelector(guiLeft + xOffset + 10, guiTop + 12 + 96, 20, 20, MasterLoader.coreInterface.translate("gui.panel.reverse"), this.vehicle.definition.rendering.panelTextColor, this.vehicle.definition.rendering.panelLitTextColor, 20, 20, 320, 216, this.getTextureWidth(), this.getTextureHeight()){

                    @Override
                    public void onClicked(boolean leftSide) {
                        MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(GUIPanelAircraft.this.vehicle, PacketVehicleControlDigital.Controls.REVERSE, this.selectorState == 0));
                    }

                    @Override
                    public void onReleased() {
                    }
                };
                this.addSelector(this.reverseSelector);
            }
            if (this.vehicle.definition.motorized.hasAutopilot) {
                this.autopilotSelector = new GUIComponentSelector(guiLeft + xOffset + 10, guiTop + 12 + 96, 20, 20, MasterLoader.coreInterface.translate("gui.panel.autopilot"), this.vehicle.definition.rendering.panelTextColor, this.vehicle.definition.rendering.panelLitTextColor, 20, 20, 380, 216, this.getTextureWidth(), this.getTextureHeight()){

                    @Override
                    public void onClicked(boolean leftSide) {
                        MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(GUIPanelAircraft.this.vehicle, PacketVehicleControlDigital.Controls.AUTOPILOT, !GUIPanelAircraft.this.vehicle.autopilot));
                    }

                    @Override
                    public void onReleased() {
                    }
                };
                this.addSelector(this.autopilotSelector);
            }
        }
        if (this.vehicle.definition.motorized.gearSequenceDuration != 0) {
            this.gearSelector = new GUIComponentSelector(guiLeft + xOffset + 12 + 40, guiTop + 12 + 96, 20, 20, MasterLoader.coreInterface.translate("gui.panel.gear"), this.vehicle.definition.rendering.panelTextColor, this.vehicle.definition.rendering.panelLitTextColor, 20, 20, 400, 176, this.getTextureWidth(), this.getTextureHeight()){

                @Override
                public void onClicked(boolean leftSide) {
                    MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(GUIPanelAircraft.this.vehicle, PacketVehicleControlDigital.Controls.GEAR, !GUIPanelAircraft.this.vehicle.gearUpCommand));
                }

                @Override
                public void onReleased() {
                }
            };
            this.addSelector(this.gearSelector);
        }
        if (this.vehicle.definition.rendering.customVariables != null && this.vehicle.definition.rendering.customVariables.size() > 0) {
            xOffset += 44;
            for (int i = 0; i < this.vehicle.definition.rendering.customVariables.size(); ++i) {
                GUIComponentSelector customSelector = new GUIComponentSelector(guiLeft + xOffset, guiTop + 12 + i % 4 * 32, 20, 20, this.vehicle.definition.rendering.customVariables.get(i), this.vehicle.definition.rendering.panelTextColor, this.vehicle.definition.rendering.panelLitTextColor, 20, 20, 420, 216, this.getTextureWidth(), this.getTextureHeight()){

                    @Override
                    public void onClicked(boolean leftSide) {
                        byte selectorNumber = (byte)GUIPanelAircraft.this.customSelectors.indexOf(this);
                        switch (selectorNumber) {
                            case 0: {
                                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(GUIPanelAircraft.this.vehicle, PacketVehicleControlDigital.Controls.CUSTOM_0, !GUIPanelAircraft.this.vehicle.customsOn.contains(selectorNumber)));
                                break;
                            }
                            case 1: {
                                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(GUIPanelAircraft.this.vehicle, PacketVehicleControlDigital.Controls.CUSTOM_1, !GUIPanelAircraft.this.vehicle.customsOn.contains(selectorNumber)));
                                break;
                            }
                            case 2: {
                                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(GUIPanelAircraft.this.vehicle, PacketVehicleControlDigital.Controls.CUSTOM_2, !GUIPanelAircraft.this.vehicle.customsOn.contains(selectorNumber)));
                                break;
                            }
                            case 3: {
                                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(GUIPanelAircraft.this.vehicle, PacketVehicleControlDigital.Controls.CUSTOM_3, !GUIPanelAircraft.this.vehicle.customsOn.contains(selectorNumber)));
                            }
                        }
                    }

                    @Override
                    public void onReleased() {
                    }
                };
                this.customSelectors.add(customSelector);
                this.addSelector(customSelector);
            }
            return xOffset + 12 + 20;
        }
        return xOffset + 24 + 20;
    }

    @Override
    public void setStates() {
        for (Map.Entry<LightType, GUIComponentSelector> entry : this.lightSelectors.entrySet()) {
            entry.getValue().selectorState = this.vehicle.lightsOn.contains((Object)entry.getKey()) ? 1 : 0;
        }
        for (Map.Entry<Object, GUIComponentSelector> entry : this.magnetoSelectors.entrySet()) {
            if (!this.vehicle.engines.containsKey(entry.getKey())) continue;
            entry.getValue().selectorState = ((PartEngine)this.vehicle.engines.get((Object)entry.getKey())).state.magnetoOn ? 1 : 0;
        }
        for (Map.Entry<Object, GUIComponentSelector> entry : this.starterSelectors.entrySet()) {
            if (!this.vehicle.engines.containsKey(entry.getKey())) continue;
            entry.getValue().selectorState = ((PartEngine)this.vehicle.engines.get((Object)entry.getKey())).state.magnetoOn ? (((PartEngine)this.vehicle.engines.get((Object)entry.getKey())).state.esOn ? 2 : 1) : 0;
        }
        if (this.selectedTrimSelector != null) {
            if (GUIPanelAircraft.inClockPeriod(3, 1)) {
                if (!this.appliedTrimThisRender) {
                    this.selectedTrimSelector.selectorState = this.selectedTrimSelector.selectorState == 0 ? 1 : 0;
                    MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(this.vehicle, this.selectedTrimType, this.selectedTrimDirection));
                    this.appliedTrimThisRender = true;
                }
            } else {
                this.appliedTrimThisRender = false;
            }
        }
        if (this.reverseSelector != null) {
            if (((JSONVehicle.VehicleGeneral)this.vehicle.definition.general).isBlimp) {
                this.reverseSelector.selectorState = 0;
                for (PartEngine partEngine : this.vehicle.engines.values()) {
                    if (partEngine.currentGear >= 0) continue;
                    this.reverseSelector.selectorState = 1;
                    break;
                }
            } else {
                int n = this.reverseSelector.selectorState = this.vehicle.reverseThrust ? 1 : 0;
            }
        }
        if (this.autopilotSelector != null) {
            int n = this.autopilotSelector.selectorState = this.vehicle.autopilot ? 1 : 0;
        }
        if (this.gearSelector != null) {
            this.gearSelector.selectorState = this.vehicle.gearUpCommand ? (this.vehicle.gearMovementTime == this.vehicle.definition.motorized.gearSequenceDuration ? 2 : 3) : (this.vehicle.gearMovementTime == 0 ? 0 : 1);
        }
        for (byte i = 0; i < this.customSelectors.size(); i = (byte)(i + 1)) {
            this.customSelectors.get((int)i).selectorState = this.vehicle.customsOn.contains(i) ? 1 : 0;
        }
    }
}

