/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.guis.components.GUIComponentSelector;
import minecrafttransportsimulator.guis.instances.AGUIPanel;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.instances.PacketVehicleControlDigital;
import minecrafttransportsimulator.packets.instances.PacketVehicleLightToggle;
import minecrafttransportsimulator.packets.instances.PacketVehiclePartEngine;
import minecrafttransportsimulator.rendering.components.LightType;
import minecrafttransportsimulator.rendering.instances.RenderVehicle;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.PartEngine;

public class GUIPanelGround
extends AGUIPanel {
    private static final int LIGHT_TEXTURE_WIDTH_OFFSET = 0;
    private static final int LIGHT_TEXTURE_HEIGHT_OFFSET = 196;
    private static final int TURNSIGNAL_TEXTURE_WIDTH_OFFSET = 20;
    private static final int TURNSIGNAL_TEXTURE_HEIGHT_OFFSET = 176;
    private static final int EMERGENCY_TEXTURE_WIDTH_OFFSET = 40;
    private static final int EMERGENCY_TEXTURE_HEIGHT_OFFSET = 216;
    private static final int SIREN_TEXTURE_WIDTH_OFFSET = 60;
    private static final int SIREN_TEXTURE_HEIGHT_OFFSET = 216;
    private static final int ENGINE_TEXTURE_WIDTH_OFFSET = 80;
    private static final int ENGINE_TEXTURE_HEIGHT_OFFSET = 196;
    private static final int TRAILER_TEXTURE_WIDTH_OFFSET = 100;
    private static final int TRAILER_TEXTURE_HEIGHT_OFFSET = 216;
    private static final int REVERSE_TEXTURE_WIDTH_OFFSET = 120;
    private static final int REVERSE_TEXTURE_HEIGHT_OFFSET = 216;
    private static final int CRUISECONTROL_TEXTURE_WIDTH_OFFSET = 140;
    private static final int CRUISECONTROL_TEXTURE_HEIGHT_OFFSET = 216;
    private static final int GEAR_TEXTURE_WIDTH_OFFSET = 160;
    private static final int GEAR_TEXTURE_HEIGHT_OFFSET = 176;
    private static final int CUSTOM_TEXTURE_WIDTH_OFFSET = 180;
    private static final int CUSTOM_TEXTURE_HEIGHT_OFFSET = 216;
    private GUIComponentSelector lightSelector;
    private GUIComponentSelector turnSignalSelector;
    private GUIComponentSelector emergencySelector;
    private GUIComponentSelector sirenSelector;
    private GUIComponentSelector reverseSelector;
    private GUIComponentSelector cruiseControlSelector;
    private GUIComponentSelector gearSelector;
    private final Map<Byte, GUIComponentSelector> engineSelectors = new HashMap<Byte, GUIComponentSelector>();
    private final List<GUIComponentSelector> trailerSelectors = new ArrayList<GUIComponentSelector>();
    private final List<GUIComponentSelector> customSelectors = new ArrayList<GUIComponentSelector>();

    public GUIPanelGround(EntityVehicleF_Physics groundVehicle) {
        super(groundVehicle);
    }

    @Override
    protected int setupLightComponents(int guiLeft, int guiTop, int xOffset) {
        if (RenderVehicle.doesVehicleHaveLight(this.vehicle, LightType.RUNNINGLIGHT) || RenderVehicle.doesVehicleHaveLight(this.vehicle, LightType.HEADLIGHT)) {
            this.lightSelector = new GUIComponentSelector(guiLeft + xOffset, guiTop + 12 + 0, 20, 20, MasterLoader.coreInterface.translate("gui.panel.headlights"), this.vehicle.definition.rendering.panelTextColor, this.vehicle.definition.rendering.panelLitTextColor, 20, 20, 0, 196, this.getTextureWidth(), this.getTextureHeight()){

                @Override
                public void onClicked(boolean leftSide) {
                    if (leftSide) {
                        if (this.selectorState == 2) {
                            MasterLoader.networkInterface.sendToServer(new PacketVehicleLightToggle(GUIPanelGround.this.vehicle, LightType.HEADLIGHT));
                        } else if (this.selectorState == 1) {
                            MasterLoader.networkInterface.sendToServer(new PacketVehicleLightToggle(GUIPanelGround.this.vehicle, LightType.RUNNINGLIGHT));
                        }
                    } else if (this.selectorState == 0) {
                        if (RenderVehicle.doesVehicleHaveLight(GUIPanelGround.this.vehicle, LightType.RUNNINGLIGHT)) {
                            MasterLoader.networkInterface.sendToServer(new PacketVehicleLightToggle(GUIPanelGround.this.vehicle, LightType.RUNNINGLIGHT));
                        } else {
                            MasterLoader.networkInterface.sendToServer(new PacketVehicleLightToggle(GUIPanelGround.this.vehicle, LightType.HEADLIGHT));
                        }
                    } else if (this.selectorState == 1) {
                        MasterLoader.networkInterface.sendToServer(new PacketVehicleLightToggle(GUIPanelGround.this.vehicle, LightType.HEADLIGHT));
                    }
                }

                @Override
                public void onReleased() {
                }
            };
            this.addSelector(this.lightSelector);
        }
        if (RenderVehicle.doesVehicleHaveLight(this.vehicle, LightType.LEFTTURNLIGHT) || RenderVehicle.doesVehicleHaveLight(this.vehicle, LightType.RIGHTTURNLIGHT)) {
            this.turnSignalSelector = new GUIComponentSelector(guiLeft + xOffset, guiTop + 12 + 32, 20, 20, MasterLoader.coreInterface.translate("gui.panel.turnsignals"), this.vehicle.definition.rendering.panelTextColor, this.vehicle.definition.rendering.panelLitTextColor, 20, 20, 20, 176, this.getTextureWidth(), this.getTextureHeight()){

                @Override
                public void onClicked(boolean leftSide) {
                    if (leftSide) {
                        MasterLoader.networkInterface.sendToServer(new PacketVehicleLightToggle(GUIPanelGround.this.vehicle, LightType.LEFTTURNLIGHT));
                    } else {
                        MasterLoader.networkInterface.sendToServer(new PacketVehicleLightToggle(GUIPanelGround.this.vehicle, LightType.RIGHTTURNLIGHT));
                    }
                }

                @Override
                public void onReleased() {
                }
            };
            this.addSelector(this.turnSignalSelector);
        }
        if (RenderVehicle.doesVehicleHaveLight(this.vehicle, LightType.EMERGENCYLIGHT)) {
            this.emergencySelector = new GUIComponentSelector(guiLeft + xOffset, guiTop + 12 + 64, 20, 20, MasterLoader.coreInterface.translate("gui.panel.emergencylights"), this.vehicle.definition.rendering.panelTextColor, this.vehicle.definition.rendering.panelLitTextColor, 20, 20, 40, 216, this.getTextureWidth(), this.getTextureHeight()){

                @Override
                public void onClicked(boolean leftSide) {
                    MasterLoader.networkInterface.sendToServer(new PacketVehicleLightToggle(GUIPanelGround.this.vehicle, LightType.EMERGENCYLIGHT));
                }

                @Override
                public void onReleased() {
                }
            };
            this.addSelector(this.emergencySelector);
        }
        if (this.vehicle.definition.motorized.sirenSound != null) {
            this.sirenSelector = new GUIComponentSelector(guiLeft + xOffset, guiTop + 12 + 96, 20, 20, MasterLoader.coreInterface.translate("gui.panel.siren"), this.vehicle.definition.rendering.panelTextColor, this.vehicle.definition.rendering.panelLitTextColor, 20, 20, 60, 216, this.getTextureWidth(), this.getTextureHeight()){

                @Override
                public void onClicked(boolean leftSide) {
                    MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(GUIPanelGround.this.vehicle, PacketVehicleControlDigital.Controls.SIREN, !leftSide));
                }

                @Override
                public void onReleased() {
                }
            };
            this.addSelector(this.sirenSelector);
        }
        return xOffset + 12 + 20;
    }

    @Override
    protected int setupEngineComponents(int guiLeft, int guiTop, int xOffset) {
        int i;
        this.engineSelectors.clear();
        for (final Byte engineNumber : this.vehicle.engines.keySet()) {
            if (engineNumber == 5) {
                xOffset += 32;
            }
            GUIComponentSelector engineSelector = new GUIComponentSelector(guiLeft + xOffset, guiTop + 12 + 32 * (engineNumber % 4), 20, 20, MasterLoader.coreInterface.translate("gui.panel.engine"), this.vehicle.definition.rendering.panelTextColor, this.vehicle.definition.rendering.panelLitTextColor, 20, 20, 80, 196, this.getTextureWidth(), this.getTextureHeight()){

                @Override
                public void onClicked(boolean leftSide) {
                    if (this.selectorState == 0 && !leftSide) {
                        MasterLoader.networkInterface.sendToServer(new PacketVehiclePartEngine((PartEngine)GUIPanelGround.this.vehicle.engines.get(engineNumber), PacketVehiclePartEngine.Signal.MAGNETO_ON));
                    } else if (this.selectorState == 1 && !leftSide) {
                        MasterLoader.networkInterface.sendToServer(new PacketVehiclePartEngine((PartEngine)GUIPanelGround.this.vehicle.engines.get(engineNumber), PacketVehiclePartEngine.Signal.ES_ON));
                    } else if (this.selectorState == 1 && leftSide) {
                        MasterLoader.networkInterface.sendToServer(new PacketVehiclePartEngine((PartEngine)GUIPanelGround.this.vehicle.engines.get(engineNumber), PacketVehiclePartEngine.Signal.MAGNETO_OFF));
                    } else if (this.selectorState == 2 && leftSide) {
                        MasterLoader.networkInterface.sendToServer(new PacketVehiclePartEngine((PartEngine)GUIPanelGround.this.vehicle.engines.get(engineNumber), PacketVehiclePartEngine.Signal.ES_OFF));
                    }
                }

                @Override
                public void onReleased() {
                    if (this.selectorState == 2) {
                        MasterLoader.networkInterface.sendToServer(new PacketVehiclePartEngine((PartEngine)GUIPanelGround.this.vehicle.engines.get(engineNumber), PacketVehiclePartEngine.Signal.ES_OFF));
                    }
                }
            };
            this.engineSelectors.put(engineNumber, engineSelector);
            this.addSelector(engineSelector);
        }
        if (this.haveReverseThrustOption) {
            this.reverseSelector = new GUIComponentSelector(guiLeft + xOffset + 10, guiTop + 12 + 96, 20, 20, MasterLoader.coreInterface.translate("gui.panel.reverse"), this.vehicle.definition.rendering.panelTextColor, this.vehicle.definition.rendering.panelLitTextColor, 20, 20, 120, 216, this.getTextureWidth(), this.getTextureHeight()){

                @Override
                public void onClicked(boolean leftSide) {
                    MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(GUIPanelGround.this.vehicle, PacketVehicleControlDigital.Controls.REVERSE, !GUIPanelGround.this.vehicle.reverseThrust));
                }

                @Override
                public void onReleased() {
                }
            };
            this.addSelector(this.reverseSelector);
        }
        if (this.haveReverseThrustOption && this.vehicle.definition.motorized.hasCruiseControl) {
            this.reverseSelector = new GUIComponentSelector(guiLeft + xOffset, guiTop + 12 + 96, 20, 20, MasterLoader.coreInterface.translate("gui.panel.reverse"), this.vehicle.definition.rendering.panelTextColor, this.vehicle.definition.rendering.panelLitTextColor, 20, 20, 120, 216, this.getTextureWidth(), this.getTextureHeight()){

                @Override
                public void onClicked(boolean leftSide) {
                    MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(GUIPanelGround.this.vehicle, PacketVehicleControlDigital.Controls.REVERSE, !GUIPanelGround.this.vehicle.reverseThrust));
                }

                @Override
                public void onReleased() {
                }
            };
            this.addSelector(this.reverseSelector);
            this.cruiseControlSelector = new GUIComponentSelector(guiLeft + xOffset + 20, guiTop + 12 + 96, 20, 20, MasterLoader.coreInterface.translate("gui.panel.cruisecontrol"), this.vehicle.definition.rendering.panelTextColor, this.vehicle.definition.rendering.panelLitTextColor, 20, 20, 140, 216, this.getTextureWidth(), this.getTextureHeight()){

                @Override
                public void onClicked(boolean leftSide) {
                    MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(GUIPanelGround.this.vehicle, PacketVehicleControlDigital.Controls.CRUISECONTROL, !GUIPanelGround.this.vehicle.cruiseControl));
                }

                @Override
                public void onReleased() {
                }
            };
            this.addSelector(this.cruiseControlSelector);
        } else {
            if (this.haveReverseThrustOption) {
                this.reverseSelector = new GUIComponentSelector(guiLeft + xOffset + 10, guiTop + 12 + 96, 20, 20, MasterLoader.coreInterface.translate("gui.panel.reverse"), this.vehicle.definition.rendering.panelTextColor, this.vehicle.definition.rendering.panelLitTextColor, 20, 20, 120, 216, this.getTextureWidth(), this.getTextureHeight()){

                    @Override
                    public void onClicked(boolean leftSide) {
                        MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(GUIPanelGround.this.vehicle, PacketVehicleControlDigital.Controls.REVERSE, !GUIPanelGround.this.vehicle.reverseThrust));
                    }

                    @Override
                    public void onReleased() {
                    }
                };
                this.addSelector(this.reverseSelector);
            }
            if (this.vehicle.definition.motorized.hasCruiseControl) {
                this.cruiseControlSelector = new GUIComponentSelector(guiLeft + xOffset + 10, guiTop + 12 + 96, 20, 20, MasterLoader.coreInterface.translate("gui.panel.cruisecontrol"), this.vehicle.definition.rendering.panelTextColor, this.vehicle.definition.rendering.panelLitTextColor, 20, 20, 140, 216, this.getTextureWidth(), this.getTextureHeight()){

                    @Override
                    public void onClicked(boolean leftSide) {
                        MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(GUIPanelGround.this.vehicle, PacketVehicleControlDigital.Controls.CRUISECONTROL, !GUIPanelGround.this.vehicle.cruiseControl));
                    }

                    @Override
                    public void onReleased() {
                    }
                };
                this.addSelector(this.cruiseControlSelector);
            }
        }
        if (this.vehicle.definition.motorized.gearSequenceDuration != 0) {
            this.gearSelector = new GUIComponentSelector(guiLeft + xOffset + 12 + 40, guiTop + 12 + 96, 20, 20, MasterLoader.coreInterface.translate("gui.panel.gear"), this.vehicle.definition.rendering.panelTextColor, this.vehicle.definition.rendering.panelLitTextColor, 20, 20, 160, 176, this.getTextureWidth(), this.getTextureHeight()){

                @Override
                public void onClicked(boolean leftSide) {
                    MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(GUIPanelGround.this.vehicle, PacketVehicleControlDigital.Controls.GEAR, !GUIPanelGround.this.vehicle.gearUpCommand));
                }

                @Override
                public void onReleased() {
                }
            };
            this.addSelector(this.gearSelector);
        }
        for (i = 0; i < 8; ++i) {
            if (i % 4 == 0) {
                xOffset = (int)((double)xOffset + 35.0);
            }
            GUIComponentSelector trailerSelector = new GUIComponentSelector(guiLeft + xOffset, guiTop + 12 + i % 4 * 32, 20, 20, MasterLoader.coreInterface.translate("gui.panel.trailer") + "#" + i, this.vehicle.definition.rendering.panelTextColor, this.vehicle.definition.rendering.panelLitTextColor, 20, 20, 100, 216, this.getTextureWidth(), this.getTextureHeight()){

                @Override
                public void onClicked(boolean leftSide) {
                    int trailerNumber = GUIPanelGround.this.trailerSelectors.indexOf(this);
                    EntityVehicleF_Physics currentVehicle = GUIPanelGround.this.vehicle;
                    for (int i = 0; i < trailerNumber; ++i) {
                        currentVehicle = currentVehicle.towedVehicle;
                    }
                    MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(currentVehicle, PacketVehicleControlDigital.Controls.TRAILER, true));
                }

                @Override
                public void onReleased() {
                }
            };
            this.trailerSelectors.add(trailerSelector);
            this.addSelector(trailerSelector);
        }
        if (this.vehicle.definition.rendering.customVariables != null && this.vehicle.definition.rendering.customVariables.size() > 0) {
            xOffset += 32;
            for (i = 0; i < this.vehicle.definition.rendering.customVariables.size(); ++i) {
                GUIComponentSelector customSelector = new GUIComponentSelector(guiLeft + xOffset, guiTop + 12 + i % 4 * 32, 20, 20, this.vehicle.definition.rendering.customVariables.get(i), this.vehicle.definition.rendering.panelTextColor, this.vehicle.definition.rendering.panelLitTextColor, 20, 20, 180, 216, this.getTextureWidth(), this.getTextureHeight()){

                    @Override
                    public void onClicked(boolean leftSide) {
                        byte selectorNumber = (byte)GUIPanelGround.this.customSelectors.indexOf(this);
                        switch (selectorNumber) {
                            case 0: {
                                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(GUIPanelGround.this.vehicle, PacketVehicleControlDigital.Controls.CUSTOM_0, !GUIPanelGround.this.vehicle.customsOn.contains(selectorNumber)));
                                break;
                            }
                            case 1: {
                                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(GUIPanelGround.this.vehicle, PacketVehicleControlDigital.Controls.CUSTOM_1, !GUIPanelGround.this.vehicle.customsOn.contains(selectorNumber)));
                                break;
                            }
                            case 2: {
                                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(GUIPanelGround.this.vehicle, PacketVehicleControlDigital.Controls.CUSTOM_2, !GUIPanelGround.this.vehicle.customsOn.contains(selectorNumber)));
                                break;
                            }
                            case 3: {
                                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(GUIPanelGround.this.vehicle, PacketVehicleControlDigital.Controls.CUSTOM_3, !GUIPanelGround.this.vehicle.customsOn.contains(selectorNumber)));
                            }
                        }
                    }

                    @Override
                    public void onReleased() {
                    }
                };
                this.customSelectors.add(customSelector);
                this.addSelector(customSelector);
            }
        }
        return xOffset + 12 + 20;
    }

    @Override
    public void setStates() {
        byte i;
        if (this.lightSelector != null) {
            int n = this.vehicle.lightsOn.contains((Object)LightType.HEADLIGHT) ? 2 : (this.lightSelector.selectorState = this.vehicle.lightsOn.contains((Object)LightType.RUNNINGLIGHT) ? 1 : 0);
        }
        if (this.turnSignalSelector != null) {
            boolean halfSecondClock = GUIPanelGround.inClockPeriod(20, 10);
            this.turnSignalSelector.selectorState = this.vehicle.lightsOn.contains((Object)LightType.LEFTTURNLIGHT) && halfSecondClock ? (this.vehicle.lightsOn.contains((Object)LightType.RIGHTTURNLIGHT) ? 3 : 1) : (this.vehicle.lightsOn.contains((Object)LightType.RIGHTTURNLIGHT) && halfSecondClock ? 2 : 0);
        }
        if (this.emergencySelector != null) {
            int n = this.emergencySelector.selectorState = this.vehicle.lightsOn.contains((Object)LightType.EMERGENCYLIGHT) ? 1 : 0;
        }
        if (this.sirenSelector != null) {
            this.sirenSelector.selectorState = this.vehicle.sirenOn ? 1 : 0;
        }
        for (Map.Entry<Byte, GUIComponentSelector> engineEntry : this.engineSelectors.entrySet()) {
            if (!this.vehicle.engines.containsKey(engineEntry.getKey())) continue;
            PartEngine.EngineStates engineState = ((PartEngine)this.vehicle.engines.get((Object)engineEntry.getKey())).state;
            engineEntry.getValue().selectorState = !engineState.magnetoOn ? 0 : (!engineState.esOn ? 1 : 2);
        }
        if (this.reverseSelector != null) {
            int n = this.reverseSelector.selectorState = this.vehicle.reverseThrust ? 1 : 0;
        }
        if (this.cruiseControlSelector != null) {
            int n = this.cruiseControlSelector.selectorState = this.vehicle.cruiseControl ? 1 : 0;
        }
        if (this.gearSelector != null) {
            this.gearSelector.selectorState = this.vehicle.gearUpCommand ? (this.vehicle.gearMovementTime == this.vehicle.definition.motorized.gearSequenceDuration ? 2 : 3) : (this.vehicle.gearMovementTime == 0 ? 0 : 1);
        }
        EntityVehicleF_Physics currentVehicle = this.vehicle;
        for (i = 0; i < this.trailerSelectors.size(); ++i) {
            if (currentVehicle != null && currentVehicle.definition.motorized.hitchPos != null) {
                this.trailerSelectors.get((int)i).visible = true;
                this.trailerSelectors.get((int)i).selectorState = currentVehicle.towedVehicle != null ? 0 : 1;
                currentVehicle = currentVehicle.towedVehicle;
                continue;
            }
            this.trailerSelectors.get((int)i).visible = false;
        }
        for (i = 0; i < this.customSelectors.size(); i = (byte)(i + 1)) {
            this.customSelectors.get((int)i).selectorState = this.vehicle.customsOn.contains(i) ? 1 : 0;
        }
    }
}

