/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityDecor;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentItem;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.guis.components.GUIComponentOBJModel;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.items.instances.ItemVehicle;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.AJSONModelProvider;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPoleComponent;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.instances.PacketPlayerCraftItem;
import minecrafttransportsimulator.systems.PackParserSystem;

public class GUIPartBench
extends AGUIBase {
    private static final Map<TileEntityDecor, AItemPack<? extends AJSONItem<?>>> lastOpenedItem = new HashMap();
    private final TileEntityDecor decor;
    private final IWrapperPlayer player;
    private GUIComponentButton prevPackButton;
    private GUIComponentButton nextPackButton;
    private GUIComponentLabel packName;
    private GUIComponentButton prevPartButton;
    private GUIComponentButton nextPartButton;
    private GUIComponentLabel partName;
    private GUIComponentButton prevColorButton;
    private GUIComponentButton nextColorButton;
    private GUIComponentLabel partInfo;
    private GUIComponentLabel vehicleInfo;
    private GUIComponentButton switchInfoButton;
    private GUIComponentButton confirmButton;
    private final List<GUIComponentItem> craftingItemIcons = new ArrayList<GUIComponentItem>();
    private GUIComponentItem itemRender;
    private GUIComponentOBJModel modelRender;
    private String prevPack;
    private String currentPack;
    private String nextPack;
    private AItemPack<? extends AJSONItem<?>> prevItem;
    private AItemPack<? extends AJSONItem<?>> currentItem;
    private AItemPack<? extends AJSONItem<?>> nextItem;
    private AItemPack<? extends AJSONItem<?>> prevSubItem;
    private AItemPack<? extends AJSONItem<?>> nextSubItem;
    boolean displayVehicleInfo = false;

    public GUIPartBench(TileEntityDecor decor, IWrapperPlayer player) {
        this.decor = decor;
        this.player = player;
        if (lastOpenedItem.containsKey(decor)) {
            this.currentItem = lastOpenedItem.get(decor);
            this.currentPack = ((AJSONItem)this.currentItem.definition).packID;
        } else {
            for (AItemPack<?> packItem : PackParserSystem.getAllPackItems()) {
                if (!this.isItemValid(packItem)) continue;
                this.currentItem = packItem;
                this.currentPack = ((AJSONItem)packItem.definition).packID;
                return;
            }
        }
    }

    @Override
    public void setupComponents(int guiLeft, int guiTop) {
        this.prevPackButton = new GUIComponentButton(guiLeft + 17, guiTop + 11, 20, "<", 20, true, 20, 20, 0, 196, this.getTextureWidth(), this.getTextureHeight()){

            @Override
            public void onClicked() {
                GUIPartBench.this.currentPack = GUIPartBench.this.prevPack;
                GUIPartBench.this.currentItem = null;
                GUIPartBench.this.updateNames();
            }
        };
        this.addButton(this.prevPackButton);
        this.nextPackButton = new GUIComponentButton(guiLeft + 243, guiTop + 11, 20, ">", 20, true, 20, 20, 0, 196, this.getTextureWidth(), this.getTextureHeight()){

            @Override
            public void onClicked() {
                GUIPartBench.this.currentPack = GUIPartBench.this.nextPack;
                GUIPartBench.this.currentItem = null;
                GUIPartBench.this.updateNames();
            }
        };
        this.addButton(this.nextPackButton);
        int centerBetweenButtons = this.prevPackButton.x + this.prevPackButton.width + (this.nextPackButton.x - (this.prevPackButton.x + this.prevPackButton.width)) / 2;
        this.packName = new GUIComponentLabel(centerBetweenButtons, guiTop + 16, Color.WHITE, "", AGUIBase.TextPosition.CENTERED, 0, 1.0f, false);
        this.addLabel(this.packName);
        this.prevPartButton = new GUIComponentButton(this.prevPackButton.x, this.prevPackButton.y + this.prevPackButton.height, 20, "<", 20, true, 20, 20, 0, 196, this.getTextureWidth(), this.getTextureHeight()){

            @Override
            public void onClicked() {
                GUIPartBench.this.currentItem = GUIPartBench.this.prevItem;
                GUIPartBench.this.updateNames();
            }
        };
        this.addButton(this.prevPartButton);
        this.nextPartButton = new GUIComponentButton(this.nextPackButton.x, this.nextPackButton.y + this.nextPackButton.height, 20, ">", 20, true, 20, 20, 0, 196, this.getTextureWidth(), this.getTextureHeight()){

            @Override
            public void onClicked() {
                GUIPartBench.this.currentItem = GUIPartBench.this.nextItem;
                GUIPartBench.this.updateNames();
            }
        };
        this.addButton(this.nextPartButton);
        this.partName = new GUIComponentLabel(this.packName.x, this.packName.y + this.prevPackButton.height, Color.WHITE, "", AGUIBase.TextPosition.CENTERED, 0, 0.75f, false);
        this.addLabel(this.partName);
        this.partInfo = new GUIComponentLabel(guiLeft + 17, guiTop + 58, Color.WHITE, "", AGUIBase.TextPosition.LEFT_ALIGNED, 200, 0.75f, false);
        this.addLabel(this.partInfo);
        this.vehicleInfo = new GUIComponentLabel(guiLeft + 17, guiTop + 58, Color.WHITE, "", AGUIBase.TextPosition.LEFT_ALIGNED, 150, 1.0f, false);
        this.addLabel(this.vehicleInfo);
        this.prevColorButton = new GUIComponentButton(guiLeft + 175, guiTop + 131, 20, "<", 15, true, 20, 20, 0, 196, this.getTextureWidth(), this.getTextureHeight()){

            @Override
            public void onClicked() {
                GUIPartBench.this.currentItem = GUIPartBench.this.prevSubItem;
                GUIPartBench.this.updateNames();
            }
        };
        this.addButton(this.prevColorButton);
        this.nextColorButton = new GUIComponentButton(guiLeft + 245, guiTop + 131, 20, ">", 15, true, 20, 20, 0, 196, this.getTextureWidth(), this.getTextureHeight()){

            @Override
            public void onClicked() {
                GUIPartBench.this.currentItem = GUIPartBench.this.nextSubItem;
                GUIPartBench.this.updateNames();
            }
        };
        this.addButton(this.nextColorButton);
        this.addLabel(new GUIComponentLabel(this.prevColorButton.x + this.prevColorButton.width + (this.nextColorButton.x - (this.prevColorButton.x + this.prevColorButton.width)) / 2, guiTop + 136, Color.WHITE, MasterLoader.coreInterface.translate("gui.vehicle_bench.color"), AGUIBase.TextPosition.CENTERED, 0, 1.0f, false).setButton(this.nextColorButton));
        this.craftingItemIcons.clear();
        int craftingIconSize = 18;
        for (int i = 0; i < 14; i = (int)((byte)(i + 1))) {
            GUIComponentItem craftingItem = new GUIComponentItem(guiLeft + 276 + 18 * (i / 7), guiTop + 20 + 18 * (i % 7), 1.125f, null);
            this.addItem(craftingItem);
            this.craftingItemIcons.add(craftingItem);
        }
        this.itemRender = new GUIComponentItem(guiLeft + 175, guiTop + 56, 5.625f, null);
        this.addItem(this.itemRender);
        this.modelRender = new GUIComponentOBJModel(guiLeft + 220, guiTop + 101, 32.0f, true, true, false);
        this.addOBJModel(this.modelRender);
        this.switchInfoButton = new GUIComponentButton(guiLeft + 147, guiTop + 159, 20, "?", 20, true, 20, 20, 0, 196, this.getTextureWidth(), this.getTextureHeight()){

            @Override
            public void onClicked() {
                GUIPartBench.this.displayVehicleInfo = !GUIPartBench.this.displayVehicleInfo;
            }
        };
        this.addButton(this.switchInfoButton);
        this.confirmButton = new GUIComponentButton(guiLeft + 211, guiTop + 156, 20, "", 20, true, 20, 20, 20, 196, this.getTextureWidth(), this.getTextureHeight()){

            @Override
            public void onClicked() {
                MasterLoader.networkInterface.sendToServer(new PacketPlayerCraftItem(GUIPartBench.this.currentItem));
            }
        };
        this.addButton(this.confirmButton);
        this.updateNames();
    }

    @Override
    public void setStates() {
        this.prevPackButton.enabled = this.prevPack != null;
        this.nextPackButton.enabled = this.nextPack != null;
        this.prevPartButton.enabled = this.prevItem != null;
        this.nextPartButton.enabled = this.nextItem != null;
        this.prevColorButton.visible = this.currentItem instanceof AItemSubTyped;
        this.prevColorButton.enabled = this.prevSubItem != null;
        this.nextColorButton.visible = this.currentItem instanceof AItemSubTyped;
        this.nextColorButton.enabled = this.nextSubItem != null;
        this.switchInfoButton.visible = this.currentItem instanceof ItemVehicle;
        this.partInfo.visible = !this.displayVehicleInfo;
        this.vehicleInfo.visible = this.displayVehicleInfo;
        this.confirmButton.enabled = this.currentItem != null && (this.player.isCreative() || this.player.getInventory().hasMaterials(this.currentItem, true, true));
        int wheelMovement = MasterLoader.inputInterface.getTrackedMouseWheel();
        if (wheelMovement > 0 && this.nextPartButton.enabled) {
            this.nextPartButton.onClicked();
        } else if (wheelMovement < 0 && this.prevPartButton.enabled) {
            this.prevPartButton.onClicked();
        }
    }

    @Override
    public int getWidth() {
        return 327;
    }

    @Override
    public int getHeight() {
        return 196;
    }

    @Override
    public String getTexture() {
        return "mts:textures/guis/crafting.png";
    }

    private void updateNames() {
        int i;
        ArrayList<String> packIDs = new ArrayList<String>(PackParserSystem.getAllPackIDs());
        int currentPackIndex = packIDs.indexOf(this.currentPack);
        this.nextPack = null;
        if (currentPackIndex < packIDs.size()) {
            block0: for (i = currentPackIndex + 1; i < packIDs.size() && this.nextPack == null; ++i) {
                for (AItemPack<?> packItem : PackParserSystem.getAllItemsForPack((String)packIDs.get(i))) {
                    if (!this.isItemValid(packItem)) continue;
                    this.nextPack = (String)packIDs.get(i);
                    continue block0;
                }
            }
        }
        this.prevPack = null;
        if (currentPackIndex > 0) {
            block2: for (i = currentPackIndex - 1; i >= 0 && this.prevPack == null; --i) {
                for (AItemPack<?> packItem : PackParserSystem.getAllItemsForPack((String)packIDs.get(i))) {
                    if (!this.isItemValid(packItem)) continue;
                    this.prevPack = (String)packIDs.get(i);
                    continue block2;
                }
            }
        }
        if (this.currentPack == null) {
            return;
        }
        List<AItemPack<?>> packItems = PackParserSystem.getAllItemsForPack(this.currentPack);
        int currentItemIndex = packItems.indexOf(this.currentItem);
        if (this.currentItem == null) {
            for (AItemPack aItemPack : PackParserSystem.getAllItemsForPack(this.currentPack)) {
                if (this.currentItem != null && (!(this.currentItem.definition instanceof AJSONMultiModelProvider) || this.nextSubItem != null) || !this.isItemValid(aItemPack)) continue;
                if (this.currentItem == null) {
                    this.currentItem = aItemPack;
                    currentItemIndex = packItems.indexOf(this.currentItem);
                    continue;
                }
                if (!(this.currentItem.definition instanceof AJSONMultiModelProvider) || this.nextSubItem != null || !((AJSONItem)aItemPack.definition).systemName.equals(((AJSONItem)this.currentItem.definition).systemName)) continue;
                this.nextSubItem = aItemPack;
            }
        }
        this.nextItem = null;
        this.nextSubItem = null;
        if (currentItemIndex < packItems.size()) {
            for (int i2 = currentItemIndex + 1; i2 < packItems.size() && this.nextItem == null; ++i2) {
                if (!this.isItemValid(packItems.get(i2))) continue;
                if (this.currentItem.definition instanceof AJSONMultiModelProvider && ((AJSONItem)packItems.get((int)i2).definition).systemName.equals(((AJSONItem)this.currentItem.definition).systemName)) {
                    if (this.nextSubItem != null) continue;
                    this.nextSubItem = packItems.get(i2);
                    continue;
                }
                this.nextItem = packItems.get(i2);
                break;
            }
        }
        this.prevItem = null;
        this.prevSubItem = null;
        if (currentItemIndex > 0) {
            for (int i3 = currentItemIndex - 1; i3 >= 0 && (this.prevItem == null || this.currentItem.definition instanceof AJSONMultiModelProvider); --i3) {
                if (!this.isItemValid(packItems.get(i3))) continue;
                if (this.currentItem.definition instanceof AJSONMultiModelProvider) {
                    if (((AJSONItem)packItems.get((int)i3).definition).systemName.equals(((AJSONItem)this.currentItem.definition).systemName)) {
                        if (this.prevSubItem != null) continue;
                        this.prevSubItem = packItems.get(i3);
                        continue;
                    }
                    if (this.prevItem == null) {
                        this.prevItem = packItems.get(i3);
                        continue;
                    }
                    if (!((AJSONItem)packItems.get((int)i3).definition).systemName.equals(((AJSONItem)this.prevItem.definition).systemName)) continue;
                    this.prevItem = packItems.get(i3);
                    continue;
                }
                this.prevItem = packItems.get(i3);
                break;
            }
        }
        this.packName.text = MasterLoader.coreInterface.getModName(this.currentPack);
        this.partName.text = this.currentItem.getItemName();
        ArrayList<String> descriptiveLines = new ArrayList<String>();
        this.currentItem.addTooltipLines(descriptiveLines, MasterLoader.coreInterface.createNewTag());
        this.partInfo.text = "";
        for (String line : descriptiveLines) {
            this.partInfo.text = this.partInfo.text + line + "\n";
        }
        if (this.currentItem instanceof ItemVehicle) {
            this.vehicleInfo.text = this.getVehicleInfoText();
        }
        List<IWrapperItemStack> list = MasterLoader.coreInterface.parseFromJSON(this.currentItem, true, true);
        for (int i4 = 0; i4 < this.craftingItemIcons.size(); i4 = (int)((byte)(i4 + 1))) {
            this.craftingItemIcons.get((int)i4).stack = i4 < list.size() ? list.get(i4) : null;
        }
        if (this.currentItem.definition instanceof AJSONModelProvider) {
            this.modelRender.modelLocation = ((AJSONModelProvider)this.currentItem.definition).getModelLocation();
            this.modelRender.textureLocation = ((AJSONModelProvider)this.currentItem.definition).getTextureLocation();
            this.itemRender.stack = null;
            this.modelRender.spin = !(this.currentItem.definition instanceof JSONPoleComponent) || !((JSONPoleComponent.PoleGeneral)((JSONPoleComponent)this.currentItem.definition).general).type.equals("sign");
        } else if (this.currentItem instanceof AItemSubTyped) {
            this.modelRender.modelLocation = ((AJSONMultiModelProvider)((AItemSubTyped)this.currentItem).definition).getModelLocation();
            this.modelRender.textureLocation = ((AJSONMultiModelProvider)((AItemSubTyped)this.currentItem).definition).getTextureLocation(((AItemSubTyped)this.currentItem).subName);
            this.itemRender.stack = null;
        } else {
            this.itemRender.stack = MasterLoader.coreInterface.getStack(this.currentItem);
            this.modelRender.modelLocation = null;
        }
        lastOpenedItem.put(this.decor, this.currentItem);
    }

    private boolean isItemValid(AItemPack<?> item) {
        if (((JSONDecor.DecorGeneral)((JSONDecor)this.decor.definition).general).items != null) {
            return ((JSONDecor.DecorGeneral)((JSONDecor)this.decor.definition).general).items.contains(((AJSONItem)item.definition).packID + ":" + ((AJSONItem)item.definition).systemName);
        }
        if (((JSONDecor.DecorGeneral)((JSONDecor)this.decor.definition).general).itemTypes.contains(item.classification.toString().toLowerCase())) {
            if (item.definition instanceof JSONPart && ((JSONDecor.DecorGeneral)((JSONDecor)this.decor.definition).general).partTypes != null) {
                for (String partType : ((JSONDecor.DecorGeneral)((JSONDecor)this.decor.definition).general).partTypes) {
                    if (!((JSONPart.JSONPartGeneral)((JSONPart)item.definition).general).type.contains(partType)) continue;
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private String getVehicleInfoText() {
        JSONVehicle vehicleDefinition = (JSONVehicle)this.currentItem.definition;
        int controllers = 0;
        int passengers = 0;
        int cargo = 0;
        int mixed = 0;
        float minFuelConsumption = 99.0f;
        float maxFuelConsumption = 0.0f;
        float minWheelSize = 99.0f;
        float maxWheelSize = 0.0f;
        for (JSONVehicle.VehiclePart part : vehicleDefinition.parts) {
            if (part.isController) {
                ++controllers;
                continue;
            }
            boolean canAcceptSeat = false;
            boolean canAcceptCargo = false;
            if (part.types.contains("seat")) {
                canAcceptSeat = true;
            }
            if (part.types.contains("crate") || part.types.contains("barrel")) {
                canAcceptCargo = true;
            }
            if (canAcceptSeat && !canAcceptCargo) {
                ++passengers;
            } else if (canAcceptCargo && !canAcceptSeat) {
                ++cargo;
            } else if (canAcceptCargo && canAcceptSeat) {
                ++mixed;
            }
            for (String partNameEntry : part.types) {
                if (!partNameEntry.startsWith("engine")) continue;
                minFuelConsumption = Math.min(part.minValue, minFuelConsumption);
                maxFuelConsumption = Math.max(part.maxValue, maxFuelConsumption);
                break;
            }
            if (!part.types.contains("wheel")) continue;
            minWheelSize = Math.min(part.minValue, minWheelSize);
            maxWheelSize = Math.max(part.maxValue, maxWheelSize);
        }
        String totalInformation = "";
        totalInformation = totalInformation + MasterLoader.coreInterface.translate("gui.vehicle_bench.type") + ": " + String.valueOf(((JSONVehicle.VehicleGeneral)vehicleDefinition.general).type) + "\n";
        totalInformation = totalInformation + MasterLoader.coreInterface.translate("gui.vehicle_bench.weight") + ": " + String.valueOf(((JSONVehicle.VehicleGeneral)vehicleDefinition.general).emptyMass) + "\n";
        totalInformation = totalInformation + MasterLoader.coreInterface.translate("gui.vehicle_bench.fuel") + ": " + String.valueOf(vehicleDefinition.motorized.fuelCapacity) + "\n";
        totalInformation = totalInformation + MasterLoader.coreInterface.translate("gui.vehicle_bench.controllers") + ": " + String.valueOf(controllers) + "\n";
        totalInformation = totalInformation + MasterLoader.coreInterface.translate("gui.vehicle_bench.passengers") + ": " + String.valueOf(passengers) + "\n";
        totalInformation = totalInformation + MasterLoader.coreInterface.translate("gui.vehicle_bench.cargo") + ": " + String.valueOf(cargo) + "\n";
        totalInformation = totalInformation + MasterLoader.coreInterface.translate("gui.vehicle_bench.mixed") + ": " + String.valueOf(mixed) + "\n";
        if (minFuelConsumption != 99.0f) {
            totalInformation = totalInformation + MasterLoader.coreInterface.translate("gui.vehicle_bench.engine") + ": " + String.valueOf(minFuelConsumption) + "-" + String.valueOf(maxFuelConsumption) + "\n";
        }
        if (minWheelSize != 99.0f) {
            totalInformation = totalInformation + MasterLoader.coreInterface.translate("gui.vehicle_bench.wheel") + ": " + String.valueOf(minWheelSize) + "-" + String.valueOf(maxWheelSize) + "\n";
        }
        return totalInformation;
    }
}

