/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.guis.components.GUIComponentTextBox;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.sound.IRadioProvider;
import minecrafttransportsimulator.sound.Radio;
import minecrafttransportsimulator.sound.RadioManager;

public class GUIRadio
extends AGUIBase {
    private GUIComponentButton offButton;
    private GUIComponentButton localButton;
    private GUIComponentButton remoteButton;
    private GUIComponentButton serverButton;
    private GUIComponentButton setButton;
    private GUIComponentButton equalizerButton;
    private GUIComponentButton equalizerBackButton;
    private GUIComponentButton equalizerResetButton;
    private GUIComponentButton volUpButton;
    private GUIComponentButton volDnButton;
    private List<GUIComponentButton> presetButtons = new ArrayList<GUIComponentButton>();
    private List<GUIComponentButton> equalizerButtons = new ArrayList<GUIComponentButton>();
    private GUIComponentTextBox stationDisplay;
    private GUIComponentTextBox volumeDisplay;
    private final Radio radio;
    private final int bandsToSkip;
    private final int bandsToShow;
    private final int bandButtonSize;
    private static boolean equalizerMode = false;
    private static boolean teachMode = false;

    public GUIRadio(IRadioProvider provider) {
        this.radio = provider.getRadio();
        this.bandsToSkip = 4;
        this.bandsToShow = 32 / this.bandsToSkip;
        this.bandButtonSize = 20;
    }

    @Override
    public void setupComponents(int guiLeft, int guiTop) {
        this.offButton = new GUIComponentButton(guiLeft + 20, guiTop + 25, 55, "OFF", 15, true){

            @Override
            public void onClicked() {
                GUIRadio.this.radio.pressPreset(0, true);
                teachMode = false;
            }
        };
        this.addButton(this.offButton);
        this.addLabel(new GUIComponentLabel(this.offButton.x + this.offButton.width / 2, this.offButton.y - 10, Color.BLACK, "SOURCE", AGUIBase.TextPosition.CENTERED, 0, 1.0f, false).setButton(this.offButton));
        this.localButton = new GUIComponentButton(this.offButton.x, this.offButton.y + this.offButton.height, this.offButton.width, "PC", this.offButton.height, true){

            @Override
            public void onClicked() {
                GUIRadio.this.radio.changeSource(RadioManager.RadioSources.LOCAL, true);
                teachMode = false;
            }
        };
        this.addButton(this.localButton);
        this.remoteButton = new GUIComponentButton(this.offButton.x, this.localButton.y + this.localButton.height, this.offButton.width, "INTERNET", this.offButton.height, true){

            @Override
            public void onClicked() {
                GUIRadio.this.radio.changeSource(RadioManager.RadioSources.INTERNET, true);
                teachMode = false;
            }
        };
        this.addButton(this.remoteButton);
        this.serverButton = new GUIComponentButton(this.offButton.x, this.remoteButton.y + this.remoteButton.height, this.offButton.width, "SERVER", this.offButton.height, true){

            @Override
            public void onClicked() {
                GUIRadio.this.radio.changeSource(RadioManager.RadioSources.SERVER, true);
                teachMode = false;
            }
        };
        this.addButton(this.serverButton);
        this.setButton = new GUIComponentButton(this.offButton.x + this.offButton.width + 15, this.offButton.y, this.offButton.width, "SET URL", this.offButton.height, true){

            @Override
            public void onClicked() {
                if (teachMode) {
                    teachMode = false;
                    GUIRadio.this.stationDisplay.setText("");
                } else {
                    teachMode = true;
                    GUIRadio.this.stationDisplay.setText("Type or paste a URL (CTRL+V).\nThen press press a preset button.");
                    ((GUIRadio)GUIRadio.this).stationDisplay.focused = true;
                }
            }
        };
        this.addButton(this.setButton);
        this.volUpButton = new GUIComponentButton(guiLeft + 205, this.offButton.y, 30, "UP"){

            @Override
            public void onClicked() {
                GUIRadio.this.radio.changeVolume(++((GUIRadio)GUIRadio.this).radio.volume, true);
            }
        };
        this.addButton(this.volUpButton);
        this.volDnButton = new GUIComponentButton(this.volUpButton.x, this.volUpButton.y + this.volUpButton.height, this.volUpButton.width, "DN"){

            @Override
            public void onClicked() {
                GUIRadio.this.radio.changeVolume(--((GUIRadio)GUIRadio.this).radio.volume, true);
            }
        };
        this.addButton(this.volDnButton);
        this.volumeDisplay = new GUIComponentTextBox(guiLeft + 180, this.volUpButton.y, 25, "", 40, Color.WHITE, Color.BLACK, 32);
        this.addTextBox(this.volumeDisplay);
        this.equalizerButton = new GUIComponentButton(this.volumeDisplay.x, this.volumeDisplay.y + this.volumeDisplay.height, this.volumeDisplay.width + this.volDnButton.width, "EQ", this.volUpButton.height, true){

            @Override
            public void onClicked() {
                equalizerMode = true;
            }
        };
        this.addButton(this.equalizerButton);
        this.addLabel(new GUIComponentLabel(this.volumeDisplay.x + this.volumeDisplay.width, this.volumeDisplay.y - 10, Color.BLACK, "VOLUME", AGUIBase.TextPosition.CENTERED, 0, 1.0f, false).setButton(this.volUpButton));
        this.presetButtons.clear();
        int x = 25;
        for (int i = 1; i < 7; i = (int)((byte)(i + 1))) {
            this.presetButtons.add(new GUIComponentButton(guiLeft + x, guiTop + 155, 35, String.valueOf(i)){

                @Override
                public void onClicked() {
                    GUIRadio.this.presetButtonClicked(this);
                }
            });
            this.addButton(this.presetButtons.get(i - 1));
            x += 35;
        }
        this.stationDisplay = new GUIComponentTextBox(guiLeft + 20, guiTop + 105, 220, this.radio.displayText, 45, Color.WHITE, Color.BLACK, 150);
        this.addTextBox(this.stationDisplay);
        this.equalizerBackButton = new GUIComponentButton(guiLeft + 40, guiTop + 162, 80, "BACK"){

            @Override
            public void onClicked() {
                equalizerMode = false;
            }
        };
        this.addButton(this.equalizerBackButton);
        this.equalizerResetButton = new GUIComponentButton(guiLeft + this.getWidth() - 80 - 40, guiTop + 162, 80, "RESET"){

            @Override
            public void onClicked() {
                for (int i = 0; i < ((GUIRadio)GUIRadio.this).radio.currentStation.equalizer.getBandCount(); ++i) {
                    ((GUIRadio)GUIRadio.this).radio.currentStation.equalizer.setBand(i, 0.0f);
                }
            }
        };
        this.addButton(this.equalizerResetButton);
        this.equalizerButtons.clear();
        int startingOffset = (this.getWidth() - (this.bandsToShow - 1) * this.bandButtonSize) / 2;
        for (int i = 0; i < this.bandsToShow; ++i) {
            GUIComponentEqualizerButton bandUpButton = new GUIComponentEqualizerButton(guiLeft + startingOffset - this.bandButtonSize / 2 + this.bandButtonSize * i, guiTop + 20, true);
            GUIComponentEqualizerButton bandDownButton = new GUIComponentEqualizerButton(guiLeft + startingOffset - this.bandButtonSize / 2 + this.bandButtonSize * i, guiTop + 140, false);
            this.equalizerButtons.add(bandUpButton);
            this.equalizerButtons.add(bandDownButton);
            this.addButton(bandUpButton);
            this.addButton(bandDownButton);
        }
    }

    @Override
    public void setStates() {
        for (GUIComponentButton button : this.buttons) {
            button.visible = !((button.equals(this.equalizerBackButton) || this.equalizerButtons.contains(button)) ^ equalizerMode);
        }
        this.equalizerButton.visible = !equalizerMode;
        this.equalizerBackButton.visible = equalizerMode;
        this.equalizerResetButton.visible = equalizerMode;
        this.volumeDisplay.visible = !equalizerMode;
        this.stationDisplay.visible = !equalizerMode;
        this.offButton.enabled = this.radio.currentStation != null;
        this.localButton.enabled = !this.radio.getSource().equals((Object)RadioManager.RadioSources.LOCAL);
        this.remoteButton.enabled = !this.radio.getSource().equals((Object)RadioManager.RadioSources.INTERNET);
        this.serverButton.enabled = !this.radio.getSource().equals((Object)RadioManager.RadioSources.SERVER);
        this.equalizerButton.enabled = !this.radio.getSource().equals((Object)RadioManager.RadioSources.INTERNET) && this.radio.currentStation != null && this.radio.currentStation.equalizer != null;
        this.setButton.enabled = this.radio.getSource().equals((Object)RadioManager.RadioSources.INTERNET);
        this.stationDisplay.enabled = teachMode;
        if (!teachMode) {
            if (this.radio.currentStation == null) {
                this.stationDisplay.setText(this.radio.displayText);
            } else {
                this.stationDisplay.setText(this.radio.currentStation.displayText);
            }
        }
        this.volumeDisplay.enabled = false;
        this.volumeDisplay.setText("VOL        " + String.valueOf(this.radio.volume));
        this.volUpButton.enabled = this.radio.volume < 10;
        this.volDnButton.enabled = this.radio.volume > 1;
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            this.presetButtons.get((int)i).enabled = this.radio.preset - 1 != i;
        }
    }

    private void presetButtonClicked(GUIComponentButton buttonClicked) {
        int presetClicked = this.presetButtons.indexOf(buttonClicked);
        if (teachMode) {
            RadioManager.setLocalStationURL(this.stationDisplay.getText(), presetClicked);
            this.stationDisplay.setText("Station set to preset " + (presetClicked + 1));
            teachMode = false;
        } else {
            this.radio.pressPreset(presetClicked + 1, true);
        }
    }

    private class GUIComponentEqualizerButton
    extends GUIComponentButton {
        private final boolean increment;

        public GUIComponentEqualizerButton(int x, int y, boolean increment) {
            super(x, y, GUIRadio.this.bandButtonSize, increment ? "/\\" : "\\/", GUIRadio.this.bandButtonSize, true);
            this.increment = increment;
        }

        @Override
        public void onClicked() {
            int bandIndex = GUIRadio.this.bandsToSkip * (GUIRadio.this.equalizerButtons.indexOf(this) / 2);
            float level = ((GUIRadio)GUIRadio.this).radio.currentStation.equalizer.getBand(bandIndex);
            if (this.increment ? level < 0.9f : level > -0.9f) {
                int i;
                ((GUIRadio)GUIRadio.this).radio.currentStation.equalizer.setBand(bandIndex, level += this.increment ? 0.2f : -0.2f);
                if (bandIndex + GUIRadio.this.bandsToSkip < ((GUIRadio)GUIRadio.this).radio.currentStation.equalizer.getBandCount()) {
                    int nextBandIndex = bandIndex + GUIRadio.this.bandsToSkip;
                    float nextBandLevel = ((GUIRadio)GUIRadio.this).radio.currentStation.equalizer.getBand(nextBandIndex);
                    for (i = 1; i < GUIRadio.this.bandsToSkip; ++i) {
                        ((GUIRadio)GUIRadio.this).radio.currentStation.equalizer.setBand(bandIndex + i, level + (float)i * (nextBandLevel - level) / (float)GUIRadio.this.bandsToSkip);
                    }
                }
                if (bandIndex - GUIRadio.this.bandsToSkip >= 0) {
                    int priorBandIndex = bandIndex - GUIRadio.this.bandsToSkip;
                    float priorBandLevel = ((GUIRadio)GUIRadio.this).radio.currentStation.equalizer.getBand(priorBandIndex);
                    for (i = 1; i < GUIRadio.this.bandsToSkip; ++i) {
                        ((GUIRadio)GUIRadio.this).radio.currentStation.equalizer.setBand(bandIndex - i, level - (float)i * (level - priorBandLevel) / (float)GUIRadio.this.bandsToSkip);
                    }
                }
            }
        }

        @Override
        public void renderText() {
            super.renderText();
            if (this.visible && this.increment) {
                int upperBounds = this.y + GUIRadio.this.bandButtonSize;
                int lowerBounds = ((GUIComponentButton)((GUIRadio)GUIRadio.this).equalizerButtons.get((int)(((GUIRadio)GUIRadio.this).equalizerButtons.indexOf((Object)this) + 1))).y;
                int middlePoint = this.x + this.width / 2;
                MasterLoader.guiInterface.renderRectangle(middlePoint - 2, lowerBounds, 4, upperBounds - lowerBounds, Color.BLACK);
                int squareSize = 8;
                float level = (1.0f + ((GUIRadio)GUIRadio.this).radio.currentStation.equalizer.getBand(GUIRadio.this.bandsToSkip * (GUIRadio.this.equalizerButtons.indexOf(this) / 2))) / 2.0f;
                int bandCenter = lowerBounds - squareSize + (int)(level * (float)(upperBounds + squareSize / 2 - (lowerBounds - squareSize / 2)));
                MasterLoader.guiInterface.renderRectangle(middlePoint - squareSize / 2, bandCenter, squareSize, squareSize, Color.RED);
            }
        }
    }
}

