/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import minecrafttransportsimulator.baseclasses.Point3i;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityPole_Component;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole_StreetLight;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole_TrafficSignal;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntitySignalController;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentItem;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.guis.components.GUIComponentTextBox;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.instances.PacketTileEntitySignalControllerChange;

public class GUISignalController
extends AGUIBase {
    private GUIComponentButton orientationButton;
    private GUIComponentButton modeButton;
    private GUIComponentButton confirmButton;
    private GUIComponentTextBox scanDistanceText;
    private GUIComponentTextBox greenMainTimeText;
    private GUIComponentTextBox greenCrossTimeText;
    private GUIComponentTextBox yellowMainTimeText;
    private GUIComponentTextBox yellowCrossTimeText;
    private GUIComponentTextBox allRedTimeText;
    private byte trafficSignals;
    private byte streetLights;
    private GUIComponentLabel trafficSignalCount;
    private GUIComponentLabel streetLightCount;
    private GUIComponentItem trafficSignalItem;
    private GUIComponentItem streetLightItem;
    private IWrapperItemStack trafficSignalItemTemp;
    private IWrapperItemStack streetLightItemTemp;
    private final Set<Point3i> componentLocations = new HashSet<Point3i>();
    private final TileEntitySignalController controller;

    public GUISignalController(TileEntitySignalController controller) {
        this.controller = controller;
        for (Point3i location : controller.componentLocations) {
            Object tile = controller.world.getTileEntity(location);
            if (!(tile instanceof TileEntityPole)) continue;
            for (ATileEntityPole_Component component : ((TileEntityPole)tile).components.values()) {
                if (component instanceof TileEntityPole_TrafficSignal) {
                    this.trafficSignalItemTemp = MasterLoader.coreInterface.getStack(component.item);
                    this.trafficSignals = (byte)(this.trafficSignals + 1);
                    this.componentLocations.add(location);
                    continue;
                }
                if (!(component instanceof TileEntityPole_StreetLight)) continue;
                this.streetLightItemTemp = MasterLoader.coreInterface.getStack(component.item);
                this.streetLights = (byte)(this.streetLights + 1);
                this.componentLocations.add(location);
            }
        }
    }

    @Override
    public void setupComponents(int guiLeft, int guiTop) {
        this.addButton(new GUIComponentButton(guiLeft + 25, guiTop + 15, 200, MasterLoader.coreInterface.translate("gui.trafficsignalcontroller.scan")){

            @Override
            public void onClicked() {
                GUISignalController.this.trafficSignals = (byte)0;
                GUISignalController.this.streetLights = (byte)0;
                GUISignalController.this.componentLocations.clear();
                int scanDistance = Integer.valueOf(GUISignalController.this.scanDistanceText.getText());
                for (int i = ((GUISignalController)GUISignalController.this).controller.position.x - scanDistance; i <= ((GUISignalController)GUISignalController.this).controller.position.x + scanDistance; ++i) {
                    for (int j = ((GUISignalController)GUISignalController.this).controller.position.y - scanDistance; j <= ((GUISignalController)GUISignalController.this).controller.position.y + scanDistance; ++j) {
                        for (int k = ((GUISignalController)GUISignalController.this).controller.position.z - scanDistance; k <= ((GUISignalController)GUISignalController.this).controller.position.z + scanDistance; ++k) {
                            Point3i location = new Point3i(i, j, k);
                            Object tile = ((GUISignalController)GUISignalController.this).controller.world.getTileEntity(location);
                            if (!(tile instanceof TileEntityPole)) continue;
                            for (ATileEntityPole_Component component : ((TileEntityPole)tile).components.values()) {
                                if (component instanceof TileEntityPole_TrafficSignal) {
                                    ((GUISignalController)GUISignalController.this).trafficSignalItem.stack = MasterLoader.coreInterface.getStack(component.item);
                                    GUISignalController.this.trafficSignals = (byte)(GUISignalController.this.trafficSignals + 1);
                                    GUISignalController.this.componentLocations.add(location);
                                    continue;
                                }
                                if (!(component instanceof TileEntityPole_StreetLight)) continue;
                                ((GUISignalController)GUISignalController.this).streetLightItem.stack = MasterLoader.coreInterface.getStack(component.item);
                                GUISignalController.this.streetLights = (byte)(GUISignalController.this.streetLights + 1);
                                GUISignalController.this.componentLocations.add(location);
                            }
                        }
                    }
                }
            }
        });
        this.scanDistanceText = new GUIComponentTextBox(guiLeft + 120, guiTop + 40, 40, "25", 10, Color.WHITE, Color.BLACK, 2);
        this.addTextBox(this.scanDistanceText);
        this.addLabel(new GUIComponentLabel(guiLeft + 30, this.scanDistanceText.y, Color.WHITE, MasterLoader.coreInterface.translate("gui.trafficsignalcontroller.scandistance")).setBox(this.scanDistanceText));
        this.addLabel(new GUIComponentLabel(guiLeft + 30, guiTop + 55, Color.WHITE, MasterLoader.coreInterface.translate("gui.trafficsignalcontroller.scanfound")));
        this.trafficSignalItem = new GUIComponentItem(guiLeft + 120, guiTop + 52, 1.0f, this.trafficSignalItemTemp);
        this.addItem(this.trafficSignalItem);
        this.trafficSignalCount = new GUIComponentLabel(guiLeft + 135, guiTop + 56, Color.WHITE, " X" + this.trafficSignals);
        this.addLabel(this.trafficSignalCount);
        this.streetLightItem = new GUIComponentItem(guiLeft + 200, guiTop + 52, 1.0f, this.streetLightItemTemp);
        this.addItem(this.streetLightItem);
        this.streetLightCount = new GUIComponentLabel(guiLeft + 215, guiTop + 56, Color.WHITE, " X" + this.streetLights);
        this.addLabel(this.streetLightCount);
        this.orientationButton = new GUIComponentButton(guiLeft + 125, guiTop + 70, 100, this.controller.mainDirectionXAxis ? "X" : "Z", 15, true){

            @Override
            public void onClicked() {
                if (((GUISignalController)GUISignalController.this).controller.mainDirectionXAxis) {
                    ((GUISignalController)GUISignalController.this).controller.mainDirectionXAxis = false;
                    this.text = "Z";
                } else {
                    ((GUISignalController)GUISignalController.this).controller.mainDirectionXAxis = true;
                    this.text = "X";
                }
            }
        };
        this.addButton(this.orientationButton);
        this.addLabel(new GUIComponentLabel(guiLeft + 30, this.orientationButton.y + 5, Color.WHITE, MasterLoader.coreInterface.translate("gui.trafficsignalcontroller.primary")).setButton(this.orientationButton));
        String modeLabel = "";
        switch (this.controller.currentOpMode) {
            case TIMED_CYCLE: {
                modeLabel = MasterLoader.coreInterface.translate("gui.trafficsignalcontroller.modetime");
                break;
            }
            case VEHICLE_TRIGGER: {
                modeLabel = MasterLoader.coreInterface.translate("gui.trafficsignalcontroller.modetrigger");
                break;
            }
            case REDSTONE_TRIGGER: {
                modeLabel = MasterLoader.coreInterface.translate("gui.trafficsignalcontroller.moderedstone");
                break;
            }
            case REMOTE_CONTROL: {
                modeLabel = MasterLoader.coreInterface.translate("gui.trafficsignalcontroller.moderemote");
            }
        }
        this.modeButton = new GUIComponentButton(guiLeft + 125, guiTop + 85, 100, modeLabel, 15, true){

            @Override
            public void onClicked() {
                switch (((GUISignalController)GUISignalController.this).controller.currentOpMode) {
                    case TIMED_CYCLE: {
                        ((GUISignalController)GUISignalController.this).controller.currentOpMode = TileEntitySignalController.OpMode.VEHICLE_TRIGGER;
                        this.text = MasterLoader.coreInterface.translate("gui.trafficsignalcontroller.modetrigger");
                        break;
                    }
                    case VEHICLE_TRIGGER: {
                        ((GUISignalController)GUISignalController.this).controller.currentOpMode = TileEntitySignalController.OpMode.REDSTONE_TRIGGER;
                        this.text = MasterLoader.coreInterface.translate("gui.trafficsignalcontroller.moderedstone");
                        break;
                    }
                    case REDSTONE_TRIGGER: {
                        ((GUISignalController)GUISignalController.this).controller.currentOpMode = TileEntitySignalController.OpMode.REMOTE_CONTROL;
                        this.text = MasterLoader.coreInterface.translate("gui.trafficsignalcontroller.moderemote");
                        break;
                    }
                    case REMOTE_CONTROL: {
                        ((GUISignalController)GUISignalController.this).controller.currentOpMode = TileEntitySignalController.OpMode.TIMED_CYCLE;
                        this.text = MasterLoader.coreInterface.translate("gui.trafficsignalcontroller.modetime");
                    }
                }
            }
        };
        this.addButton(this.modeButton);
        this.addLabel(new GUIComponentLabel(guiLeft + 30, this.modeButton.y + 5, Color.WHITE, MasterLoader.coreInterface.translate("gui.trafficsignalcontroller.signalmode")).setButton(this.modeButton));
        this.greenMainTimeText = new GUIComponentTextBox(guiLeft + 180, guiTop + 105, 40, String.valueOf(this.controller.greenMainTime), 10, Color.WHITE, Color.BLACK, 3);
        this.addTextBox(this.greenMainTimeText);
        this.addLabel(new GUIComponentLabel(guiLeft + 30, this.greenMainTimeText.y, Color.WHITE, MasterLoader.coreInterface.translate("gui.trafficsignalcontroller.greenmaintime")).setBox(this.greenMainTimeText));
        this.greenCrossTimeText = new GUIComponentTextBox(guiLeft + 180, guiTop + 115, 40, String.valueOf(this.controller.greenCrossTime), 10, Color.WHITE, Color.BLACK, 3);
        this.addTextBox(this.greenCrossTimeText);
        this.addLabel(new GUIComponentLabel(guiLeft + 30, this.greenCrossTimeText.y, Color.WHITE, MasterLoader.coreInterface.translate("gui.trafficsignalcontroller.greencrosstime")).setBox(this.greenCrossTimeText));
        this.yellowMainTimeText = new GUIComponentTextBox(guiLeft + 180, guiTop + 125, 40, String.valueOf(this.controller.yellowMainTime), 10, Color.WHITE, Color.BLACK, 1);
        this.addTextBox(this.yellowMainTimeText);
        this.addLabel(new GUIComponentLabel(guiLeft + 30, this.yellowMainTimeText.y, Color.WHITE, MasterLoader.coreInterface.translate("gui.trafficsignalcontroller.yellowmaintime")).setBox(this.yellowMainTimeText));
        this.yellowCrossTimeText = new GUIComponentTextBox(guiLeft + 180, guiTop + 135, 40, String.valueOf(this.controller.yellowCrossTime), 10, Color.WHITE, Color.BLACK, 1);
        this.addTextBox(this.yellowCrossTimeText);
        this.addLabel(new GUIComponentLabel(guiLeft + 30, this.yellowCrossTimeText.y, Color.WHITE, MasterLoader.coreInterface.translate("gui.trafficsignalcontroller.yellowcrosstime")).setBox(this.yellowMainTimeText));
        this.allRedTimeText = new GUIComponentTextBox(guiLeft + 180, guiTop + 145, 40, String.valueOf(this.controller.allRedTime), 10, Color.WHITE, Color.BLACK, 1);
        this.addTextBox(this.allRedTimeText);
        this.addLabel(new GUIComponentLabel(guiLeft + 30, this.allRedTimeText.y, Color.WHITE, MasterLoader.coreInterface.translate("gui.trafficsignalcontroller.allredtime")).setBox(this.allRedTimeText));
        this.confirmButton = new GUIComponentButton(guiLeft + 25, guiTop + 160, 80, MasterLoader.coreInterface.translate("gui.trafficsignalcontroller.confirm")){

            @Override
            public void onClicked() {
                try {
                    ((GUISignalController)GUISignalController.this).controller.greenMainTime = Integer.valueOf(GUISignalController.this.greenMainTimeText.getText());
                    ((GUISignalController)GUISignalController.this).controller.greenCrossTime = Integer.valueOf(GUISignalController.this.greenCrossTimeText.getText());
                    ((GUISignalController)GUISignalController.this).controller.yellowMainTime = Integer.valueOf(GUISignalController.this.yellowMainTimeText.getText());
                    ((GUISignalController)GUISignalController.this).controller.yellowCrossTime = Integer.valueOf(GUISignalController.this.yellowCrossTimeText.getText());
                    ((GUISignalController)GUISignalController.this).controller.allRedTime = Integer.valueOf(GUISignalController.this.allRedTimeText.getText());
                    ((GUISignalController)GUISignalController.this).controller.componentLocations.clear();
                    ((GUISignalController)GUISignalController.this).controller.componentLocations.addAll(GUISignalController.this.componentLocations);
                }
                catch (Exception e) {
                    return;
                }
                MasterLoader.networkInterface.sendToServer(new PacketTileEntitySignalControllerChange(GUISignalController.this.controller));
                MasterLoader.guiInterface.closeGUI();
            }
        };
        this.addButton(this.confirmButton);
    }

    @Override
    public void setStates() {
        this.trafficSignalCount.visible = this.trafficSignals > 0;
        this.streetLightCount.visible = this.streetLights > 0;
        this.trafficSignalCount.text = " X" + this.trafficSignals;
        this.streetLightCount.text = " X" + this.streetLights;
        if (this.trafficSignals > 0) {
            this.orientationButton.enabled = true;
            this.modeButton.enabled = true;
            this.greenMainTimeText.enabled = true;
            this.greenCrossTimeText.enabled = true;
            this.yellowMainTimeText.enabled = true;
            this.yellowCrossTimeText.enabled = true;
            this.allRedTimeText.enabled = true;
            this.confirmButton.enabled = true;
        } else {
            this.orientationButton.enabled = false;
            this.modeButton.enabled = false;
            this.greenMainTimeText.enabled = false;
            this.greenCrossTimeText.enabled = false;
            this.yellowMainTimeText.enabled = false;
            this.yellowCrossTimeText.enabled = false;
            this.allRedTimeText.enabled = false;
            this.confirmButton.enabled = false;
        }
        this.greenMainTimeText.visible = this.controller.currentOpMode.equals((Object)TileEntitySignalController.OpMode.TIMED_CYCLE);
    }
}

