/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole_Sign;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.guis.components.GUIComponentOBJModel;
import minecrafttransportsimulator.guis.components.GUIComponentTextBox;
import minecrafttransportsimulator.jsondefs.JSONPoleComponent;
import minecrafttransportsimulator.jsondefs.JSONText;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.instances.PacketTileEntityPoleChange;
import minecrafttransportsimulator.packets.instances.PacketVehicleTextChange;
import minecrafttransportsimulator.packloading.PackResourceLoader;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;
import org.lwjgl.opengl.GL11;

public class GUITextEditor
extends AGUIBase {
    private GUIComponentButton confirmButton;
    private final List<GUIComponentTextBox> textBoxes = new ArrayList<GUIComponentTextBox>();
    private final List<GUIComponentLabel> signLabels = new ArrayList<GUIComponentLabel>();
    private final TileEntityPole pole;
    private final ABlockBase.Axis axis;
    private final EntityVehicleF_Physics vehicle;
    private final List<Integer> vehicleTextBoxes = new ArrayList<Integer>();

    public GUITextEditor(TileEntityPole pole, ABlockBase.Axis axis) {
        this.pole = pole;
        this.axis = axis;
        this.vehicle = null;
    }

    public GUITextEditor(EntityVehicleF_Physics vehicle) {
        this.pole = null;
        this.axis = null;
        this.vehicle = vehicle;
    }

    @Override
    public void setupComponents(int guiLeft, int guiTop) {
        List<Object> textLines;
        List<Object> textObjects;
        this.textBoxes.clear();
        if (this.pole != null) {
            Iterator<JSONText> sign = (TileEntityPole_Sign)this.pole.components.get((Object)this.axis);
            GUIComponentOBJModel modelRender = new GUIComponentOBJModel(guiLeft + this.getWidth() / 2, guiTop + 160, 64.0f, false, false, false);
            this.addOBJModel(modelRender);
            modelRender.modelLocation = PackResourceLoader.getPackResource(((TileEntityPole_Sign)((Object)sign)).definition, PackResourceLoader.ResourceType.OBJ, ((JSONPoleComponent.PoleGeneral)((TileEntityPole_Sign)((Object)sign)).definition.general).modelName != null ? ((JSONPoleComponent.PoleGeneral)((TileEntityPole_Sign)((Object)sign)).definition.general).modelName : ((TileEntityPole_Sign)((Object)sign)).definition.systemName);
            modelRender.textureLocation = PackResourceLoader.getPackResource(((TileEntityPole_Sign)((Object)sign)).definition, PackResourceLoader.ResourceType.PNG, ((TileEntityPole_Sign)((Object)sign)).definition.systemName);
            textObjects = ((JSONPoleComponent.PoleGeneral)this.pole.components.get((Object)((Object)this.axis)).definition.general).textObjects;
            textLines = ((TileEntityPole_Sign)((Object)sign)).getTextLines();
            this.signLabels.clear();
            for (int i = 0; i < textObjects.size(); i = (int)((byte)(i + 1))) {
                JSONText textObject = (JSONText)textObjects.get(i);
                GUIComponentLabel gUIComponentLabel = new GUIComponentLabel(modelRender.x + (int)(textObject.pos.x * 64.0), modelRender.y - (int)(textObject.pos.y * 64.0), Color.decode(textObject.color), ((TileEntityPole_Sign)((Object)sign)).getTextLines().get(i), AGUIBase.TextPosition.values()[textObject.renderPosition], textObject.wrapWidth, textObject.scale, textObject.autoScale){

                    @Override
                    public void renderText() {
                        GL11.glPushMatrix();
                        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
                        GL11.glScalef((float)4.0f, (float)4.0f, (float)4.0f);
                        MasterLoader.guiInterface.drawScaledText(this.text, 0, 0, this.color, this.renderMode, this.wrapWidth, this.scale, this.autoScale);
                        GL11.glPopMatrix();
                    }
                };
                this.addLabel(gUIComponentLabel);
                this.signLabels.add(gUIComponentLabel);
            }
        } else {
            textObjects = new ArrayList<JSONText>();
            textLines = new ArrayList();
            if (this.vehicle.definition.rendering.textObjects != null) {
                for (JSONText textObject : this.vehicle.definition.rendering.textObjects) {
                    textObjects.add(textObject);
                    textLines.add(this.vehicle.textLines.get(textObjects.indexOf(textObject)));
                }
            }
            for (APart part : this.vehicle.parts) {
                if (part.definition.rendering == null || part.definition.rendering.textObjects == null) continue;
                for (JSONText textObject : part.definition.rendering.textObjects) {
                    textObjects.add(textObject);
                    textLines.add(part.textLines.get(textObjects.indexOf(textObject)));
                }
            }
        }
        ArrayList<String> renderedFields = new ArrayList<String>();
        this.vehicleTextBoxes.clear();
        int currentOffset = 0;
        int boxWidth = this.vehicle != null ? 200 : 100;
        for (JSONText jSONText : textObjects) {
            if (!renderedFields.contains(jSONText.fieldName)) {
                GUIComponentLabel label = new GUIComponentLabel(guiLeft + 20, guiTop + 30 + currentOffset, Color.BLACK, jSONText.fieldName);
                this.addLabel(label);
                int textRowsRequired = 1 + 5 * jSONText.maxLength / boxWidth;
                GUIComponentTextBox box = new GUIComponentTextBox(guiLeft + 20, label.y + 10, boxWidth, (String)textLines.get(textObjects.indexOf(jSONText)), 12 * textRowsRequired, Color.WHITE, Color.BLACK, jSONText.maxLength);
                this.addTextBox(box);
                this.vehicleTextBoxes.add(this.textBoxes.size());
                renderedFields.add(jSONText.fieldName);
                this.textBoxes.add(box);
                currentOffset += box.height + 12;
                continue;
            }
            this.vehicleTextBoxes.add(renderedFields.indexOf(jSONText.fieldName));
        }
        this.confirmButton = new GUIComponentButton(guiLeft + 150, guiTop + 15, 80, MasterLoader.coreInterface.translate("gui.trafficsignalcontroller.confirm")){

            @Override
            public void onClicked() {
                if (GUITextEditor.this.pole != null) {
                    ArrayList<String> textLines = new ArrayList<String>();
                    for (GUIComponentTextBox box : GUITextEditor.this.textBoxes) {
                        textLines.add(box.getText());
                    }
                    MasterLoader.networkInterface.sendToServer(new PacketTileEntityPoleChange(GUITextEditor.this.pole, GUITextEditor.this.axis, null, textLines, false));
                } else {
                    ArrayList<String> textLines = new ArrayList<String>();
                    for (Integer textBoxIndex : GUITextEditor.this.vehicleTextBoxes) {
                        textLines.add(((GUIComponentTextBox)GUITextEditor.this.textBoxes.get(textBoxIndex)).getText());
                    }
                    MasterLoader.networkInterface.sendToServer(new PacketVehicleTextChange(GUITextEditor.this.vehicle, textLines));
                }
                MasterLoader.guiInterface.closeGUI();
            }
        };
        this.addButton(this.confirmButton);
    }

    @Override
    public void setStates() {
        this.confirmButton.enabled = true;
        for (int i = 0; i < this.signLabels.size(); i = (int)((byte)(i + 1))) {
            this.signLabels.get((int)i).text = this.textBoxes.get(i).getText();
        }
    }
}

