/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.instances;

import java.util.List;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.IItemVehicleInteractable;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.packets.instances.PacketVehiclePartEngine;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartEngine;

public class ItemJumperCable
extends AItemBase
implements IItemVehicleInteractable {
    private static PartEngine lastEngineClicked;

    @Override
    public void addTooltipLines(List<String> tooltipLines, IWrapperNBT data) {
        for (int i = 1; i <= 5; i = (int)((byte)(i + 1))) {
            tooltipLines.add(MasterLoader.coreInterface.translate("info.item.jumpercable.line" + String.valueOf(i)));
        }
    }

    @Override
    public IItemVehicleInteractable.CallbackType doVehicleInteraction(EntityVehicleF_Physics vehicle, APart part, IWrapperPlayer player, IItemVehicleInteractable.PlayerOwnerState ownerState, boolean rightClick) {
        if (!vehicle.world.isClient() && rightClick && part instanceof PartEngine) {
            PartEngine engine = (PartEngine)part;
            if (engine.linkedEngine == null) {
                if (lastEngineClicked == null) {
                    lastEngineClicked = engine;
                    player.sendPacket(new PacketPlayerChatMessage("interact.jumpercable.firstlink"));
                } else if (!lastEngineClicked.equals(engine)) {
                    if (ItemJumperCable.lastEngineClicked.vehicle.equals(engine.vehicle)) {
                        lastEngineClicked = null;
                        player.sendPacket(new PacketPlayerChatMessage("interact.jumpercable.samevehicle"));
                    } else if (engine.worldPos.distanceTo(ItemJumperCable.lastEngineClicked.worldPos) < 15.0) {
                        engine.linkedEngine = lastEngineClicked;
                        ItemJumperCable.lastEngineClicked.linkedEngine = engine;
                        MasterLoader.networkInterface.sendToAllClients(new PacketVehiclePartEngine(engine, lastEngineClicked));
                        MasterLoader.networkInterface.sendToAllClients(new PacketVehiclePartEngine(lastEngineClicked, engine));
                        lastEngineClicked = null;
                        player.sendPacket(new PacketPlayerChatMessage("interact.jumpercable.secondlink"));
                    } else {
                        lastEngineClicked = null;
                        player.sendPacket(new PacketPlayerChatMessage("interact.jumpercable.toofar"));
                    }
                }
            } else {
                player.sendPacket(new PacketPlayerChatMessage("interact.jumpercable.alreadylinked"));
            }
        }
        return IItemVehicleInteractable.CallbackType.NONE;
    }
}

