/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.instances;

import java.util.List;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.IItemVehicleInteractable;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartSeat;

public class ItemKey
extends AItemBase
implements IItemVehicleInteractable {
    @Override
    public void addTooltipLines(List<String> tooltipLines, IWrapperNBT data) {
        for (int i = 1; i <= 5; i = (int)((byte)(i + 1))) {
            tooltipLines.add(MasterLoader.coreInterface.translate("info.item.key.line" + String.valueOf(i)));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public IItemVehicleInteractable.CallbackType doVehicleInteraction(EntityVehicleF_Physics vehicle, APart part, IWrapperPlayer player, IItemVehicleInteractable.PlayerOwnerState ownerState, boolean rightClick) {
        if (!vehicle.world.isClient()) {
            if (!rightClick) return IItemVehicleInteractable.CallbackType.NONE;
            if (player.isSneaking()) {
                if (vehicle.ownerUUID.isEmpty()) {
                    vehicle.ownerUUID = player.getUUID();
                    player.sendPacket(new PacketPlayerChatMessage("interact.key.info.own"));
                    return IItemVehicleInteractable.CallbackType.NONE;
                }
                if (!ownerState.equals((Object)IItemVehicleInteractable.PlayerOwnerState.USER)) {
                    vehicle.ownerUUID = "";
                    player.sendPacket(new PacketPlayerChatMessage("interact.key.info.unown"));
                    return IItemVehicleInteractable.CallbackType.NONE;
                }
                player.sendPacket(new PacketPlayerChatMessage("interact.key.failure.alreadyowned"));
                return IItemVehicleInteractable.CallbackType.NONE;
            }
            IWrapperItemStack stack = player.getHeldStack();
            IWrapperNBT data = stack.getData();
            String keyVehicleUUID = data.getString("vehicle");
            if (keyVehicleUUID.isEmpty()) {
                if (!vehicle.ownerUUID.isEmpty() && ownerState.equals((Object)IItemVehicleInteractable.PlayerOwnerState.USER)) {
                    player.sendPacket(new PacketPlayerChatMessage("interact.key.failure.notowner"));
                    return IItemVehicleInteractable.CallbackType.NONE;
                }
                keyVehicleUUID = vehicle.uniqueUUID;
                data.setString("vehicle", keyVehicleUUID);
                stack.setData(data);
            }
            if (!keyVehicleUUID.equals(vehicle.uniqueUUID)) {
                player.sendPacket(new PacketPlayerChatMessage("interact.key.failure.wrongkey"));
                return IItemVehicleInteractable.CallbackType.NONE;
            }
            if (vehicle.locked) {
                vehicle.locked = false;
                player.sendPacket(new PacketPlayerChatMessage("interact.key.info.unlock"));
                if (!(part instanceof PartSeat)) return IItemVehicleInteractable.CallbackType.ALL;
                if (player.getEntityRiding() != null) return IItemVehicleInteractable.CallbackType.ALL;
                part.interact(player);
                return IItemVehicleInteractable.CallbackType.ALL;
            }
            vehicle.locked = true;
            player.sendPacket(new PacketPlayerChatMessage("interact.key.info.lock"));
            return IItemVehicleInteractable.CallbackType.ALL;
        }
        vehicle.locked = !vehicle.locked;
        return IItemVehicleInteractable.CallbackType.NONE;
    }

    @Override
    public boolean canBeStacked() {
        return false;
    }
}

