/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.instances;

import java.util.List;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packloading.PackResourceLoader;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartCustom;
import minecrafttransportsimulator.vehicles.parts.PartEngine;
import minecrafttransportsimulator.vehicles.parts.PartGroundDevice;
import minecrafttransportsimulator.vehicles.parts.PartGroundEffector;
import minecrafttransportsimulator.vehicles.parts.PartGun;
import minecrafttransportsimulator.vehicles.parts.PartInteractable;
import minecrafttransportsimulator.vehicles.parts.PartPropeller;
import minecrafttransportsimulator.vehicles.parts.PartSeat;

public class ItemPart
extends AItemSubTyped<JSONPart> {
    private final String partPrefix;

    public ItemPart(JSONPart definition, String subName) {
        super(definition, PackResourceLoader.ItemClassification.PART, subName);
        this.partPrefix = ((JSONPart.JSONPartGeneral)definition.general).type.indexOf("_") != -1 ? ((JSONPart.JSONPartGeneral)definition.general).type.substring(0, ((JSONPart.JSONPartGeneral)definition.general).type.indexOf("_")) : ((JSONPart.JSONPartGeneral)definition.general).type;
    }

    public boolean isPartValidForPackDef(JSONVehicle.VehiclePart packVehicleDef) {
        boolean customTypesValid = packVehicleDef.customTypes == null ? ((JSONPart.JSONPartGeneral)((JSONPart)this.definition).general).customType == null : (((JSONPart.JSONPartGeneral)((JSONPart)this.definition).general).customType == null ? packVehicleDef.customTypes == null || packVehicleDef.customTypes.contains("") : packVehicleDef.customTypes.contains(((JSONPart.JSONPartGeneral)((JSONPart)this.definition).general).customType));
        switch (this.partPrefix) {
            case "custom": {
                return packVehicleDef.customTypes != null && packVehicleDef.customTypes.contains(((JSONPart.JSONPartGeneral)((JSONPart)this.definition).general).customType);
            }
            case "bullet": {
                return customTypesValid && packVehicleDef.minValue <= ((JSONPart)this.definition).bullet.diameter && packVehicleDef.maxValue >= ((JSONPart)this.definition).bullet.diameter;
            }
            case "engine": {
                return customTypesValid && packVehicleDef.minValue <= ((JSONPart)this.definition).engine.fuelConsumption && packVehicleDef.maxValue >= ((JSONPart)this.definition).engine.fuelConsumption;
            }
            case "ground": {
                return customTypesValid && packVehicleDef.minValue <= ((JSONPart)this.definition).ground.height && packVehicleDef.maxValue >= ((JSONPart)this.definition).ground.height;
            }
            case "gun": {
                return customTypesValid && packVehicleDef.minValue <= ((JSONPart)this.definition).gun.diameter && packVehicleDef.maxValue >= ((JSONPart)this.definition).gun.diameter;
            }
            case "interactable": {
                return customTypesValid && packVehicleDef.minValue <= (float)((JSONPart)this.definition).interactable.inventoryUnits && packVehicleDef.maxValue >= (float)((JSONPart)this.definition).interactable.inventoryUnits;
            }
            case "propeller": {
                return customTypesValid && packVehicleDef.minValue <= (float)((JSONPart)this.definition).propeller.diameter && packVehicleDef.maxValue >= (float)((JSONPart)this.definition).propeller.diameter;
            }
        }
        return customTypesValid;
    }

    public APart createPart(EntityVehicleF_Physics vehicle, JSONVehicle.VehiclePart packVehicleDef, IWrapperNBT partData, APart parentPart) {
        if (((JSONPart.JSONPartGeneral)((JSONPart)this.definition).general).type.startsWith("engine_")) {
            return new PartEngine(vehicle, packVehicleDef, this, partData, parentPart);
        }
        if (((JSONPart.JSONPartGeneral)((JSONPart)this.definition).general).type.startsWith("gun_")) {
            return new PartGun(vehicle, packVehicleDef, this, partData, parentPart);
        }
        if (((JSONPart.JSONPartGeneral)((JSONPart)this.definition).general).type.startsWith("ground_")) {
            return new PartGroundDevice(vehicle, packVehicleDef, this, partData, parentPart);
        }
        if (((JSONPart.JSONPartGeneral)((JSONPart)this.definition).general).type.startsWith("interactable_")) {
            return new PartInteractable(vehicle, packVehicleDef, this, partData, parentPart);
        }
        if (((JSONPart.JSONPartGeneral)((JSONPart)this.definition).general).type.startsWith("effector_")) {
            return new PartGroundEffector(vehicle, packVehicleDef, this, partData, parentPart);
        }
        switch (((JSONPart.JSONPartGeneral)((JSONPart)this.definition).general).type) {
            case "propeller": {
                return new PartPropeller(vehicle, packVehicleDef, this, partData, parentPart);
            }
            case "seat": {
                return new PartSeat(vehicle, packVehicleDef, this, partData, parentPart);
            }
            case "custom": {
                return new PartCustom(vehicle, packVehicleDef, this, partData, parentPart);
            }
        }
        throw new IllegalArgumentException(((JSONPart.JSONPartGeneral)((JSONPart)this.definition).general).type + " is not a valid type for creating a part.");
    }

    @Override
    public void addTooltipLines(List<String> tooltipLines, IWrapperNBT data) {
        super.addTooltipLines(tooltipLines, data);
        switch (this.partPrefix) {
            case "bullet": {
                tooltipLines.add(MasterLoader.coreInterface.translate("info.item.bullet.type." + ((JSONPart)this.definition).bullet.type));
                tooltipLines.add(MasterLoader.coreInterface.translate("info.item.bullet.diameter") + ((JSONPart)this.definition).bullet.diameter);
                tooltipLines.add(MasterLoader.coreInterface.translate("info.item.bullet.quantity") + ((JSONPart)this.definition).bullet.quantity);
                break;
            }
            case "engine": {
                if (data.getBoolean("isCreative")) {
                    tooltipLines.add(MasterLoader.guiInterface.getFormattingCode("dark_purple") + MasterLoader.coreInterface.translate("info.item.engine.creative"));
                }
                tooltipLines.add(MasterLoader.coreInterface.translate("info.item.engine.maxrpm") + ((JSONPart)this.definition).engine.maxRPM);
                tooltipLines.add(MasterLoader.coreInterface.translate("info.item.engine.maxsaferpm") + PartEngine.getSafeRPMFromMax(((JSONPart)this.definition).engine.maxRPM));
                tooltipLines.add(MasterLoader.coreInterface.translate("info.item.engine.fuelconsumption") + ((JSONPart)this.definition).engine.fuelConsumption);
                if (((JSONPart)this.definition).engine.jetPowerFactor > 0.0f) {
                    tooltipLines.add(MasterLoader.coreInterface.translate("info.item.engine.jetpowerfactor") + (int)(100.0f * ((JSONPart)this.definition).engine.jetPowerFactor) + "%");
                    tooltipLines.add(MasterLoader.coreInterface.translate("info.item.engine.bypassratio") + ((JSONPart)this.definition).engine.bypassRatio);
                }
                tooltipLines.add(MasterLoader.coreInterface.translate("info.item.engine.fueltype") + ((JSONPart)this.definition).engine.fuelType);
                tooltipLines.add(MasterLoader.coreInterface.translate("info.item.engine.hours") + (double)Math.round(data.getDouble("hours") * 100.0) / 100.0);
                if (((JSONPart)this.definition).engine.gearRatios.length > 3) {
                    tooltipLines.add(((JSONPart)this.definition).engine.isAutomatic ? MasterLoader.coreInterface.translate("info.item.engine.automatic") : MasterLoader.coreInterface.translate("info.item.engine.manual"));
                    tooltipLines.add(MasterLoader.coreInterface.translate("info.item.engine.gearratios"));
                    for (int i = 0; i < ((JSONPart)this.definition).engine.gearRatios.length; i = (int)((byte)(i + 5))) {
                        String gearRatios = "";
                        for (int j = i; j < i + 5 && j < ((JSONPart)this.definition).engine.gearRatios.length; j = (int)((byte)(j + 1))) {
                            gearRatios = gearRatios + String.valueOf(((JSONPart)this.definition).engine.gearRatios[j]) + ",  ";
                        }
                        tooltipLines.add(gearRatios);
                    }
                } else {
                    tooltipLines.add(MasterLoader.coreInterface.translate("info.item.engine.gearratios") + ((JSONPart)this.definition).engine.gearRatios[((JSONPart)this.definition).engine.gearRatios.length - 1]);
                }
                if (data.getBoolean("oilLeak")) {
                    tooltipLines.add(MasterLoader.guiInterface.getFormattingCode("red") + MasterLoader.coreInterface.translate("info.item.engine.oilleak"));
                }
                if (data.getBoolean("fuelLeak")) {
                    tooltipLines.add(MasterLoader.guiInterface.getFormattingCode("red") + MasterLoader.coreInterface.translate("info.item.engine.fuelleak"));
                }
                if (!data.getBoolean("brokenStarter")) break;
                tooltipLines.add(MasterLoader.guiInterface.getFormattingCode("red") + MasterLoader.coreInterface.translate("info.item.engine.brokenstarter"));
                break;
            }
            case "ground": {
                tooltipLines.add(MasterLoader.coreInterface.translate("info.item.ground_device.diameter") + ((JSONPart)this.definition).ground.height);
                tooltipLines.add(MasterLoader.coreInterface.translate("info.item.ground_device.motivefriction") + ((JSONPart)this.definition).ground.motiveFriction);
                tooltipLines.add(MasterLoader.coreInterface.translate("info.item.ground_device.lateralfriction") + ((JSONPart)this.definition).ground.lateralFriction);
                tooltipLines.add(MasterLoader.coreInterface.translate(((JSONPart)this.definition).ground.isWheel ? "info.item.ground_device.rotatesonshaft_true" : "info.item.ground_device.rotatesonshaft_false"));
                tooltipLines.add(MasterLoader.coreInterface.translate(((JSONPart)this.definition).ground.canFloat ? "info.item.ground_device.canfloat_true" : "info.item.ground_device.canfloat_false"));
                break;
            }
            case "gun": {
                tooltipLines.add(MasterLoader.coreInterface.translate("info.item.gun.type." + ((JSONPart.JSONPartGeneral)((JSONPart)this.definition).general).type.substring("gun_".length())));
                tooltipLines.add(MasterLoader.coreInterface.translate("info.item.gun.diameter") + ((JSONPart)this.definition).gun.diameter);
                tooltipLines.add(MasterLoader.coreInterface.translate("info.item.gun.length") + ((JSONPart)this.definition).gun.length);
                tooltipLines.add(MasterLoader.coreInterface.translate("info.item.gun.fireDelay") + ((JSONPart)this.definition).gun.fireDelay);
                tooltipLines.add(MasterLoader.coreInterface.translate("info.item.gun.muzzleVelocity") + ((JSONPart)this.definition).gun.muzzleVelocity);
                tooltipLines.add(MasterLoader.coreInterface.translate("info.item.gun.capacity") + ((JSONPart)this.definition).gun.capacity);
                if (((JSONPart)this.definition).gun.autoReload) {
                    tooltipLines.add(MasterLoader.coreInterface.translate("info.item.gun.autoReload"));
                }
                tooltipLines.add(MasterLoader.coreInterface.translate("info.item.gun.yawRange") + ((JSONPart)this.definition).gun.minYaw + "-" + ((JSONPart)this.definition).gun.maxYaw);
                tooltipLines.add(MasterLoader.coreInterface.translate("info.item.gun.pitchRange") + ((JSONPart)this.definition).gun.minPitch + "-" + ((JSONPart)this.definition).gun.maxPitch);
                break;
            }
            case "interactable": {
                if (((JSONPart)this.definition).interactable.interactionType.equals("crate")) {
                    tooltipLines.add(MasterLoader.coreInterface.translate("info.item.interactable.capacity") + ((JSONPart)this.definition).interactable.inventoryUnits * 9);
                    break;
                }
                if (!((JSONPart)this.definition).interactable.interactionType.equals("barrel")) break;
                tooltipLines.add(MasterLoader.coreInterface.translate("info.item.interactable.capacity") + ((JSONPart)this.definition).interactable.inventoryUnits * 10000 + "mb");
                break;
            }
            case "propeller": {
                tooltipLines.add(MasterLoader.coreInterface.translate(((JSONPart)this.definition).propeller.isDynamicPitch ? "info.item.propeller.dynamicPitch" : "info.item.propeller.staticPitch"));
                tooltipLines.add(MasterLoader.coreInterface.translate("info.item.propeller.pitch") + ((JSONPart)this.definition).propeller.pitch);
                tooltipLines.add(MasterLoader.coreInterface.translate("info.item.propeller.diameter") + ((JSONPart)this.definition).propeller.diameter);
                tooltipLines.add(MasterLoader.coreInterface.translate("info.item.propeller.maxrpm") + Math.round(20417.4 / (0.07979645340118074 * (double)((JSONPart)this.definition).propeller.diameter)));
                tooltipLines.add(MasterLoader.coreInterface.translate("info.item.propeller.health") + ((double)((JSONPart)this.definition).propeller.startingHealth - data.getDouble("damage")));
            }
        }
    }

    @Override
    public void getDataBlocks(List<IWrapperNBT> dataBlocks) {
        if (this.partPrefix.equals("engine")) {
            IWrapperNBT data = MasterLoader.coreInterface.createNewTag();
            data.setBoolean("isCreative", true);
            dataBlocks.add(data);
        }
    }
}

