/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.instances;

import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.baseclasses.Point3i;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.items.components.IItemEntityProvider;
import minecrafttransportsimulator.items.instances.ItemInstrument;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.packloading.PackResourceLoader;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartEngine;

public class ItemVehicle
extends AItemSubTyped<JSONVehicle>
implements IItemEntityProvider<EntityVehicleF_Physics> {
    public ItemVehicle(JSONVehicle definition, String subName) {
        super(definition, PackResourceLoader.ItemClassification.VEHICLE, subName);
    }

    @Override
    public boolean onBlockClicked(IWrapperWorld world, IWrapperPlayer player, Point3i point, ABlockBase.Axis axis) {
        if (!world.isClient()) {
            IWrapperItemStack heldStack = player.getHeldStack();
            ++point.y;
            IWrapperNBT data = heldStack.getData();
            boolean wasSaved = !data.getString("packID").isEmpty();
            data.setString("packID", ((JSONVehicle)this.definition).packID);
            data.setString("systemName", ((JSONVehicle)this.definition).systemName);
            data.setString("subName", this.subName);
            data.setInteger("lookupID", 0);
            data.setPoint3d("position", new Point3d(0.0, 0.0, 0.0));
            data.setPoint3d("motion", new Point3d(0.0, 0.0, 0.0));
            data.setPoint3d("angles", new Point3d(0.0, 0.0, 0.0));
            data.setPoint3d("rotation", new Point3d(0.0, 0.0, 0.0));
            EntityVehicleF_Physics newVehicle = this.createEntity(world, data);
            newVehicle.position.set(point.x, point.y, point.z);
            newVehicle.angles.y = player.getYaw() + 90.0f;
            if (!wasSaved) {
                newVehicle.electricPower = 12.0;
                EntityVehicleF_Physics.addDefaultParts(newVehicle.definition.parts, newVehicle, null, false);
                if (newVehicle.definition.rendering.textObjects != null) {
                    for (int i = 0; i < newVehicle.definition.rendering.textObjects.size(); i = (int)((byte)(i + 1))) {
                        newVehicle.textLines.set(i, newVehicle.definition.rendering.textObjects.get((int)i).defaultText);
                    }
                }
                for (JSONVehicle.PackInstrument packInstrument : newVehicle.definition.motorized.instruments) {
                    if (packInstrument.defaultInstrument == null) continue;
                    try {
                        String instrumentPackID = packInstrument.defaultInstrument.substring(0, packInstrument.defaultInstrument.indexOf(58));
                        String instrumentSystemName = packInstrument.defaultInstrument.substring(packInstrument.defaultInstrument.indexOf(58) + 1);
                        try {
                            ItemInstrument instrument = (ItemInstrument)PackParserSystem.getItem(instrumentPackID, instrumentSystemName);
                            if (instrument != null) {
                                newVehicle.instruments.put((byte)newVehicle.definition.motorized.instruments.indexOf(packInstrument), instrument);
                                continue;
                            }
                        }
                        catch (NullPointerException instrument) {
                            // empty catch block
                        }
                        throw new IllegalArgumentException("ERROR: Attempted to add defaultInstrument: " + instrumentPackID + ":" + (String)instrumentSystemName + " to: " + newVehicle.definition.packID + ":" + newVehicle.definition.systemName + " but that instrument doesn't exist in the pack item registry.");
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw new IllegalArgumentException("ERROR: Could not parse defaultInstrument definition: " + packInstrument.defaultInstrument + ".  Format should be \"packId:instrumentName\"");
                    }
                }
                if (newVehicle.definition.motorized.defaultFuelQty > 0) {
                    for (APart part : newVehicle.parts) {
                        if (!(part instanceof PartEngine)) continue;
                        String mostPotentFluid = "";
                        for (String fluidName : ConfigSystem.configObject.fuel.fuels.get(part.definition.engine.fuelType).keySet()) {
                            if (!mostPotentFluid.isEmpty() && !(ConfigSystem.configObject.fuel.fuels.get(part.definition.engine.fuelType).get(mostPotentFluid) < ConfigSystem.configObject.fuel.fuels.get(part.definition.engine.fuelType).get(fluidName))) continue;
                            mostPotentFluid = fluidName;
                        }
                        newVehicle.fuelTank.manuallySet(mostPotentFluid, newVehicle.definition.motorized.defaultFuelQty);
                        break;
                    }
                    if (newVehicle.fuelTank.getFluid().isEmpty()) {
                        throw new IllegalArgumentException("ERROR: A defaultFuelQty was specified for: " + newVehicle.definition.packID + ":" + newVehicle.definition.systemName + ", but no engine was noted as a defaultPart, so we don't know what fuel to put in the vehicle.");
                    }
                }
                if (((JSONVehicle)this.definition).doors != null) {
                    for (JSONVehicle.VehicleDoor door : ((JSONVehicle)this.definition).doors) {
                        if (door.closedByDefault) continue;
                        newVehicle.doorsOpen.add(door.name);
                    }
                }
            }
            double minHeight = 0.0;
            for (JSONVehicle.VehicleCollisionBox collisionBox : newVehicle.definition.collision) {
                minHeight = Math.min(collisionBox.pos.y - (double)(collisionBox.height / 2.0f), minHeight);
            }
            for (APart part : newVehicle.parts) {
                minHeight = Math.min(part.placementOffset.y - (double)(part.getHeight() / 2.0f), minHeight);
            }
            newVehicle.position.y += -minHeight;
            for (BoundingBox coreBox : newVehicle.blockCollisionBoxes) {
                coreBox.updateToEntity(newVehicle);
                if (!coreBox.updateCollidingBlocks(newVehicle.world, new Point3d(0.0, -minHeight, 0.0))) continue;
                player.sendPacket(new PacketPlayerChatMessage("interact.failure.nospace"));
                return false;
            }
            world.spawnEntity(newVehicle);
            if (!player.isCreative()) {
                player.getInventory().removeStack(heldStack, 1);
            }
        }
        return true;
    }

    @Override
    public EntityVehicleF_Physics createEntity(IWrapperWorld world, IWrapperNBT data) {
        EntityVehicleF_Physics vehicle = new EntityVehicleF_Physics(world, data);
        for (APart part : vehicle.partsFromNBT) {
            vehicle.addPart(part);
        }
        vehicle.partsFromNBT.clear();
        return vehicle;
    }

    @Override
    public Class<EntityVehicleF_Physics> getEntityClass() {
        return EntityVehicleF_Physics.class;
    }
}

