/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.instances;

import java.util.Iterator;
import java.util.List;
import minecrafttransportsimulator.guis.instances.GUIDevEditor;
import minecrafttransportsimulator.guis.instances.GUIInstruments;
import minecrafttransportsimulator.guis.instances.GUITextEditor;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.IItemVehicleInteractable;
import minecrafttransportsimulator.items.instances.ItemPart;
import minecrafttransportsimulator.items.instances.ItemVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;

public class ItemWrench
extends AItemBase
implements IItemVehicleInteractable {
    @Override
    public void addTooltipLines(List<String> tooltipLines, IWrapperNBT data) {
        tooltipLines.add(MasterLoader.coreInterface.translate("info.item.wrench.use"));
        tooltipLines.add(MasterLoader.coreInterface.translate("info.item.wrench.useblock"));
        tooltipLines.add(MasterLoader.coreInterface.translate("info.item.wrench.attack"));
        tooltipLines.add(MasterLoader.coreInterface.translate("info.item.wrench.sneakattack"));
        if (((Boolean)ConfigSystem.configObject.client.devMode.value).booleanValue()) {
            tooltipLines.add("Use while riding a vehicle to open the devMode editor.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IItemVehicleInteractable.CallbackType doVehicleInteraction(EntityVehicleF_Physics vehicle, APart part, IWrapperPlayer player, IItemVehicleInteractable.PlayerOwnerState ownerState, boolean rightClick) {
        if (!ownerState.equals((Object)IItemVehicleInteractable.PlayerOwnerState.USER)) {
            if (rightClick) {
                if (!vehicle.world.isClient()) return IItemVehicleInteractable.CallbackType.PLAYER;
                if (((Boolean)ConfigSystem.configObject.client.devMode.value).booleanValue() && vehicle.equals(player.getEntityRiding())) {
                    MasterLoader.guiInterface.openGUI(new GUIDevEditor(vehicle));
                    return IItemVehicleInteractable.CallbackType.NONE;
                } else if (player.isSneaking()) {
                    MasterLoader.guiInterface.openGUI(new GUITextEditor(vehicle));
                    return IItemVehicleInteractable.CallbackType.NONE;
                } else {
                    MasterLoader.guiInterface.openGUI(new GUIInstruments(vehicle, player));
                }
                return IItemVehicleInteractable.CallbackType.NONE;
            } else {
                if (vehicle.world.isClient()) return IItemVehicleInteractable.CallbackType.NONE;
                if (part != null && !player.isSneaking()) {
                    vehicle.removePart(part, (Iterator)null);
                    ItemPart droppedItem = part.getItem();
                    if (droppedItem == null) return IItemVehicleInteractable.CallbackType.NONE;
                    vehicle.world.spawnItem(droppedItem, part.getData(), part.worldPos);
                    return IItemVehicleInteractable.CallbackType.NONE;
                } else {
                    if (!player.isSneaking() || ((Boolean)ConfigSystem.configObject.general.opPickupVehiclesOnly.value).booleanValue() && !ownerState.equals((Object)IItemVehicleInteractable.PlayerOwnerState.ADMIN) || ((Boolean)ConfigSystem.configObject.general.creativePickupVehiclesOnly.value).booleanValue() && !player.isCreative()) return IItemVehicleInteractable.CallbackType.NONE;
                    ItemVehicle vehicleItem = (ItemVehicle)PackParserSystem.getItem(vehicle.definition.packID, vehicle.definition.systemName, vehicle.currentSubName);
                    IWrapperNBT vehicleData = MasterLoader.coreInterface.createNewTag();
                    vehicle.save(vehicleData);
                    vehicle.world.spawnItem(vehicleItem, vehicleData, vehicle.position);
                    vehicle.isValid = false;
                }
            }
            return IItemVehicleInteractable.CallbackType.NONE;
        } else {
            player.sendPacket(new PacketPlayerChatMessage("interact.failure.vehicleowned"));
        }
        return IItemVehicleInteractable.CallbackType.NONE;
    }
}

