/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.mcinterface;

import java.util.Map;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.instances.ItemPart;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;

public interface IWrapperInventory {
    public int getSize();

    public IWrapperItemStack getStackInSlot(int var1);

    public AItemBase getItemInSlot(int var1);

    public void decrementSlot(int var1);

    public boolean hasItem(AItemBase var1);

    public boolean addStack(IWrapperItemStack var1);

    public boolean addItem(AItemBase var1, IWrapperNBT var2);

    public boolean removeStack(IWrapperItemStack var1, int var2);

    public boolean removeItem(AItemBase var1, IWrapperNBT var2);

    public boolean hasMaterials(AItemPack<?> var1, boolean var2, boolean var3);

    public void removeMaterials(AItemPack<?> var1, boolean var2, boolean var3);

    public float getInventoryWeight(Map<String, Double> var1);

    default public double getExplosiveness() {
        double explosivePower = 0.0;
        for (int i = 0; i < this.getSize(); ++i) {
            IWrapperItemStack stack = this.getStackInSlot(i);
            if (!(stack.getItem() instanceof ItemPart)) continue;
            ItemPart part = (ItemPart)stack.getItem();
            if (((JSONPart)part.definition).bullet == null) continue;
            explosivePower += (double)((float)stack.getSize() * ((JSONPart)part.definition).bullet.diameter) / 10.0;
        }
        return explosivePower;
    }
}

