/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.mcinterface;

import java.io.File;
import java.io.InputStreamReader;
import mcinterface1122.MasterInterface;
import minecrafttransportsimulator.items.instances.ItemJerrycan;
import minecrafttransportsimulator.items.instances.ItemJumperCable;
import minecrafttransportsimulator.items.instances.ItemKey;
import minecrafttransportsimulator.items.instances.ItemPaintGun;
import minecrafttransportsimulator.items.instances.ItemTicket;
import minecrafttransportsimulator.items.instances.ItemWrench;
import minecrafttransportsimulator.jsondefs.JSONPack;
import minecrafttransportsimulator.mcinterface.IInterfaceAudio;
import minecrafttransportsimulator.mcinterface.IInterfaceCore;
import minecrafttransportsimulator.mcinterface.IInterfaceGUI;
import minecrafttransportsimulator.mcinterface.IInterfaceGame;
import minecrafttransportsimulator.mcinterface.IInterfaceInput;
import minecrafttransportsimulator.mcinterface.IInterfaceNetwork;
import minecrafttransportsimulator.mcinterface.IInterfaceOGGDecoder;
import minecrafttransportsimulator.mcinterface.IInterfaceRender;
import minecrafttransportsimulator.packets.instances.PacketBulletHit;
import minecrafttransportsimulator.packets.instances.PacketEntityRiderChange;
import minecrafttransportsimulator.packets.instances.PacketFluidTankChange;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.packets.instances.PacketPlayerCraftItem;
import minecrafttransportsimulator.packets.instances.PacketRadioStateChange;
import minecrafttransportsimulator.packets.instances.PacketTileEntityFluidLoaderConnection;
import minecrafttransportsimulator.packets.instances.PacketTileEntityFuelPumpConnection;
import minecrafttransportsimulator.packets.instances.PacketTileEntityPoleChange;
import minecrafttransportsimulator.packets.instances.PacketTileEntitySignalControllerChange;
import minecrafttransportsimulator.packets.instances.PacketVehicleColorChange;
import minecrafttransportsimulator.packets.instances.PacketVehicleControlAnalog;
import minecrafttransportsimulator.packets.instances.PacketVehicleControlDigital;
import minecrafttransportsimulator.packets.instances.PacketVehicleInstruments;
import minecrafttransportsimulator.packets.instances.PacketVehicleInteract;
import minecrafttransportsimulator.packets.instances.PacketVehicleLightToggle;
import minecrafttransportsimulator.packets.instances.PacketVehiclePartChange;
import minecrafttransportsimulator.packets.instances.PacketVehiclePartEngine;
import minecrafttransportsimulator.packets.instances.PacketVehiclePartGroundDevice;
import minecrafttransportsimulator.packets.instances.PacketVehiclePartGun;
import minecrafttransportsimulator.packets.instances.PacketVehiclePartSeat;
import minecrafttransportsimulator.packets.instances.PacketVehicleServerMovement;
import minecrafttransportsimulator.packets.instances.PacketVehicleTextChange;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.PackParserSystem;

public class MasterLoader {
    public static final String MODID = "mts";
    public static final String MODNAME = "Minecraft Transport Simulator";
    public static final String MODVER = "19.5.0";
    public static String resourceDomain;
    public static IInterfaceAudio audioInterface;
    public static IInterfaceCore coreInterface;
    public static IInterfaceGame gameInterface;
    public static IInterfaceGUI guiInterface;
    public static IInterfaceInput inputInterface;
    public static IInterfaceNetwork networkInterface;
    public static IInterfaceOGGDecoder oggDecoderInterface;
    public static IInterfaceRender renderInterface;
    public static String gameDirectory;

    public static void setInterfaces(String resourceDomain, IInterfaceAudio audioInterface, IInterfaceCore coreInterface, IInterfaceGame gameInterface, IInterfaceGUI guiInterface, IInterfaceInput inputInterface, IInterfaceNetwork networkInterface, IInterfaceOGGDecoder oggDecoderInterface, IInterfaceRender renderInterface) {
        MasterLoader.resourceDomain = resourceDomain;
        MasterLoader.audioInterface = audioInterface;
        MasterLoader.coreInterface = coreInterface;
        MasterLoader.gameInterface = gameInterface;
        MasterLoader.guiInterface = guiInterface;
        MasterLoader.inputInterface = inputInterface;
        MasterLoader.networkInterface = networkInterface;
        MasterLoader.oggDecoderInterface = oggDecoderInterface;
        MasterLoader.renderInterface = renderInterface;
        MasterInterface.createItem(new ItemWrench());
        MasterInterface.createItem(new ItemKey());
        MasterInterface.createItem(new ItemJumperCable());
        MasterInterface.createItem(new ItemJerrycan());
        MasterInterface.createItem(new ItemPaintGun());
        MasterInterface.createItem(new ItemTicket());
        try {
            JSONPack packDef = new JSONPack();
            packDef.internallyGenerated = true;
            packDef.packID = resourceDomain;
            packDef.fileStructure = 0;
            packDef.packName = MasterLoader.coreInterface.getModName(resourceDomain);
            PackParserSystem.packMap.put(resourceDomain, packDef);
            PackParserSystem.addBookletDefinition(new InputStreamReader(MasterLoader.class.getResourceAsStream("/assets/" + resourceDomain + "/jsondefs/booklets/handbook_en.json"), "UTF-8"), "handbook_en", resourceDomain);
            PackParserSystem.addBookletDefinition(new InputStreamReader(MasterLoader.class.getResourceAsStream("/assets/" + resourceDomain + "/jsondefs/booklets/handbook_ru.json"), "UTF-8"), "handbook_ru", resourceDomain);
            PackParserSystem.addDecorDefinition(new InputStreamReader(MasterLoader.class.getResourceAsStream("/assets/" + resourceDomain + "/jsondefs/decors/fuelpump.json"), "UTF-8"), "fuelpump", resourceDomain);
            PackParserSystem.addDecorDefinition(new InputStreamReader(MasterLoader.class.getResourceAsStream("/assets/" + resourceDomain + "/jsondefs/decors/vehiclebench.json"), "UTF-8"), "vehiclebench", resourceDomain);
            PackParserSystem.addDecorDefinition(new InputStreamReader(MasterLoader.class.getResourceAsStream("/assets/" + resourceDomain + "/jsondefs/decors/enginebench.json"), "UTF-8"), "enginebench", resourceDomain);
            PackParserSystem.addDecorDefinition(new InputStreamReader(MasterLoader.class.getResourceAsStream("/assets/" + resourceDomain + "/jsondefs/decors/propellerbench.json"), "UTF-8"), "propellerbench", resourceDomain);
            PackParserSystem.addDecorDefinition(new InputStreamReader(MasterLoader.class.getResourceAsStream("/assets/" + resourceDomain + "/jsondefs/decors/wheelbench.json"), "UTF-8"), "wheelbench", resourceDomain);
            PackParserSystem.addDecorDefinition(new InputStreamReader(MasterLoader.class.getResourceAsStream("/assets/" + resourceDomain + "/jsondefs/decors/seatbench.json"), "UTF-8"), "seatbench", resourceDomain);
            PackParserSystem.addDecorDefinition(new InputStreamReader(MasterLoader.class.getResourceAsStream("/assets/" + resourceDomain + "/jsondefs/decors/gunbench.json"), "UTF-8"), "gunbench", resourceDomain);
            PackParserSystem.addDecorDefinition(new InputStreamReader(MasterLoader.class.getResourceAsStream("/assets/" + resourceDomain + "/jsondefs/decors/custombench.json"), "UTF-8"), "custombench", resourceDomain);
            PackParserSystem.addDecorDefinition(new InputStreamReader(MasterLoader.class.getResourceAsStream("/assets/" + resourceDomain + "/jsondefs/decors/instrumentbench.json"), "UTF-8"), "instrumentbench", resourceDomain);
            PackParserSystem.addDecorDefinition(new InputStreamReader(MasterLoader.class.getResourceAsStream("/assets/" + resourceDomain + "/jsondefs/decors/decorbench.json"), "UTF-8"), "decorbench", resourceDomain);
            PackParserSystem.addDecorDefinition(new InputStreamReader(MasterLoader.class.getResourceAsStream("/assets/" + resourceDomain + "/jsondefs/decors/itembench.json"), "UTF-8"), "itembench", resourceDomain);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setMainDirectory(String directory) {
        gameDirectory = directory;
        ConfigSystem.loadFromDisk(new File(directory, "config"));
        File modDirectory = new File(directory, "mods");
        if (modDirectory.exists()) {
            for (File file : modDirectory.listFiles()) {
                if (!file.getName().endsWith(".jar")) continue;
                PackParserSystem.checkJarForPacks(file);
            }
            if ((modDirectory = new File(modDirectory, coreInterface.getGameVersion())).exists()) {
                for (File file : modDirectory.listFiles()) {
                    if (!file.getName().endsWith(".jar")) continue;
                    PackParserSystem.checkJarForPacks(file);
                }
            }
        } else {
            coreInterface.logError("ERROR: Could not find mods directory!  Game directory is confirmed to: " + gameDirectory);
        }
        PackParserSystem.parseAllPacks();
    }

    public static void registerPackets(byte packetIndex) {
        byte by = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        networkInterface.registerPacket(by, PacketBulletHit.class);
        byte by2 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        networkInterface.registerPacket(by2, PacketEntityRiderChange.class);
        byte by3 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        networkInterface.registerPacket(by3, PacketFluidTankChange.class);
        byte by4 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        networkInterface.registerPacket(by4, PacketPlayerChatMessage.class);
        byte by5 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        networkInterface.registerPacket(by5, PacketPlayerCraftItem.class);
        byte by6 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        networkInterface.registerPacket(by6, PacketRadioStateChange.class);
        byte by7 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        networkInterface.registerPacket(by7, PacketTileEntityFluidLoaderConnection.class);
        byte by8 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        networkInterface.registerPacket(by8, PacketTileEntityFuelPumpConnection.class);
        byte by9 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        networkInterface.registerPacket(by9, PacketTileEntityPoleChange.class);
        byte by10 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        networkInterface.registerPacket(by10, PacketTileEntitySignalControllerChange.class);
        byte by11 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        networkInterface.registerPacket(by11, PacketVehicleColorChange.class);
        byte by12 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        networkInterface.registerPacket(by12, PacketVehicleControlAnalog.class);
        byte by13 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        networkInterface.registerPacket(by13, PacketVehicleControlDigital.class);
        byte by14 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        networkInterface.registerPacket(by14, PacketVehicleInstruments.class);
        byte by15 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        networkInterface.registerPacket(by15, PacketVehicleInteract.class);
        byte by16 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        networkInterface.registerPacket(by16, PacketVehicleLightToggle.class);
        byte by17 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        networkInterface.registerPacket(by17, PacketVehiclePartChange.class);
        byte by18 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        networkInterface.registerPacket(by18, PacketVehiclePartEngine.class);
        byte by19 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        networkInterface.registerPacket(by19, PacketVehiclePartGroundDevice.class);
        byte by20 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        networkInterface.registerPacket(by20, PacketVehiclePartGun.class);
        byte by21 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        networkInterface.registerPacket(by21, PacketVehiclePartSeat.class);
        byte by22 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        networkInterface.registerPacket(by22, PacketVehicleServerMovement.class);
        byte by23 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        networkInterface.registerPacket(by23, PacketVehicleTextChange.class);
    }
}

