/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.components;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.mcinterface.MasterLoader;

public abstract class APacketBase {
    public APacketBase(ByteBuf buf) {
    }

    public void writeToBuffer(ByteBuf buf) {
        buf.writeByte((int)MasterLoader.networkInterface.getPacketIndex(this));
    }

    public abstract void handle(IWrapperWorld var1, IWrapperPlayer var2);

    protected static void writeStringToBuffer(String string, ByteBuf buf) {
        byte[] stringAsBytes = string.getBytes(StandardCharsets.UTF_8);
        if (stringAsBytes.length > Short.MAX_VALUE) {
            throw new IndexOutOfBoundsException("ERROR: Tried to write a string of: " + stringAsBytes.length + " bytes to a packet.  Max string byte size is: " + Short.MAX_VALUE);
        }
        buf.writeShort(stringAsBytes.length);
        buf.writeBytes(stringAsBytes);
    }

    protected static String readStringFromBuffer(ByteBuf buf) {
        short stringLength = buf.readShort();
        String returnString = buf.toString(buf.readerIndex(), (int)stringLength, StandardCharsets.UTF_8);
        buf.readerIndex(buf.readerIndex() + stringLength);
        return returnString;
    }

    protected static void writePoint3dToBuffer(Point3d point, ByteBuf buf) {
        buf.writeDouble(point.x);
        buf.writeDouble(point.y);
        buf.writeDouble(point.z);
    }

    protected static Point3d readPoint3dFromBuffer(ByteBuf buf) {
        return new Point3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }
}

