/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.components;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.components.APacketBase;
import minecrafttransportsimulator.vehicles.main.AEntityBase;

public abstract class APacketEntity
extends APacketBase {
    private final int entityID;

    public APacketEntity(AEntityBase entity) {
        super(null);
        this.entityID = entity.lookupID;
    }

    public APacketEntity(ByteBuf buf) {
        super(buf);
        this.entityID = buf.readInt();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeInt(this.entityID);
    }

    @Override
    public void handle(IWrapperWorld world, IWrapperPlayer player) {
        boolean sendReturnPacket = false;
        for (AEntityBase entity : world.isClient() ? AEntityBase.createdClientEntities : AEntityBase.createdServerEntities) {
            if (entity.lookupID != this.entityID || !this.handle(world, player, entity) || world.isClient()) continue;
            sendReturnPacket = true;
        }
        if (sendReturnPacket) {
            MasterLoader.networkInterface.sendToAllClients(this);
        }
    }

    protected abstract boolean handle(IWrapperWorld var1, IWrapperPlayer var2, AEntityBase var3);
}

