/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.components;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.baseclasses.Point3i;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.components.APacketBase;

public abstract class APacketTileEntity<TileEntityType extends ATileEntityBase<?>>
extends APacketBase {
    private final Point3i position;

    public APacketTileEntity(TileEntityType tile) {
        super(null);
        this.position = ((ATileEntityBase)tile).position;
    }

    public APacketTileEntity(ByteBuf buf) {
        super(buf);
        this.position = new Point3i(buf.readInt(), buf.readInt(), buf.readInt());
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeInt(this.position.x);
        buf.writeInt(this.position.y);
        buf.writeInt(this.position.z);
    }

    @Override
    public void handle(IWrapperWorld world, IWrapperPlayer player) {
        Object tile = world.getTileEntity(this.position);
        if (tile != null && ((ATileEntityBase)tile).world != null && this.handle(world, player, tile) && !world.isClient()) {
            world.markTileEntityChanged(this.position);
            MasterLoader.networkInterface.sendToAllClients(this);
        }
    }

    protected abstract boolean handle(IWrapperWorld var1, IWrapperPlayer var2, TileEntityType var3);
}

