/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.baseclasses.Point3i;
import minecrafttransportsimulator.items.instances.ItemPart;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.mcinterface.IWrapperBlock;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.components.APacketVehiclePart;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.PartGun;

public class PacketBulletHit
extends APacketVehiclePart {
    private final Point3d localCenter;
    private final Point3d globalCenter;
    private final double bulletVelocity;
    private final ItemPart bullet;
    private final int gunNumber;
    private final int bulletNumber;
    private final int hitEntityID;
    private final int controllerEntityID;

    public PacketBulletHit(BoundingBox box, double velocity, ItemPart bullet, PartGun gun, int bulletNumber, IWrapperEntity hitEntity, IWrapperEntity controllerEntity) {
        super(gun.vehicle, gun.placementOffset);
        this.localCenter = box.localCenter;
        this.globalCenter = box.globalCenter;
        this.bulletVelocity = velocity;
        this.bullet = bullet;
        this.gunNumber = gun.gunNumber;
        this.bulletNumber = bulletNumber;
        this.hitEntityID = hitEntity != null ? hitEntity.getID() : -1;
        this.controllerEntityID = controllerEntity != null ? controllerEntity.getID() : -1;
    }

    public PacketBulletHit(ByteBuf buf) {
        super(buf);
        this.localCenter = PacketBulletHit.readPoint3dFromBuffer(buf);
        this.globalCenter = PacketBulletHit.readPoint3dFromBuffer(buf);
        this.bulletVelocity = buf.readDouble();
        this.bullet = (ItemPart)PackParserSystem.getItem(PacketBulletHit.readStringFromBuffer(buf), PacketBulletHit.readStringFromBuffer(buf), PacketBulletHit.readStringFromBuffer(buf));
        this.gunNumber = buf.readInt();
        this.bulletNumber = buf.readInt();
        this.hitEntityID = buf.readInt();
        this.controllerEntityID = buf.readInt();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        PacketBulletHit.writePoint3dToBuffer(this.localCenter, buf);
        PacketBulletHit.writePoint3dToBuffer(this.globalCenter, buf);
        buf.writeDouble(this.bulletVelocity);
        PacketBulletHit.writeStringToBuffer(((JSONPart)this.bullet.definition).packID, buf);
        PacketBulletHit.writeStringToBuffer(((JSONPart)this.bullet.definition).systemName, buf);
        PacketBulletHit.writeStringToBuffer(this.bullet.subName, buf);
        buf.writeInt(this.gunNumber);
        buf.writeInt(this.bulletNumber);
        buf.writeInt(this.hitEntityID);
        buf.writeInt(this.controllerEntityID);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean handle(IWrapperWorld world, IWrapperPlayer player, EntityVehicleF_Physics vehicle, Point3d offset) {
        if (!world.isClient()) {
            JSONPart bulletDefinition = (JSONPart)this.bullet.definition;
            BoundingBox box = new BoundingBox(this.localCenter, this.globalCenter, bulletDefinition.bullet.diameter / 1000.0f, bulletDefinition.bullet.diameter / 1000.0f, bulletDefinition.bullet.diameter / 1000.0f, false, false, false, 0.0);
            PartGun gun = (PartGun)vehicle.getPartAtLocation(offset);
            if (gun.bulletsHitOnServer.contains(this.bulletNumber)) return false;
            gun.bulletsHitOnServer.add(this.bulletNumber);
            if (bulletDefinition.bullet.type.equals("explosive")) {
                world.spawnExplosion(vehicle, box.globalCenter, (double)(bulletDefinition.bullet.diameter / 10.0f), false);
                return false;
            } else if (this.hitEntityID != -1) {
                IWrapperEntity entityHit = world.getEntity(this.hitEntityID);
                if (entityHit == null) return false;
                IWrapperEntity attacker = world.getEntity(this.controllerEntityID);
                double damageAmount = this.bulletVelocity * (double)bulletDefinition.bullet.diameter / 5.0 * (Double)ConfigSystem.configObject.damage.bulletDamageFactor.value;
                Damage damage = new Damage("bullet", damageAmount, box, attacker).ignoreCooldown();
                if (bulletDefinition.bullet.type.equals("water")) {
                    damage.isWater = true;
                }
                if (bulletDefinition.bullet.type.equals("incendiary")) {
                    damage.isFire = true;
                }
                if (bulletDefinition.bullet.type.equals("armor_piercing")) {
                    damage.ignoreArmor = true;
                }
                entityHit.attack(damage);
                return false;
            } else {
                Point3i hitPosition = new Point3i(box.globalCenter);
                if (bulletDefinition.bullet.type.equals("water")) {
                    hitPosition.add(0, 1, 0);
                    if (!world.isFire(hitPosition)) return false;
                    world.destroyBlock(hitPosition);
                    return false;
                } else {
                    IWrapperBlock hitBlock = world.getWrapperBlock(hitPosition);
                    if (hitBlock.getHardness() > 0.0f && (double)hitBlock.getHardness() <= Math.random() * (double)0.3f + (double)(0.3f * bulletDefinition.bullet.diameter / 20.0f)) {
                        world.destroyBlock(hitPosition);
                        return false;
                    } else {
                        if (!bulletDefinition.bullet.type.equals("incendiary")) return true;
                        hitPosition.add(0, 1, 0);
                        if (!world.isAir(hitPosition)) return false;
                        world.setToFire(hitPosition);
                    }
                }
            }
            return false;
        } else {
            MasterLoader.renderInterface.spawnBlockBreakParticles(new Point3i(this.globalCenter));
        }
        return false;
    }
}

