/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;
import minecrafttransportsimulator.vehicles.main.AEntityBase;

public class PacketEntityRiderChange
extends APacketEntity {
    private final int riderID;
    private final Point3d position;

    public PacketEntityRiderChange(AEntityBase entity, IWrapperEntity rider, Point3d position) {
        super(entity);
        this.riderID = rider.getID();
        this.position = position;
    }

    public PacketEntityRiderChange(ByteBuf buf) {
        super(buf);
        this.riderID = buf.readInt();
        this.position = buf.readBoolean() ? PacketEntityRiderChange.readPoint3dFromBuffer(buf) : null;
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeInt(this.riderID);
        buf.writeBoolean(this.position != null);
        if (this.position != null) {
            PacketEntityRiderChange.writePoint3dToBuffer(this.position, buf);
        }
    }

    @Override
    protected boolean handle(IWrapperWorld world, IWrapperPlayer player, AEntityBase entity) {
        if (this.position != null) {
            entity.addRider(world.getEntity(this.riderID), this.position);
        } else {
            entity.removeRider(world.getEntity(this.riderID), null);
        }
        return true;
    }
}

