/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.baseclasses.FluidTank;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketBase;

public class PacketFluidTankChange
extends APacketBase {
    private final int tankID;
    private final String fluidName;
    private final double fluidDelta;

    public PacketFluidTankChange(FluidTank tank, double fluidDelta) {
        super(null);
        this.tankID = tank.tankID;
        this.fluidName = tank.getFluid();
        this.fluidDelta = fluidDelta;
    }

    public PacketFluidTankChange(ByteBuf buf) {
        super(buf);
        this.tankID = buf.readInt();
        this.fluidName = PacketFluidTankChange.readStringFromBuffer(buf);
        this.fluidDelta = buf.readDouble();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeInt(this.tankID);
        PacketFluidTankChange.writeStringToBuffer(this.fluidName, buf);
        buf.writeDouble(this.fluidDelta);
    }

    @Override
    public void handle(IWrapperWorld world, IWrapperPlayer player) {
        FluidTank tank = FluidTank.createdClientTanks.get(this.tankID);
        if (tank != null) {
            if (this.fluidDelta < 0.0) {
                tank.drain(this.fluidName, -this.fluidDelta, true);
            } else {
                tank.fill(this.fluidName, this.fluidDelta, true);
            }
        }
    }
}

