/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.mcinterface.IWrapperInventory;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketBase;
import minecrafttransportsimulator.systems.PackParserSystem;

public class PacketPlayerCraftItem
extends APacketBase {
    private final AItemPack<?> itemToCraft;

    public PacketPlayerCraftItem(AItemPack<?> itemToCraft) {
        super(null);
        this.itemToCraft = itemToCraft;
    }

    public PacketPlayerCraftItem(ByteBuf buf) {
        super(buf);
        this.itemToCraft = PackParserSystem.getItem(PacketPlayerCraftItem.readStringFromBuffer(buf), PacketPlayerCraftItem.readStringFromBuffer(buf));
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        PacketPlayerCraftItem.writeStringToBuffer(((AJSONItem)this.itemToCraft.definition).packID, buf);
        if (this.itemToCraft instanceof AItemSubTyped) {
            PacketPlayerCraftItem.writeStringToBuffer(((AJSONItem)this.itemToCraft.definition).systemName + ((AItemSubTyped)this.itemToCraft).subName, buf);
        } else {
            PacketPlayerCraftItem.writeStringToBuffer(((AJSONItem)this.itemToCraft.definition).systemName, buf);
        }
    }

    @Override
    public void handle(IWrapperWorld world, IWrapperPlayer player) {
        IWrapperInventory inventory = player.getInventory();
        if (player.isCreative() || inventory.hasMaterials(this.itemToCraft, true, true)) {
            if (!player.isCreative()) {
                inventory.removeMaterials(this.itemToCraft, true, true);
            }
            inventory.addItem(this.itemToCraft, null);
        }
    }
}

