/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketBase;
import minecrafttransportsimulator.sound.Radio;
import minecrafttransportsimulator.sound.RadioManager;

public class PacketRadioStateChange
extends APacketBase {
    private final int radioID;
    private final RadioManager.RadioSources source;
    private final int volume;
    private final int preset;

    public PacketRadioStateChange(Radio radio, RadioManager.RadioSources source, int volume, int preset) {
        super(null);
        this.radioID = radio.radioID;
        this.source = source;
        this.volume = volume;
        this.preset = preset;
    }

    public PacketRadioStateChange(ByteBuf buf) {
        super(buf);
        this.radioID = buf.readInt();
        this.source = RadioManager.RadioSources.values()[buf.readByte()];
        this.volume = buf.readByte();
        this.preset = buf.readByte();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeInt(this.radioID);
        buf.writeByte(this.source.ordinal());
        buf.writeByte(this.volume);
        buf.writeByte(this.preset);
    }

    @Override
    public void handle(IWrapperWorld world, IWrapperPlayer player) {
        Radio radio;
        Radio radio2 = radio = world.isClient() ? Radio.createdClientRadios.get(this.radioID) : Radio.createdServerRadios.get(this.radioID);
        if (radio != null) {
            if (world.isClient()) {
                if (!radio.getSource().equals((Object)this.source)) {
                    radio.changeSource(this.source, false);
                }
                if (radio.volume != this.volume) {
                    radio.changeVolume(this.volume, false);
                }
                if (radio.preset != this.preset) {
                    radio.pressPreset(this.preset, false);
                }
            } else {
                radio.setProperties(this.source, this.volume, this.preset);
            }
        }
    }
}

