/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityFluidLoader;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketTileEntity;
import minecrafttransportsimulator.vehicles.main.AEntityBase;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.PartInteractable;

public class PacketTileEntityFluidLoaderConnection
extends APacketTileEntity<TileEntityFluidLoader> {
    private final int vehicleID;
    private final Point3d partOffset;
    private final boolean connect;

    public PacketTileEntityFluidLoaderConnection(TileEntityFluidLoader loader, boolean connect) {
        super(loader);
        this.vehicleID = loader.connectedPart.vehicle.lookupID;
        this.partOffset = loader.connectedPart.placementOffset;
        this.connect = connect;
    }

    public PacketTileEntityFluidLoaderConnection(ByteBuf buf) {
        super(buf);
        this.vehicleID = buf.readInt();
        this.partOffset = PacketTileEntityFluidLoaderConnection.readPoint3dFromBuffer(buf);
        this.connect = buf.readBoolean();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeInt(this.vehicleID);
        buf.writeBoolean(this.connect);
        PacketTileEntityFluidLoaderConnection.writePoint3dToBuffer(this.partOffset, buf);
    }

    @Override
    protected boolean handle(IWrapperWorld world, IWrapperPlayer player, TileEntityFluidLoader loader) {
        for (AEntityBase entity : AEntityBase.createdClientEntities) {
            if (entity.lookupID != this.vehicleID) continue;
            EntityVehicleF_Physics vehicle = (EntityVehicleF_Physics)entity;
            if (this.connect) {
                loader.connectedPart = (PartInteractable)vehicle.getPartAtLocation(this.partOffset);
                loader.getTank().resetAmountDispensed();
            } else {
                loader.connectedPart = null;
            }
            return true;
        }
        return true;
    }
}

