/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityFuelPump;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketTileEntity;
import minecrafttransportsimulator.vehicles.main.AEntityBase;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;

public class PacketTileEntityFuelPumpConnection
extends APacketTileEntity<TileEntityFuelPump> {
    private final int vehicleID;
    private final boolean connect;

    public PacketTileEntityFuelPumpConnection(TileEntityFuelPump pump, boolean connect) {
        super(pump);
        this.vehicleID = pump.connectedVehicle.lookupID;
        this.connect = connect;
    }

    public PacketTileEntityFuelPumpConnection(ByteBuf buf) {
        super(buf);
        this.vehicleID = buf.readInt();
        this.connect = buf.readBoolean();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeInt(this.vehicleID);
        buf.writeBoolean(this.connect);
    }

    @Override
    protected boolean handle(IWrapperWorld world, IWrapperPlayer player, TileEntityFuelPump pump) {
        for (AEntityBase entity : AEntityBase.createdClientEntities) {
            if (entity.lookupID != this.vehicleID) continue;
            EntityVehicleF_Physics vehicle = (EntityVehicleF_Physics)entity;
            if (this.connect) {
                pump.connectedVehicle = vehicle;
                vehicle.beingFueled = true;
                pump.getTank().resetAmountDispensed();
            } else {
                vehicle.beingFueled = false;
                pump.connectedVehicle = null;
            }
            return true;
        }
        return true;
    }
}

