/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityPole_Component;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole;
import minecrafttransportsimulator.guis.instances.GUITextEditor;
import minecrafttransportsimulator.items.instances.ItemPoleComponent;
import minecrafttransportsimulator.jsondefs.JSONPoleComponent;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.components.APacketTileEntity;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.PackParserSystem;

public class PacketTileEntityPoleChange
extends APacketTileEntity<TileEntityPole> {
    private final ABlockBase.Axis axis;
    private final ItemPoleComponent componentItem;
    private final List<String> textLines;
    private final boolean removal;

    public PacketTileEntityPoleChange(TileEntityPole pole, ABlockBase.Axis axis, ItemPoleComponent componentItem, List<String> textLines, boolean removal) {
        super(pole);
        this.axis = axis;
        this.componentItem = componentItem;
        this.textLines = textLines;
        this.removal = removal;
    }

    public PacketTileEntityPoleChange(ByteBuf buf) {
        super(buf);
        this.axis = ABlockBase.Axis.values()[buf.readByte()];
        this.componentItem = buf.readBoolean() ? (ItemPoleComponent)PackParserSystem.getItem(PacketTileEntityPoleChange.readStringFromBuffer(buf), PacketTileEntityPoleChange.readStringFromBuffer(buf)) : null;
        if (buf.readBoolean()) {
            byte textLineCount = buf.readByte();
            this.textLines = new ArrayList<String>();
            for (byte i = 0; i < textLineCount; i = (byte)(i + 1)) {
                this.textLines.add(PacketTileEntityPoleChange.readStringFromBuffer(buf));
            }
        } else {
            this.textLines = null;
        }
        this.removal = buf.readBoolean();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeByte(this.axis.ordinal());
        if (this.componentItem != null) {
            buf.writeBoolean(true);
            PacketTileEntityPoleChange.writeStringToBuffer(((JSONPoleComponent)this.componentItem.definition).packID, buf);
            PacketTileEntityPoleChange.writeStringToBuffer(((JSONPoleComponent)this.componentItem.definition).systemName, buf);
        } else {
            buf.writeBoolean(false);
        }
        if (this.textLines != null) {
            buf.writeBoolean(true);
            buf.writeByte(this.textLines.size());
            for (String textLine : this.textLines) {
                PacketTileEntityPoleChange.writeStringToBuffer(textLine, buf);
            }
        } else {
            buf.writeBoolean(false);
        }
        buf.writeBoolean(this.removal);
    }

    @Override
    protected boolean handle(IWrapperWorld world, IWrapperPlayer player, TileEntityPole pole) {
        if (world.isClient() || !((Boolean)ConfigSystem.configObject.general.opSignEditingOnly.value).booleanValue() || player.isOP()) {
            if (this.removal) {
                if (pole.components.containsKey((Object)this.axis)) {
                    ATileEntityPole_Component component = pole.components.get((Object)this.axis);
                    IWrapperNBT data = null;
                    if (component.getTextLines() != null) {
                        data = MasterLoader.coreInterface.createNewTag();
                        data.setStrings("textLines", component.getTextLines());
                    }
                    if (world.isClient() || player.isCreative() || player.getInventory().addItem(component.item, data)) {
                        pole.components.remove((Object)this.axis);
                        pole.updateLightState();
                        return true;
                    }
                }
            } else if (this.componentItem == null && this.textLines == null) {
                if (pole.components.get((Object)this.axis).getTextLines() != null) {
                    if (world.isClient()) {
                        MasterLoader.guiInterface.openGUI(new GUITextEditor(pole, this.axis));
                    } else {
                        player.sendPacket(new PacketTileEntityPoleChange(pole, this.axis, null, null, false));
                    }
                }
                return false;
            }
            if (this.componentItem == null && this.textLines != null) {
                if (pole.components.containsKey((Object)this.axis)) {
                    pole.components.get((Object)this.axis).setTextLines(this.textLines);
                    return true;
                }
            } else if (this.componentItem != null && !pole.components.containsKey((Object)this.axis)) {
                ATileEntityPole_Component newComponent = TileEntityPole.createComponent(this.componentItem);
                pole.components.put(this.axis, newComponent);
                if (this.textLines != null && newComponent.getTextLines() != null) {
                    newComponent.setTextLines(this.textLines);
                }
                pole.updateLightState();
                if (!player.isCreative()) {
                    player.getInventory().removeStack(player.getHeldStack(), 1);
                }
                return true;
            }
        }
        return false;
    }
}

