/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.baseclasses.Point3i;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntitySignalController;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketTileEntity;

public class PacketTileEntitySignalControllerChange
extends APacketTileEntity<TileEntitySignalController> {
    private final TileEntitySignalController.OpMode currentOpMode;
    private final boolean mainDirectionXAxis;
    private final short greenMainTime;
    private final short greenCrossTime;
    private final short yellowMainTime;
    private final short yellowCrossTime;
    private final short allRedTime;
    private final List<Point3i> componentLocations;

    public PacketTileEntitySignalControllerChange(TileEntitySignalController controller) {
        super(controller);
        this.currentOpMode = controller.currentOpMode;
        this.mainDirectionXAxis = controller.mainDirectionXAxis;
        this.greenMainTime = (short)controller.greenMainTime;
        this.greenCrossTime = (short)controller.greenCrossTime;
        this.yellowMainTime = (short)controller.yellowMainTime;
        this.yellowCrossTime = (short)controller.yellowCrossTime;
        this.allRedTime = (short)controller.allRedTime;
        this.componentLocations = controller.componentLocations;
    }

    public PacketTileEntitySignalControllerChange(ByteBuf buf) {
        super(buf);
        this.currentOpMode = TileEntitySignalController.OpMode.values()[buf.readByte()];
        this.mainDirectionXAxis = buf.readBoolean();
        this.greenMainTime = buf.readShort();
        this.greenCrossTime = buf.readShort();
        this.yellowMainTime = buf.readShort();
        this.yellowCrossTime = buf.readShort();
        this.allRedTime = buf.readShort();
        byte components = buf.readByte();
        this.componentLocations = new ArrayList<Point3i>();
        for (byte i = 0; i < components; i = (byte)(i + 1)) {
            this.componentLocations.add(new Point3i(buf.readInt(), buf.readInt(), buf.readInt()));
        }
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeByte(this.currentOpMode.ordinal());
        buf.writeBoolean(this.mainDirectionXAxis);
        buf.writeShort((int)this.greenMainTime);
        buf.writeShort((int)this.greenCrossTime);
        buf.writeShort((int)this.yellowMainTime);
        buf.writeShort((int)this.yellowCrossTime);
        buf.writeShort((int)this.allRedTime);
        buf.writeByte(this.componentLocations.size());
        for (Point3i componentLocation : this.componentLocations) {
            buf.writeInt(componentLocation.x);
            buf.writeInt(componentLocation.y);
            buf.writeInt(componentLocation.z);
        }
    }

    @Override
    protected boolean handle(IWrapperWorld world, IWrapperPlayer player, TileEntitySignalController controller) {
        controller.currentOpMode = this.currentOpMode;
        controller.mainDirectionXAxis = this.mainDirectionXAxis;
        controller.greenMainTime = this.greenMainTime;
        controller.greenCrossTime = this.greenCrossTime;
        controller.yellowMainTime = this.yellowMainTime;
        controller.yellowCrossTime = this.yellowCrossTime;
        controller.allRedTime = this.allRedTime;
        controller.componentLocations.clear();
        controller.componentLocations.addAll(this.componentLocations);
        controller.updateState(TileEntitySignalController.OpState.GREEN_MAIN_RED_CROSS, true);
        return true;
    }
}

