/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.items.instances.ItemVehicle;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperInventory;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketVehicle;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;

public class PacketVehicleColorChange
extends APacketVehicle {
    private final ItemVehicle newVehicleItem;

    public PacketVehicleColorChange(EntityVehicleF_Physics vehicle, ItemVehicle newVehicleItem) {
        super(vehicle);
        this.newVehicleItem = newVehicleItem;
    }

    public PacketVehicleColorChange(ByteBuf buf) {
        super(buf);
        this.newVehicleItem = (ItemVehicle)PackParserSystem.getItem(PacketVehicleColorChange.readStringFromBuffer(buf), PacketVehicleColorChange.readStringFromBuffer(buf), PacketVehicleColorChange.readStringFromBuffer(buf));
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        PacketVehicleColorChange.writeStringToBuffer(((JSONVehicle)this.newVehicleItem.definition).packID, buf);
        PacketVehicleColorChange.writeStringToBuffer(((JSONVehicle)this.newVehicleItem.definition).systemName, buf);
        PacketVehicleColorChange.writeStringToBuffer(this.newVehicleItem.subName, buf);
    }

    @Override
    public boolean handle(IWrapperWorld world, IWrapperPlayer player, EntityVehicleF_Physics vehicle) {
        IWrapperInventory inventory = player.getInventory();
        if (player.isCreative() || inventory.hasMaterials(this.newVehicleItem, false, true)) {
            if (!player.isCreative()) {
                inventory.removeMaterials(this.newVehicleItem, false, true);
            }
            vehicle.currentSubName = this.newVehicleItem.subName;
            String secondTone = null;
            for (AJSONMultiModelProvider.SubDefinition subDefinition : vehicle.definition.definitions) {
                if (!subDefinition.subName.equals(vehicle.currentSubName)) continue;
                secondTone = subDefinition.secondTone;
            }
            if (secondTone != null) {
                block1: for (APart part : vehicle.parts) {
                    for (AJSONMultiModelProvider.SubDefinition subDefinition : part.definition.definitions) {
                        if (!subDefinition.subName.equals(secondTone)) continue;
                        part.currentSubName = secondTone;
                        continue block1;
                    }
                }
            }
            return true;
        }
        return false;
    }
}

