/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketVehicle;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;

public class PacketVehicleControlAnalog
extends APacketVehicle {
    private final Controls controlType;
    private final short value;
    private final byte cooldown;

    public PacketVehicleControlAnalog(EntityVehicleF_Physics vehicle, Controls controlType, short value, byte cooldown) {
        super(vehicle);
        this.controlType = controlType;
        this.value = value;
        this.cooldown = cooldown;
    }

    public PacketVehicleControlAnalog(ByteBuf buf) {
        super(buf);
        this.controlType = Controls.values()[buf.readByte()];
        this.value = buf.readShort();
        this.cooldown = buf.readByte();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeByte(this.controlType.ordinal());
        buf.writeShort((int)this.value);
        buf.writeByte((int)this.cooldown);
    }

    @Override
    protected boolean handle(IWrapperWorld world, IWrapperPlayer player, EntityVehicleF_Physics vehicle) {
        switch (this.controlType) {
            case THROTTLE: {
                vehicle.throttle = (byte)PacketVehicleControlAnalog.clampAngle(0, 100, this.cooldown == 127 ? this.value : vehicle.throttle + this.value);
                break;
            }
            case AILERON: {
                vehicle.aileronAngle = (short)PacketVehicleControlAnalog.clampAngle(-250, 250, this.cooldown == 127 ? this.value : vehicle.aileronAngle + this.value);
                vehicle.aileronCooldown = this.cooldown;
                break;
            }
            case ELEVATOR: {
                vehicle.elevatorAngle = (short)PacketVehicleControlAnalog.clampAngle(-250, 250, this.cooldown == 127 ? this.value : vehicle.elevatorAngle + this.value);
                vehicle.elevatorCooldown = this.cooldown;
                break;
            }
            case RUDDER: {
                vehicle.rudderAngle = (short)PacketVehicleControlAnalog.clampAngle(-450, 450, this.cooldown == 127 ? this.value : vehicle.rudderAngle + this.value);
                vehicle.rudderCooldown = this.cooldown;
            }
        }
        return true;
    }

    public static enum Controls {
        THROTTLE,
        AILERON,
        ELEVATOR,
        RUDDER;

    }
}

