/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.components.APacketVehicle;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.sound.SoundInstance;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.PartEngine;

public class PacketVehicleControlDigital
extends APacketVehicle {
    private final Controls controlType;
    private final boolean controlState;

    public PacketVehicleControlDigital(EntityVehicleF_Physics vehicle, Controls controlType, boolean controlState) {
        super(vehicle);
        this.controlType = controlType;
        this.controlState = controlState;
    }

    public PacketVehicleControlDigital(ByteBuf buf) {
        super(buf);
        this.controlType = Controls.values()[buf.readByte()];
        this.controlState = buf.readBoolean();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeByte(this.controlType.ordinal());
        buf.writeBoolean(this.controlState);
    }

    @Override
    protected boolean handle(IWrapperWorld world, IWrapperPlayer player, EntityVehicleF_Physics vehicle) {
        switch (this.controlType) {
            case BRAKE: {
                vehicle.brakeOn = this.controlState;
                break;
            }
            case P_BRAKE: {
                if (world.isClient() && !vehicle.parkingBrakeOn && this.controlState && vehicle.definition.motorized.isBigTruck) {
                    MasterLoader.audioInterface.playQuickSound(new SoundInstance(vehicle, MasterLoader.resourceDomain + ":air_brake_activating"));
                }
                vehicle.parkingBrakeOn = this.controlState;
                break;
            }
            case HORN: {
                if (world.isClient() && !vehicle.hornOn && this.controlState) {
                    MasterLoader.audioInterface.playQuickSound(new SoundInstance(vehicle, vehicle.definition.motorized.hornSound, true));
                }
                vehicle.hornOn = this.controlState;
                break;
            }
            case SIREN: {
                if (world.isClient() && !vehicle.sirenOn && this.controlState) {
                    MasterLoader.audioInterface.playQuickSound(new SoundInstance(vehicle, vehicle.definition.motorized.sirenSound, true));
                }
                vehicle.sirenOn = this.controlState;
                break;
            }
            case TRAILER: {
                if (vehicle.towedVehicle != null) {
                    vehicle.towedVehicle.towedByVehicle = null;
                    vehicle.towedVehicle = null;
                    if (!world.isClient()) {
                        player.sendPacket(new PacketPlayerChatMessage("interact.trailer.disconnect"));
                        return true;
                    }
                } else {
                    if (vehicle.definition.motorized.hitchPos != null) {
                        player.sendPacket(new PacketPlayerChatMessage("This functionality has been disabled for this release.  Please check back later."));
                        return false;
                    }
                    if (!world.isClient()) {
                        player.sendPacket(new PacketPlayerChatMessage("interact.trailer.nohitch"));
                    }
                }
                return false;
            }
            case SHIFT_UP: {
                for (PartEngine engine : vehicle.engines.values()) {
                    engine.shiftUp(this.controlState);
                }
                return false;
            }
            case SHIFT_DN: {
                for (PartEngine engine : vehicle.engines.values()) {
                    engine.shiftDown(this.controlState);
                }
                return false;
            }
            case REVERSE: {
                if (((JSONVehicle.VehicleGeneral)vehicle.definition.general).isBlimp) {
                    for (PartEngine engine : vehicle.engines.values()) {
                        if (this.controlState) {
                            engine.shiftDown(false);
                            engine.shiftDown(false);
                            continue;
                        }
                        engine.shiftUp(false);
                        engine.shiftUp(false);
                    }
                    break;
                }
                vehicle.reverseThrust = this.controlState;
                break;
            }
            case GEAR: {
                vehicle.gearUpCommand = this.controlState;
                break;
            }
            case AUTOPILOT: {
                vehicle.autopilot = this.controlState;
                break;
            }
            case CRUISECONTROL: {
                if (this.controlState) {
                    vehicle.cruiseControl = true;
                    vehicle.cruiseControlSpeed = vehicle.velocity;
                    break;
                }
                vehicle.cruiseControl = false;
                break;
            }
            case FLAPS: {
                vehicle.flapDesiredAngle = (short)PacketVehicleControlDigital.clampAngle(0, 350, vehicle.flapDesiredAngle + (this.controlState ? 50 : -50));
                break;
            }
            case TRIM_ROLL: {
                vehicle.aileronTrim = (short)PacketVehicleControlDigital.clampAngle(-100, 100, vehicle.aileronTrim + (this.controlState ? 1 : -1));
                break;
            }
            case TRIM_PITCH: {
                vehicle.elevatorTrim = (short)PacketVehicleControlDigital.clampAngle(-100, 100, vehicle.elevatorTrim + (this.controlState ? 1 : -1));
                break;
            }
            case TRIM_YAW: {
                vehicle.rudderTrim = (short)PacketVehicleControlDigital.clampAngle(-100, 100, vehicle.rudderTrim + (this.controlState ? 1 : -1));
                break;
            }
            case CUSTOM_0: {
                if (this.controlState) {
                    vehicle.customsOn.add((byte)0);
                    break;
                }
                vehicle.customsOn.remove((byte)0);
                break;
            }
            case CUSTOM_1: {
                if (this.controlState) {
                    vehicle.customsOn.add((byte)1);
                    break;
                }
                vehicle.customsOn.remove((byte)1);
                break;
            }
            case CUSTOM_2: {
                if (this.controlState) {
                    vehicle.customsOn.add((byte)2);
                    break;
                }
                vehicle.customsOn.remove((byte)2);
                break;
            }
            case CUSTOM_3: {
                if (this.controlState) {
                    vehicle.customsOn.add((byte)3);
                    break;
                }
                vehicle.customsOn.remove((byte)3);
            }
        }
        return true;
    }

    public static enum Controls {
        BRAKE,
        P_BRAKE,
        HORN,
        SIREN,
        SHIFT_UP,
        SHIFT_DN,
        TRAILER,
        REVERSE,
        GEAR,
        AUTOPILOT,
        CRUISECONTROL,
        FLAPS,
        TRIM_ROLL,
        TRIM_PITCH,
        TRIM_YAW,
        CUSTOM_0,
        CUSTOM_1,
        CUSTOM_2,
        CUSTOM_3;

    }
}

