/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.items.instances.ItemInstrument;
import minecrafttransportsimulator.jsondefs.JSONInstrument;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketVehicle;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;

public class PacketVehicleInstruments
extends APacketVehicle {
    private final byte slot;
    private final String instrumentPackID;
    private final String instrumentSystemName;

    public PacketVehicleInstruments(EntityVehicleF_Physics vehicle, byte slot, ItemInstrument instrument) {
        super(vehicle);
        this.slot = slot;
        if (instrument != null) {
            this.instrumentPackID = ((JSONInstrument)instrument.definition).packID;
            this.instrumentSystemName = ((JSONInstrument)instrument.definition).systemName;
        } else {
            this.instrumentPackID = "";
            this.instrumentSystemName = "";
        }
    }

    public PacketVehicleInstruments(ByteBuf buf) {
        super(buf);
        this.slot = buf.readByte();
        this.instrumentPackID = PacketVehicleInstruments.readStringFromBuffer(buf);
        this.instrumentSystemName = PacketVehicleInstruments.readStringFromBuffer(buf);
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeByte((int)this.slot);
        PacketVehicleInstruments.writeStringToBuffer(this.instrumentPackID, buf);
        PacketVehicleInstruments.writeStringToBuffer(this.instrumentSystemName, buf);
    }

    @Override
    public boolean handle(IWrapperWorld world, IWrapperPlayer player, EntityVehicleF_Physics vehicle) {
        ItemInstrument instrument;
        if (!world.isClient() && !player.isCreative() && vehicle.instruments.containsKey(this.slot)) {
            instrument = (ItemInstrument)vehicle.instruments.get(this.slot);
            if (!player.isCreative() && !player.getInventory().addItem(instrument, null)) {
                return false;
            }
        }
        if (this.instrumentPackID.isEmpty()) {
            vehicle.instruments.remove(this.slot);
        } else {
            instrument = (ItemInstrument)PackParserSystem.getItem(this.instrumentPackID, this.instrumentSystemName);
            if (!world.isClient() && !player.isCreative()) {
                if (player.isCreative() || player.getInventory().hasItem(instrument)) {
                    player.getInventory().removeItem(instrument, null);
                } else {
                    return false;
                }
            }
            vehicle.instruments.put(this.slot, instrument);
        }
        return true;
    }
}

