/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.IItemVehicleInteractable;
import minecrafttransportsimulator.items.instances.ItemPart;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketVehicle;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;

public class PacketVehicleInteract
extends APacketVehicle {
    private final Point3d hitPosition;
    private boolean rightClick;

    public PacketVehicleInteract(EntityVehicleF_Physics vehicle, Point3d hitPosition, boolean rightClick) {
        super(vehicle);
        this.hitPosition = hitPosition;
        this.rightClick = rightClick;
    }

    public PacketVehicleInteract(ByteBuf buf) {
        super(buf);
        this.hitPosition = PacketVehicleInteract.readPoint3dFromBuffer(buf);
        this.rightClick = buf.readBoolean();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        PacketVehicleInteract.writePoint3dToBuffer(this.hitPosition, buf);
        buf.writeBoolean(this.rightClick);
    }

    @Override
    public boolean handle(IWrapperWorld world, IWrapperPlayer player, EntityVehicleF_Physics vehicle) {
        boolean canPlayerEditVehicle;
        boolean bl = canPlayerEditVehicle = player.isOP() || vehicle.ownerUUID.isEmpty() || player.getUUID().equals(vehicle.ownerUUID);
        IItemVehicleInteractable.PlayerOwnerState ownerState = player.isOP() ? IItemVehicleInteractable.PlayerOwnerState.ADMIN : (canPlayerEditVehicle ? IItemVehicleInteractable.PlayerOwnerState.OWNER : IItemVehicleInteractable.PlayerOwnerState.USER);
        IWrapperItemStack heldStack = player.getHeldStack();
        AItemBase heldItem = heldStack.getItem();
        APart part = vehicle.getPartAtLocation(this.hitPosition);
        if (part == null) {
            for (Map.Entry partCollisionEntry : vehicle.partCollisionBoxes.entrySet()) {
                for (BoundingBox box : (List)partCollisionEntry.getValue()) {
                    if (!box.localCenter.equals(this.hitPosition)) continue;
                    part = (APart)partCollisionEntry.getKey();
                    break;
                }
                if (part == null) continue;
                break;
            }
        }
        if (heldItem instanceof IItemVehicleInteractable) {
            IItemVehicleInteractable.CallbackType callback = ((IItemVehicleInteractable)((Object)heldItem)).doVehicleInteraction(vehicle, part, player, ownerState, this.rightClick);
            if (callback.equals((Object)IItemVehicleInteractable.CallbackType.ALL)) {
                return true;
            }
            if (callback.equals((Object)IItemVehicleInteractable.CallbackType.PLAYER)) {
                player.sendPacket(this);
            }
        } else if (part != null) {
            if (this.rightClick) {
                part.interact(player);
            } else {
                part.attack(new Damage("player", 1.0, part.boundingBox, player));
            }
        } else {
            for (BoundingBox slotBox : vehicle.activePartSlotBoxes.keySet()) {
                if (!slotBox.localCenter.equals(this.hitPosition)) continue;
                if (!canPlayerEditVehicle) {
                    player.sendPacket(new PacketPlayerChatMessage("interact.failure.vehicleowned"));
                } else if (heldItem instanceof ItemPart && vehicle.addPartFromItem((ItemPart)heldItem, heldStack.getData(), this.hitPosition, false) && !player.isCreative()) {
                    player.getInventory().removeStack(heldStack, 1);
                }
                return false;
            }
            for (Map.Entry doorEntry : vehicle.doorBoxes.entrySet()) {
                if (!((BoundingBox)doorEntry.getKey()).localCenter.equals(this.hitPosition)) continue;
                if (vehicle.locked) {
                    player.sendPacket(new PacketPlayerChatMessage("interact.failure.vehiclelocked"));
                    continue;
                }
                if (vehicle.doorsOpen.contains(((JSONVehicle.VehicleDoor)doorEntry.getValue()).name)) {
                    vehicle.doorsOpen.remove(((JSONVehicle.VehicleDoor)doorEntry.getValue()).name);
                } else {
                    vehicle.doorsOpen.add(((JSONVehicle.VehicleDoor)doorEntry.getValue()).name);
                }
                return true;
            }
        }
        return false;
    }
}

