/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketVehicle;
import minecrafttransportsimulator.rendering.components.LightType;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;

public class PacketVehicleLightToggle
extends APacketVehicle {
    private final LightType lightType;

    public PacketVehicleLightToggle(EntityVehicleF_Physics vehicle, LightType lightType) {
        super(vehicle);
        this.lightType = lightType;
    }

    public PacketVehicleLightToggle(ByteBuf buf) {
        super(buf);
        this.lightType = LightType.values()[buf.readByte()];
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeByte(this.lightType.ordinal());
    }

    @Override
    public boolean handle(IWrapperWorld world, IWrapperPlayer player, EntityVehicleF_Physics vehicle) {
        if (vehicle.lightsOn.contains((Object)this.lightType)) {
            vehicle.lightsOn.remove((Object)this.lightType);
        } else {
            vehicle.lightsOn.add(this.lightType);
        }
        return true;
    }
}

