/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.items.instances.ItemPart;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.components.APacketVehiclePart;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;

public class PacketVehiclePartChange
extends APacketVehiclePart {
    private final ItemPart partItem;
    private final IWrapperNBT partData;
    private boolean clickedPart;
    private Point3d partClickedOffset;

    public PacketVehiclePartChange(EntityVehicleF_Physics vehicle, Point3d offset) {
        super(vehicle, offset);
        this.partItem = null;
        this.partData = null;
        this.partClickedOffset = null;
    }

    public PacketVehiclePartChange(EntityVehicleF_Physics vehicle, Point3d offset, ItemPart partItem, IWrapperNBT partData, APart partClicked) {
        super(vehicle, offset);
        this.partItem = partItem;
        this.partData = partData;
        this.clickedPart = partClicked != null;
        this.partClickedOffset = this.clickedPart ? partClicked.placementOffset : null;
    }

    public PacketVehiclePartChange(ByteBuf buf) {
        super(buf);
        if (buf.readBoolean()) {
            this.partItem = (ItemPart)PackParserSystem.getItem(PacketVehiclePartChange.readStringFromBuffer(buf), PacketVehiclePartChange.readStringFromBuffer(buf), PacketVehiclePartChange.readStringFromBuffer(buf));
            this.partData = MasterLoader.networkInterface.createDataFromBuffer(buf);
            this.clickedPart = buf.readBoolean();
            this.partClickedOffset = this.clickedPart ? PacketVehiclePartChange.readPoint3dFromBuffer(buf) : null;
        } else {
            this.partItem = null;
            this.partData = null;
            this.partClickedOffset = null;
        }
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        if (this.partItem != null) {
            buf.writeBoolean(true);
            PacketVehiclePartChange.writeStringToBuffer(((JSONPart)this.partItem.definition).packID, buf);
            PacketVehiclePartChange.writeStringToBuffer(((JSONPart)this.partItem.definition).systemName, buf);
            PacketVehiclePartChange.writeStringToBuffer(this.partItem.subName, buf);
            this.partData.writeToBuffer(buf);
            buf.writeBoolean(this.clickedPart);
            if (this.clickedPart) {
                PacketVehiclePartChange.writePoint3dToBuffer(this.partClickedOffset, buf);
            }
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public boolean handle(IWrapperWorld world, IWrapperPlayer player, EntityVehicleF_Physics vehicle, Point3d offset) {
        if (this.partItem == null) {
            vehicle.removePart(vehicle.getPartAtLocation(offset), (Iterator)null);
        } else {
            JSONVehicle.VehiclePart packVehicleDef = vehicle.getPackDefForLocation(offset);
            vehicle.addPart(this.partItem.createPart(vehicle, packVehicleDef, this.partData, vehicle.getPartAtLocation(this.partClickedOffset)));
        }
        return true;
    }
}

