/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.components.APacketVehiclePart;
import minecrafttransportsimulator.sound.SoundInstance;
import minecrafttransportsimulator.vehicles.main.AEntityBase;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.PartEngine;

public class PacketVehiclePartEngine
extends APacketVehiclePart {
    private final Signal packetType;
    private final double hours;
    private final boolean oilLeak;
    private final boolean fuelLeak;
    private final boolean brokenStarter;
    private final int linkedID;
    private final Point3d linkedPos;

    public PacketVehiclePartEngine(PartEngine engine, Signal packetType) {
        super(engine.vehicle, engine.placementOffset);
        this.packetType = packetType;
        this.hours = 0.0;
        this.oilLeak = false;
        this.fuelLeak = false;
        this.brokenStarter = false;
        this.linkedID = 0;
        this.linkedPos = null;
    }

    public PacketVehiclePartEngine(PartEngine engine, double hours, boolean oilLeak, boolean fuelLeak, boolean brokenStarter) {
        super(engine.vehicle, engine.placementOffset);
        this.packetType = Signal.DAMAGE;
        this.hours = hours;
        this.oilLeak = oilLeak;
        this.fuelLeak = fuelLeak;
        this.brokenStarter = brokenStarter;
        this.linkedID = 0;
        this.linkedPos = null;
    }

    public PacketVehiclePartEngine(PartEngine engine, PartEngine linkedEngine) {
        super(engine.vehicle, engine.placementOffset);
        this.packetType = Signal.LINK;
        this.hours = 0.0;
        this.oilLeak = false;
        this.fuelLeak = false;
        this.brokenStarter = false;
        this.linkedID = linkedEngine.vehicle.lookupID;
        this.linkedPos = linkedEngine.placementOffset;
    }

    public PacketVehiclePartEngine(ByteBuf buf) {
        super(buf);
        this.packetType = Signal.values()[buf.readByte()];
        if (this.packetType.equals((Object)Signal.DAMAGE)) {
            this.hours = buf.readDouble();
            this.oilLeak = buf.readBoolean();
            this.fuelLeak = buf.readBoolean();
            this.brokenStarter = buf.readBoolean();
        } else {
            this.hours = 0.0;
            this.oilLeak = false;
            this.fuelLeak = false;
            this.brokenStarter = false;
        }
        if (this.packetType.equals((Object)Signal.LINK)) {
            this.linkedID = buf.readInt();
            this.linkedPos = PacketVehiclePartEngine.readPoint3dFromBuffer(buf);
        } else {
            this.linkedID = 0;
            this.linkedPos = null;
        }
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeByte(this.packetType.ordinal());
        if (this.packetType.equals((Object)Signal.DAMAGE)) {
            buf.writeDouble(this.hours);
            buf.writeBoolean(this.oilLeak);
            buf.writeBoolean(this.fuelLeak);
            buf.writeBoolean(this.brokenStarter);
        } else if (this.packetType.equals((Object)Signal.LINK)) {
            buf.writeInt(this.linkedID);
            PacketVehiclePartEngine.writePoint3dToBuffer(this.linkedPos, buf);
        }
    }

    @Override
    public boolean handle(IWrapperWorld world, IWrapperPlayer player, EntityVehicleF_Physics vehicle, Point3d offset) {
        PartEngine engine = (PartEngine)vehicle.getPartAtLocation(offset);
        switch (this.packetType) {
            case MAGNETO_OFF: {
                engine.setMagnetoStatus(false);
                break;
            }
            case MAGNETO_ON: {
                engine.setMagnetoStatus(true);
                break;
            }
            case ES_OFF: {
                engine.setElectricStarterStatus(false);
                break;
            }
            case ES_ON: {
                engine.setElectricStarterStatus(true);
                break;
            }
            case HS_ON: {
                engine.handStartEngine();
                break;
            }
            case AS_ON: {
                engine.setMagnetoStatus(true);
                engine.rpm = 2500.0;
                engine.startEngine();
                break;
            }
            case BACKFIRE: {
                engine.backfireEngine();
                break;
            }
            case START: {
                engine.startEngine();
                break;
            }
            case FUEL_OUT: {
                engine.stallEngine(this.packetType);
                break;
            }
            case TOO_SLOW: {
                engine.stallEngine(this.packetType);
                break;
            }
            case DROWN: {
                engine.stallEngine(this.packetType);
                break;
            }
            case DAMAGE: {
                engine.hours += this.hours;
                if (this.fuelLeak) {
                    engine.fuelLeak = true;
                }
                if (this.oilLeak) {
                    engine.oilLeak = true;
                }
                if (!this.brokenStarter) break;
                engine.brokenStarter = true;
                break;
            }
            case BAD_SHIFT: {
                MasterLoader.audioInterface.playQuickSound(new SoundInstance(engine, MasterLoader.resourceDomain + ":engine_shifting_grinding"));
                break;
            }
            case LINK: {
                for (AEntityBase entity : AEntityBase.createdClientEntities) {
                    if (entity.lookupID != this.linkedID) continue;
                    for (PartEngine otherEngine : ((EntityVehicleF_Physics)entity).engines.values()) {
                        if (!otherEngine.placementOffset.equals(this.linkedPos)) continue;
                        otherEngine.linkedEngine = engine;
                        engine.linkedEngine = otherEngine;
                        return false;
                    }
                }
                break;
            }
        }
        return true;
    }

    public static enum Signal {
        MAGNETO_OFF,
        MAGNETO_ON,
        ES_OFF,
        ES_ON,
        HS_ON,
        AS_ON,
        BACKFIRE,
        START,
        FUEL_OUT,
        TOO_SLOW,
        DROWN,
        DAMAGE,
        BAD_SHIFT,
        LINK;

    }
}

